/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class SiteInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "site-context";
    private boolean storageModel = false;

    public SiteInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    protected IBaseModel createModel(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return this.createWorkspaceModel((IFileEditorInput)input);
        }
        if (input instanceof SystemFileEditorInput) {
            return this.createExternalModel((SystemFileEditorInput)input);
        }
        if (input instanceof IStorageEditorInput) {
            return this.createStorageModel((IStorageEditorInput)input);
        }
        return null;
    }

    private IBaseModel createWorkspaceModel(IFileEditorInput input) {
        InputStream stream = null;
        IFile file = input.getFile();
        try {
            stream = file.getContents(false);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
        WorkspaceSiteModel model = new WorkspaceSiteModel(file);
        try {
            model.load(stream, false);
        }
        catch (CoreException coreException) {}
        IPath buildPath = file.getProject().getFullPath().append(".sitebuild").append("sitebuild.xml");
        IFile buildFile = file.getWorkspace().getRoot().getFile(buildPath);
        WorkspaceSiteBuildModel buildModel = new WorkspaceSiteBuildModel(buildFile);
        try {
            buildModel.load();
        }
        catch (CoreException coreException) {}
        model.setBuildModel((ISiteBuildModel)buildModel);
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        return model;
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (this.storageModel) {
            model.dispose();
            if (buildModel != null) {
                buildModel.dispose();
            }
        }
        super.dispose();
    }

    private IBaseModel createExternalModel(SystemFileEditorInput input) {
        return null;
    }

    private IBaseModel createStorageModel(IStorageEditorInput input) {
        return null;
    }

    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isEditable()) {
            return;
        }
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            doc.set(swriter.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean synchronizeModel(IDocument doc) {
        ISiteModel model = (ISiteModel)this.getModel();
        boolean cleanModel = true;
        String text = doc.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected void reorderInsertEdits(ArrayList ops) {
    }
}

