/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.model.plugin;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.ui.model.IDocumentAttribute;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginAttribute;
import org.eclipse.pde.internal.ui.model.plugin.PluginDocumentNode;

public class PluginObjectNode
extends PluginDocumentNode
implements IPluginObject {
    private String fName;
    private boolean fInTheModel;
    private transient ISharedPluginModel fModel;

    public ISharedPluginModel getModel() {
        return this.fModel;
    }

    public IPluginModelBase getPluginModel() {
        return (IPluginModelBase)this.fModel;
    }

    public String getName() {
        return this.fName;
    }

    public boolean isInTheModel() {
        return this.fInTheModel;
    }

    public String getTranslatedName() {
        return this.getResourceString(this.getName());
    }

    public IPluginObject getParent() {
        return (IPluginObject)this.getParentNode();
    }

    public IPluginBase getPluginBase() {
        return this.fModel != null ? ((IPluginModelBase)this.fModel).getPluginBase() : null;
    }

    public String getResourceString(String key) {
        return this.fModel != null ? this.fModel.getResourceString(key) : key;
    }

    public void setName(String name) throws CoreException {
        this.fName = name;
    }

    public boolean isValid() {
        return false;
    }

    public void write(String indent, PrintWriter writer) {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setInTheModel(boolean inModel) {
        this.fInTheModel = inModel;
    }

    public void setModel(ISharedPluginModel model) {
        this.fModel = model;
    }

    public void setXMLAttribute(String name, String value) {
        String oldValue = this.getXMLAttributeValue(name);
        PluginAttribute attr = (PluginAttribute)this.fAttributes.get(name);
        try {
            if (value == null) {
                value = "";
            }
            if (attr == null) {
                attr = new PluginAttribute();
                attr.setName(name);
                attr.setEnclosingElement(this);
                this.fAttributes.put(name, attr);
            }
            attr.setValue(value == null ? "" : value);
        }
        catch (CoreException coreException) {}
        if (this.fInTheModel) {
            this.firePropertyChanged(attr.getEnclosingElement(), attr.getAttributeName(), oldValue, value);
        }
    }

    protected void firePropertyChanged(IDocumentNode node, String property, Object oldValue, Object newValue) {
        if (this.fModel.isEditable() && this.fModel instanceof IModelChangeProvider) {
            ISharedPluginModel provider = this.fModel;
            provider.fireModelObjectChanged((Object)node, property, oldValue, newValue);
        }
    }

    protected void fireStructureChanged(IPluginObject child, int changeType) {
        ISharedPluginModel model = this.getModel();
        if (model.isEditable() && model instanceof IModelChangeProvider) {
            ModelChangedEvent e = new ModelChangedEvent((IModelChangeProvider)this.fModel, changeType, new Object[]{child}, null);
            this.fireModelChanged((IModelChangedEvent)e);
        }
    }

    protected void fireModelChanged(IModelChangedEvent e) {
        ISharedPluginModel model = this.getModel();
        if (model.isEditable() && model instanceof IModelChangeProvider) {
            IModelChangeProvider provider = (IModelChangeProvider)model;
            provider.fireModelChanged(e);
        }
    }

    public String getWritableString(String source) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public String writeShallow(boolean terminate) {
        return "";
    }

    public String write(boolean indent) {
        return "";
    }

    protected void appendAttribute(StringBuffer buffer, String attrName) {
        this.appendAttribute(buffer, attrName, "");
    }

    protected void appendAttribute(StringBuffer buffer, String attrName, String defaultValue) {
        String value;
        IDocumentAttribute attr = this.getDocumentAttribute(attrName);
        if (attr != null && (value = attr.getAttributeValue()) != null && value.trim().length() > 0 && !value.equals(defaultValue)) {
            buffer.append(" " + attr.write());
        }
    }
}

