/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.UnusedDependenciesOperation;
import org.eclipse.pde.internal.ui.search.UnusedImportsDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UnusedDependenciesAction
extends Action {
    private IPluginModelBase model;

    public UnusedDependenciesAction(IPluginModelBase model) {
        this.model = model;
        this.setText(PDEPlugin.getResourceString("UnusedDependencies.action"));
    }

    public void run() {
        UnusedDependenciesOperation op = new UnusedDependenciesOperation(this.model);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
        }
        catch (Exception exception) {}
        IPluginImport[] unused = op.getUnusedDependencies();
        if (unused.length == 0) {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("UnusedDependencies.title"), (String)PDEPlugin.getResourceString("UnusedDependencies.notFound"));
        } else if (this.model.isEditable()) {
            UnusedImportsDialog dialog = new UnusedImportsDialog(PDEPlugin.getActiveWorkbenchShell(), this.model, unused);
            dialog.create();
            dialog.getShell().setText(PDEPlugin.getResourceString("UnusedDependencies.title"));
            dialog.open();
        } else {
            String lineSeparator = System.getProperty("line.separator");
            StringBuffer buffer = new StringBuffer(PDEPlugin.getResourceString("UnusedDependencies.found"));
            int i = 0;
            while (i < unused.length) {
                buffer.append(String.valueOf(lineSeparator) + unused[i].getId());
                ++i;
            }
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("UnusedDependencies.title"), (String)buffer.toString());
        }
    }
}

