/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.TemplateListSelectionPage;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewPluginProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String PLUGIN_POINT = "pluginContent";
    public static final String TAG_WIZARD = "wizard";
    public static final String DEF_PROJECT_NAME = "project_name";
    public static final String DEF_TEMPLATE_ID = "template-id";
    private IConfigurationElement fConfig;
    private PluginFieldData fPluginData;
    private IProjectProvider fProjectProvider;
    private NewProjectCreationPage fMainPage;
    private ContentPage fContentPage;
    private TemplateListSelectionPage fWizardListPage;

    public NewPluginProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEPlugin.getResourceString("NewProjectWizard.title"));
        this.setNeedsProgressMonitor(true);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fPluginData = new PluginFieldData();
    }

    public void addPages() {
        this.fMainPage = new NewProjectCreationPage("main", this.fPluginData, false);
        this.fMainPage.setTitle(PDEPlugin.getResourceString("NewProjectWizard.MainPage.title"));
        this.fMainPage.setDescription(PDEPlugin.getResourceString("NewProjectWizard.MainPage.desc"));
        String pname = this.getDefaultValue(DEF_PROJECT_NAME);
        if (pname != null) {
            this.fMainPage.setInitialProjectName(pname);
        }
        this.addPage((IWizardPage)this.fMainPage);
        this.fProjectProvider = new IProjectProvider(){

            public String getProjectName() {
                return NewPluginProjectWizard.this.fMainPage.getProjectName();
            }

            public IProject getProject() {
                return NewPluginProjectWizard.this.fMainPage.getProjectHandle();
            }

            public IPath getLocationPath() {
                return NewPluginProjectWizard.this.fMainPage.getLocationPath();
            }
        };
        this.fContentPage = new PluginContentPage("page2", this.fProjectProvider, this.fMainPage, this.fPluginData);
        this.fWizardListPage = new TemplateListSelectionPage(this.getAvailableCodegenWizards(), this.fContentPage, PDEPlugin.getResourceString("WizardListSelectionPage.templates"));
        String tid = this.getDefaultValue(DEF_TEMPLATE_ID);
        if (tid != null) {
            this.fWizardListPage.setInitialTemplateId(tid);
        }
        this.addPage((IWizardPage)this.fContentPage);
        this.addPage((IWizardPage)this.fWizardListPage);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page.isPageComplete() && page != this.fMainPage;
    }

    public boolean performFinish() {
        try {
            this.fMainPage.updateData();
            this.fContentPage.updateData();
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            IPluginContentWizard contentWizard = this.fWizardListPage.getSelectedWizard();
            this.getContainer().run(false, true, (IRunnableWithProgress)new NewProjectCreationOperation(this.fPluginData, this.fProjectProvider, contentWizard));
            return true;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfig = config;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        String className = config.getAttribute("class");
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        if (imageName != null) {
            IPluginDescriptor pd = config.getDeclaringExtension().getDeclaringPluginDescriptor();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pd, imageName);
            element.setImage(image);
        }
        return element;
    }

    public ElementList getAvailableCodegenWizards() {
        ElementList wizards = new ElementList("CodegenWizards");
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PDEPlugin.getPluginId(), PLUGIN_POINT);
        if (point == null) {
            return wizards;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                WizardElement element;
                if (elements[j].getName().equals(TAG_WIZARD) && (element = this.createWizardElement(elements[j])) != null) {
                    wizards.add(element);
                }
                ++j;
            }
            ++i;
        }
        return wizards;
    }
}

