/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IPluginFieldData;

public class PluginClassCodeGenerator {
    private IPluginFieldData fPluginData;
    private IProject fProject;
    private String fQualifiedClassName;

    public PluginClassCodeGenerator(IProject project, String qualifiedClassName, IPluginFieldData data) {
        this.fProject = project;
        this.fQualifiedClassName = qualifiedClassName;
        this.fPluginData = data;
    }

    public IFile generate(IProgressMonitor monitor) throws CoreException {
        int nameloc = this.fQualifiedClassName.lastIndexOf(46);
        String packageName = nameloc == -1 ? "" : this.fQualifiedClassName.substring(0, nameloc);
        String className = this.fQualifiedClassName.substring(nameloc + 1);
        Path path = new Path(packageName.replace('.', '/'));
        if (this.fPluginData.getSourceFolderName().trim().length() > 0) {
            path = new Path(this.fPluginData.getSourceFolderName()).append((IPath)path);
        }
        CoreUtility.createFolder((IFolder)this.fProject.getFolder((IPath)path), (boolean)true, (boolean)true, null);
        IFile file = this.fProject.getFile(path.append(String.valueOf(className) + ".java"));
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        if (this.fPluginData.isLegacy()) {
            this.generateLegacyPluginClass(packageName, className, writer);
        } else {
            this.generatePluginClass(packageName, className, writer);
        }
        writer.flush();
        try {
            swriter.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swriter.toString().getBytes(this.fProject.getDefaultCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, true, monitor);
            } else {
                file.create((InputStream)stream, false, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        return file;
    }

    private void generatePluginClass(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        if (this.fPluginData.isUIPlugin()) {
            writer.println("import org.eclipse.ui.plugin.*;");
        } else {
            writer.println("import org.eclipse.core.runtime.Plugin;");
        }
        writer.println("import org.osgi.framework.BundleContext;");
        writer.println("import java.util.*;");
        writer.println();
        writer.println("/**");
        writer.println(" * The main plugin class to be used in the desktop.");
        writer.println(" */");
        if (this.fPluginData.isUIPlugin()) {
            writer.println("public class " + className + " extends AbstractUIPlugin {");
        } else {
            writer.println("public class " + className + " extends Plugin {");
        }
        writer.println("\t//The shared instance.");
        writer.println("\tprivate static " + className + " plugin;");
        writer.println("\t//Resource bundle.");
        writer.println("\tprivate ResourceBundle resourceBundle;");
        writer.println("\t");
        writer.println("\t/**");
        writer.println("\t * The constructor.");
        writer.println("\t */");
        writer.println("\tpublic " + className + "() {");
        writer.println("\t\tsuper();");
        writer.println("\t\tplugin = this;");
        writer.println("\t\ttry {");
        writer.println("\t\t\tresourceBundle = ResourceBundle.getBundle(\"" + packageName + "." + className + "Resources\");");
        writer.println("\t\t} catch (MissingResourceException x) {");
        writer.println("\t\t\tresourceBundle = null;");
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * This method is called upon plug-in activation");
        writer.println("\t */");
        writer.println("\tpublic void start(BundleContext context) throws Exception {");
        writer.println("\t\tsuper.start(context);");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * This method is called when the plug-in is stopped");
        writer.println("\t */");
        writer.println("\tpublic void stop(BundleContext context) throws Exception {");
        writer.println("\t\tsuper.stop(context);");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * Returns the shared instance.");
        writer.println("\t */");
        writer.println("\tpublic static " + className + " getDefault() {");
        writer.println("\t\treturn plugin;");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * Returns the string from the plugin's resource bundle,");
        writer.println("\t * or 'key' if not found.");
        writer.println("\t */");
        writer.println("\tpublic static String getResourceString(String key) {");
        writer.println("\t\tResourceBundle bundle = " + className + ".getDefault().getResourceBundle();");
        writer.println("\t\ttry {");
        writer.println("\t\t\treturn (bundle != null) ? bundle.getString(key) : key;");
        writer.println("\t\t} catch (MissingResourceException e) {");
        writer.println("\t\t\treturn key;");
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * Returns the plugin's resource bundle,");
        writer.println("\t */");
        writer.println("\tpublic ResourceBundle getResourceBundle() {");
        writer.println("\t\treturn resourceBundle;");
        writer.println("\t}");
        writer.println("}");
    }

    private void generateLegacyPluginClass(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        if (this.fPluginData.isUIPlugin()) {
            writer.println("import org.eclipse.ui.plugin.*;");
        }
        writer.println("import org.eclipse.core.runtime.*;");
        writer.println("import java.util.*;");
        writer.println();
        writer.println("/**");
        writer.println(" * The main plugin class to be used in the desktop.");
        writer.println(" */");
        if (this.fPluginData.isUIPlugin()) {
            writer.println("public class " + className + " extends AbstractUIPlugin {");
        } else {
            writer.println("public class " + className + " extends Plugin {");
        }
        writer.println("\t//The shared instance.");
        writer.println("\tprivate static " + className + " plugin;");
        writer.println("\t//Resource bundle.");
        writer.println("\tprivate ResourceBundle resourceBundle;");
        writer.println("\t");
        writer.println("\t/**");
        writer.println("\t * The constructor.");
        writer.println("\t */");
        writer.println("\tpublic " + className + "(IPluginDescriptor descriptor) {");
        writer.println("\t\tsuper(descriptor);");
        writer.println("\t\tplugin = this;");
        writer.println("\t\ttry {");
        writer.println("\t\t\tresourceBundle   = ResourceBundle.getBundle(\"" + packageName + "." + className + "Resources\");");
        writer.println("\t\t} catch (MissingResourceException x) {");
        writer.println("\t\t\tresourceBundle = null;");
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * Returns the shared instance.");
        writer.println("\t */");
        writer.println("\tpublic static " + className + " getDefault() {");
        writer.println("\t\treturn plugin;");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * Returns the string from the plugin's resource bundle,");
        writer.println("\t * or 'key' if not found.");
        writer.println("\t */");
        writer.println("\tpublic static String getResourceString(String key) {");
        writer.println("\t\tResourceBundle bundle = " + className + ".getDefault().getResourceBundle();");
        writer.println("\t\ttry {");
        writer.println("\t\t\treturn (bundle != null) ? bundle.getString(key) : key;");
        writer.println("\t\t} catch (MissingResourceException e) {");
        writer.println("\t\t\treturn key;");
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * Returns the plugin's resource bundle,");
        writer.println("\t */");
        writer.println("\tpublic ResourceBundle getResourceBundle() {");
        writer.println("\t\treturn resourceBundle;");
        writer.println("\t}");
        writer.println("}");
    }

    public IPluginReference[] getDependencies() {
        ArrayList<PluginReference> result = new ArrayList<PluginReference>();
        if (this.fPluginData.isUIPlugin()) {
            result.add(new PluginReference("org.eclipse.ui", null, 0));
        }
        if (!this.fPluginData.isLegacy()) {
            result.add(new PluginReference("org.eclipse.core.runtime", null, 0));
        }
        return result.toArray(new IPluginReference[result.size()]);
    }
}

