/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.TemplateOption;

public class PreferencePageTemplate
extends PDETemplateSection {
    private static final String NL_TITLE = "PreferencePageTemplate.title";
    private static final String NL_DESC = "PreferencePageTemplate.desc";
    private static final String NL_PACKAGE_NAME = "PreferencePageTemplate.packageName";
    private static final String NL_CLASS_NAME = "PreferencePageTemplate.className";
    private static final String NL_PAGE_NAME = "PreferencePageTemplate.pageName";
    private static final String NL_DEFAULT_PAGE_NAME = "PreferencePageTemplate.defaultPageName";
    private String mainClassName;

    public PreferencePageTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public String getSectionId() {
        return "preferences";
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    private void createOptions() {
        this.addOption("packageName", PDEPlugin.getResourceString(NL_PACKAGE_NAME), null, 0);
        this.addOption("pageClassName", PDEPlugin.getResourceString(NL_CLASS_NAME), "SamplePreferencePage", 0);
        this.addOption("pageName", PDEPlugin.getResourceString(NL_PAGE_NAME), PDEPlugin.getResourceString(NL_DEFAULT_PAGE_NAME), 0);
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", String.valueOf(id) + ".preferences");
        this.mainClassName = String.valueOf(id) + ".PreferenceClass";
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", String.valueOf(pluginId) + ".preferences");
        if (model instanceof IPluginModel) {
            IPlugin plugin = (IPlugin)model.getPluginBase();
            this.mainClassName = plugin.getClassName();
        }
    }

    public String getReplacementString(String fileName, String key) {
        if (key.equals("fullPluginClassName")) {
            return this.mainClassName;
        }
        if (key.equals("pluginClassName")) {
            return this.getPluginClassName();
        }
        return super.getReplacementString(fileName, key);
    }

    private String getPluginClassName() {
        int dot = this.mainClassName.lastIndexOf(46);
        if (dot != -1) {
            return this.mainClassName.substring(dot + 1);
        }
        return this.mainClassName;
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    public void addDefaultOption(boolean val) {
        this.addOption("hasDefault", null, val, 0);
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_preference_page");
        page.setTitle(PDEPlugin.getResourceString(NL_TITLE));
        page.setDescription(PDEPlugin.getResourceString(NL_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.resetPageState();
        }
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.preferencePages";
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(this.getUsedExtensionPoint(), true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        String fullClassName = String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption("pageClassName");
        IPluginElement pageElement = factory.createElement((IPluginObject)extension);
        pageElement.setName("page");
        pageElement.setAttribute("id", fullClassName);
        pageElement.setAttribute("name", this.getStringOption("pageName"));
        pageElement.setAttribute("class", fullClassName);
        extension.add((IPluginObject)pageElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }
}

