/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.BooleanOption;
import org.eclipse.pde.ui.templates.TemplateOption;

public class ViewTemplate
extends PDETemplateSection {
    private static final String NL_TITLE0 = "ViewTemplate.title0";
    private static final String NL_DESC0 = "ViewTemplate.desc0";
    private static final String NL_TITLE1 = "ViewTemplate.title1";
    private static final String NL_DESC1 = "ViewTemplate.desc1";
    private static final String NL_PACKAGE_NAME = "ViewTemplate.packageName";
    private static final String NL_CLASS_NAME = "ViewTemplate.className";
    private static final String NL_NAME = "ViewTemplate.name";
    private static final String NL_DEFAULT_NAME = "ViewTemplate.defaultName";
    private static final String NL_CATEGORY_ID = "ViewTemplate.categoryId";
    private static final String NL_CATEGORY_NAME = "ViewTemplate.categoryName";
    private static final String NL_DEFAULT_CATEGORY_NAME = "ViewTemplate.defaultCategoryName";
    private static final String NL_SELECT = "ViewTemplate.select";
    private static final String NL_TABLE = "ViewTemplate.table";
    private static final String NL_TREE = "ViewTemplate.tree";
    private static final String NL_DOUBLE_CLICK = "ViewTemplate.doubleClick";
    private static final String NL_POPUP = "ViewTemplate.popup";
    private static final String NL_TOOLBAR = "ViewTemplate.toolbar";
    private static final String NL_PULLDOWN = "ViewTemplate.pulldown";
    private static final String NL_SORTING = "ViewTemplate.sorting";
    private static final String NL_DRILLDOWN = "ViewTemplate.drilldown";
    private static final String NL_ADD_TO_PERSPECTIVE = "ViewTemplate.addToPerspective";
    private BooleanOption addToPerspective;

    public ViewTemplate() {
        this.setPageCount(2);
        this.createOptions();
    }

    public String getSectionId() {
        return "view";
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    private void createOptions() {
        this.addOption("packageName", PDEPlugin.getResourceString(NL_PACKAGE_NAME), null, 0);
        this.addOption("className", PDEPlugin.getResourceString(NL_CLASS_NAME), "SampleView", 0);
        this.addOption("viewName", PDEPlugin.getResourceString(NL_NAME), PDEPlugin.getResourceString(NL_DEFAULT_NAME), 0);
        this.addOption("viewCategoryId", PDEPlugin.getResourceString(NL_CATEGORY_ID), null, 0);
        this.addOption("viewCategoryName", PDEPlugin.getResourceString(NL_CATEGORY_NAME), PDEPlugin.getResourceString(NL_DEFAULT_CATEGORY_NAME), 0);
        this.addOption("viewType", PDEPlugin.getResourceString(NL_SELECT), new String[][]{{"tableViewer", PDEPlugin.getResourceString(NL_TABLE)}, {"treeViewer", PDEPlugin.getResourceString(NL_TREE)}}, "tableViewer", 0);
        this.addToPerspective = (BooleanOption)this.addOption("addToPerspective", PDEPlugin.getResourceString(NL_ADD_TO_PERSPECTIVE), true, 0);
        this.addOption("doubleClick", PDEPlugin.getResourceString(NL_DOUBLE_CLICK), true, 1);
        this.addOption("popup", PDEPlugin.getResourceString(NL_POPUP), true, 1);
        this.addOption("localToolbar", PDEPlugin.getResourceString(NL_TOOLBAR), true, 1);
        this.addOption("localPulldown", PDEPlugin.getResourceString(NL_PULLDOWN), true, 1);
        this.addOption("sorter", PDEPlugin.getResourceString(NL_SORTING), true, 1);
        this.addOption("drillDown", PDEPlugin.getResourceString(NL_DRILLDOWN), true, 1);
        this.setOptionEnabled("drillDown", false);
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", String.valueOf(id) + ".views");
        this.initializeOption("viewCategoryId", id);
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", String.valueOf(pluginId) + ".views");
        this.initializeOption("viewCategoryId", pluginId);
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    public void addPages(Wizard wizard) {
        WizardPage page0 = this.createPage(0, "org.eclipse.pde.doc.user.template_view");
        page0.setTitle(PDEPlugin.getResourceString(NL_TITLE0));
        page0.setDescription(PDEPlugin.getResourceString(NL_DESC0));
        wizard.addPage((IWizardPage)page0);
        WizardPage page1 = this.createPage(1, "org.eclipse.pde.doc.user.template_view");
        page1.setTitle(PDEPlugin.getResourceString(NL_TITLE1));
        page1.setDescription(PDEPlugin.getResourceString(NL_DESC1));
        wizard.addPage((IWizardPage)page1);
        this.markPagesAdded();
    }

    public void validateOptions(TemplateOption source) {
        String viewType = this.getValue("viewType").toString();
        this.setOptionEnabled("drillDown", viewType.equals("treeViewer"));
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] allPageOptions = this.getOptions(0);
        int i = 0;
        while (i < allPageOptions.length) {
            TemplateOption nextOption = allPageOptions[i];
            if (nextOption.isRequired() && nextOption.isEmpty()) {
                this.flagMissingRequiredOption(nextOption);
                return;
            }
            ++i;
        }
        this.resetPageState();
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.views";
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension("org.eclipse.ui.views", true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        String cid = this.getStringOption("viewCategoryId");
        this.createCategory(extension, cid);
        String fullClassName = String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption("className");
        IPluginElement viewElement = factory.createElement((IPluginObject)extension);
        viewElement.setName("view");
        viewElement.setAttribute("id", fullClassName);
        viewElement.setAttribute("name", this.getStringOption("viewName"));
        viewElement.setAttribute("icon", "icons/sample.gif");
        viewElement.setAttribute("class", fullClassName);
        viewElement.setAttribute("category", cid);
        extension.add((IPluginObject)viewElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
        if (this.addToPerspective.isSelected()) {
            IPluginExtension perspectiveExtension = this.createExtension("org.eclipse.ui.perspectiveExtensions", true);
            IPluginElement perspectiveElement = factory.createElement((IPluginObject)perspectiveExtension);
            perspectiveElement.setName("perspectiveExtension");
            perspectiveElement.setAttribute("targetID", "org.eclipse.ui.resourcePerspective");
            IPluginElement view = factory.createElement((IPluginObject)perspectiveElement);
            view.setName("view");
            view.setAttribute("id", fullClassName);
            view.setAttribute("relative", "org.eclipse.ui.views.TaskList");
            view.setAttribute("relationship", "right");
            view.setAttribute("ratio", "0.5");
            perspectiveElement.add((IPluginObject)view);
            perspectiveExtension.add((IPluginObject)perspectiveElement);
            if (!perspectiveExtension.isInTheModel()) {
                plugin.add(perspectiveExtension);
            }
        }
    }

    private void createCategory(IPluginExtension extension, String id) throws CoreException {
        IPluginObject[] elements = extension.getChildren();
        int i = 0;
        while (i < elements.length) {
            String cid;
            IPluginAttribute att;
            IPluginElement element = (IPluginElement)elements[i];
            if (element.getName().equalsIgnoreCase("category") && (att = element.getAttribute("id")) != null && (cid = att.getValue()) != null && cid.equals(id)) {
                return;
            }
            ++i;
        }
        IPluginElement categoryElement = this.model.getFactory().createElement((IPluginObject)extension);
        categoryElement.setName("category");
        categoryElement.setAttribute("name", this.getStringOption("viewCategoryName"));
        categoryElement.setAttribute("id", id);
        extension.add((IPluginObject)categoryElement);
    }

    public String[] getNewFiles() {
        return new String[]{"icons/"};
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        ArrayList<PluginReference> result = new ArrayList<PluginReference>();
        if (schemaVersion != null) {
            result.add(new PluginReference("org.eclipse.core.runtime", null, 0));
        }
        result.add(new PluginReference("org.eclipse.ui", null, 0));
        return result.toArray(new IPluginReference[result.size()]);
    }
}

