/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IInstallConfigurationChangedListener;
import org.eclipse.update.configuration.LocalSystemInfo;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.IDynamicPage;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class TargetPage
extends BannerPage
implements IDynamicPage {
    private TableViewer jobViewer;
    private TableViewer siteViewer;
    private IInstallConfiguration config;
    private ConfigListener configListener;
    private Label requiredSpaceLabel;
    private Label availableSpaceLabel;
    private IInstallFeatureOperation[] jobs;
    private Button addButton;
    private Button deleteButton;
    private HashSet added;

    public TargetPage(IInstallConfiguration config) {
        super("Target");
        this.setTitle(UpdateUI.getString("InstallWizard.TargetPage.title"));
        this.setDescription(UpdateUI.getString("InstallWizard.TargetPage.desc"));
        this.config = config;
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.configListener = new ConfigListener();
    }

    public void setJobs(IInstallFeatureOperation[] jobs) {
        this.jobs = jobs;
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        this.config.removeInstallConfigurationChangedListener((IInstallConfigurationChangedListener)this.configListener);
        super.dispose();
    }

    public Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Label label = new Label(client, 0);
        label.setText(UpdateUI.getString("InstallWizard.TargetPage.jobsLabel"));
        label = new Label(client, 0);
        label.setText(UpdateUI.getString("InstallWizard.TargetPage.siteLabel"));
        new Label(client, 0);
        this.createJobViewer(client);
        this.createSiteViewer(client);
        Composite buttonContainer = new Composite(client, 0);
        GridLayout blayout = new GridLayout();
        blayout.marginHeight = 0;
        blayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)blayout);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonContainer, 8);
        this.addButton.setText(UpdateUI.getString("InstallWizard.TargetPage.new"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPage.this.addTargetLocation();
            }
        });
        this.addButton.setEnabled(false);
        this.addButton.setLayoutData((Object)new GridData(64));
        SWTUtil.setButtonDimensionHint(this.addButton);
        this.deleteButton = new Button(buttonContainer, 8);
        this.deleteButton.setText(UpdateUI.getString("InstallWizard.TargetPage.delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TargetPage.this.removeSelection();
                }
                catch (CoreException ex) {
                    UpdateUI.logException(ex);
                }
            }
        });
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(64));
        SWTUtil.setButtonDimensionHint(this.deleteButton);
        Composite status = new Composite(client, 0);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        status.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        status.setLayout((Layout)layout);
        label = new Label(status, 0);
        label.setText(UpdateUI.getString("InstallWizard.TargetPage.requiredSpace"));
        this.requiredSpaceLabel = new Label(status, 0);
        this.requiredSpaceLabel.setLayoutData((Object)new GridData(768));
        label = new Label(status, 0);
        label.setText(UpdateUI.getString("InstallWizard.TargetPage.availableSpace"));
        this.availableSpaceLabel = new Label(status, 0);
        this.availableSpaceLabel.setLayoutData((Object)new GridData(768));
        WorkbenchHelp.setHelp((Control)client, (String)"org.eclipse.update.ui.MultiTargetPage2");
        Dialog.applyDialogFont((Control)parent);
        return client;
    }

    private void createJobViewer(Composite parent) {
        this.jobViewer = new TableViewer(parent, 2816);
        GridData gd = new GridData(1808);
        gd.widthHint = 150;
        this.jobViewer.getTable().setLayoutData((Object)gd);
        this.jobViewer.setContentProvider((IContentProvider)new JobsContentProvider());
        this.jobViewer.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.jobViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IInstallFeatureOperation job = (IInstallFeatureOperation)selection.getFirstElement();
                if (job != null) {
                    TargetPage.this.siteViewer.setInput((Object)job);
                    IConfiguredSite affinitySite = UpdateUtils.getDefaultTargetSite((IInstallConfiguration)TargetPage.this.config, (IInstallFeatureOperation)job, (boolean)true);
                    TargetPage.this.addButton.setEnabled(affinitySite == null);
                    if (job.getTargetSite() != null) {
                        TargetPage.this.siteViewer.setSelection((ISelection)new StructuredSelection((Object)job.getTargetSite()));
                    }
                }
            }
        });
    }

    private void createSiteViewer(Composite parent) {
        this.siteViewer = new TableViewer(parent, 2816);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        this.siteViewer.getTable().setLayoutData((Object)gd);
        this.siteViewer.setContentProvider((IContentProvider)new SitesContentProvider());
        this.siteViewer.setLabelProvider((IBaseLabelProvider)new SitesLabelProvider());
        this.siteViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object obj) {
                IInstallFeatureOperation job = (IInstallFeatureOperation)TargetPage.this.siteViewer.getInput();
                return TargetPage.this.getSiteVisibility((IConfiguredSite)obj, job);
            }
        });
        this.siteViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                TargetPage.this.selectTargetSite(ssel);
                TargetPage.this.updateDeleteButton(ssel);
            }
        });
        if (this.config != null) {
            this.config.addInstallConfigurationChangedListener((IInstallConfigurationChangedListener)this.configListener);
        }
    }

    private void updateDeleteButton(IStructuredSelection selection) {
        boolean enable;
        boolean bl = enable = this.added != null && !this.added.isEmpty();
        if (enable) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                if (this.added.contains(iter.next())) continue;
                enable = false;
                break;
            }
        }
        this.deleteButton.setEnabled(enable);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializeDefaultTargetSites();
            this.jobViewer.setInput((Object)this.jobs);
            if (this.jobViewer.getSelection().isEmpty() && this.jobs.length > 0) {
                this.jobViewer.setSelection((ISelection)new StructuredSelection((Object)this.jobs[0]));
            }
        }
        super.setVisible(visible);
    }

    private void verifyNotEmpty(boolean empty) {
        String errorMessage = null;
        if (empty) {
            errorMessage = UpdateUI.getString("InstallWizard.TargetPage.location.empty");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(!empty);
    }

    private void selectTargetSite(IStructuredSelection selection) {
        IConfiguredSite site = (IConfiguredSite)selection.getFirstElement();
        IInstallFeatureOperation job = (IInstallFeatureOperation)this.siteViewer.getInput();
        if (job != null) {
            if (site != null) {
                job.setTargetSite(site);
            }
            this.pageChanged();
        }
        this.updateStatus(site);
    }

    private void addTargetLocation() {
        DirectoryDialog dd = new DirectoryDialog(this.getContainer().getShell());
        dd.setMessage(UpdateUI.getString("InstallWizard.TargetPage.location.message"));
        String path = dd.open();
        if (path != null) {
            this.addConfiguredSite(this.getContainer().getShell(), this.config, new File(path));
        }
    }

    private void removeSelection() throws CoreException {
        IStructuredSelection selection = (IStructuredSelection)this.siteViewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IConfiguredSite targetSite = (IConfiguredSite)iter.next();
            this.config.removeConfiguredSite(targetSite);
        }
    }

    private IConfiguredSite addConfiguredSite(Shell shell, IInstallConfiguration config, File file) {
        try {
            IConfiguredSite csite = config.createConfiguredSite(file);
            IStatus status = csite.verifyUpdatableStatus();
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            config.addConfiguredSite(csite);
            return csite;
        }
        catch (CoreException e) {
            String title = UpdateUI.getString("InstallWizard.TargetPage.location.error.title");
            ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)e.getStatus());
            UpdateUI.logException(e);
            return null;
        }
    }

    private void updateStatus(Object element) {
        if (element == null) {
            this.requiredSpaceLabel.setText("");
            this.availableSpaceLabel.setText("");
            return;
        }
        IConfiguredSite site = (IConfiguredSite)element;
        File file = new File(site.getSite().getURL().getFile());
        long available = LocalSystemInfo.getFreeSpace((File)file);
        long required = this.computeRequiredSizeFor(site);
        if (required == -1L) {
            this.requiredSpaceLabel.setText(UpdateUI.getString("InstallWizard.TargetPage.unknownSize"));
        } else {
            this.requiredSpaceLabel.setText(UpdateUI.getFormattedMessage("InstallWizard.TargetPage.size", "" + required));
        }
        if (available == -1L) {
            this.availableSpaceLabel.setText(UpdateUI.getString("InstallWizard.TargetPage.unknownSize"));
        } else {
            this.availableSpaceLabel.setText(UpdateUI.getFormattedMessage("InstallWizard.TargetPage.size", "" + available));
        }
    }

    private long computeRequiredSizeFor(IConfiguredSite site) {
        long totalSize = 0L;
        int i = 0;
        while (i < this.jobs.length) {
            if (site.equals(this.jobs[i].getTargetSite())) {
                long jobSize = site.getSite().getInstallSizeFor(this.jobs[i].getFeature());
                if (jobSize == -1L) {
                    return -1L;
                }
                totalSize += jobSize;
            }
            ++i;
        }
        return totalSize;
    }

    private void pageChanged() {
        boolean empty = false;
        int i = 0;
        while (this.jobs != null && i < this.jobs.length) {
            if (this.jobs[i].getTargetSite() == null) {
                empty = true;
                break;
            }
            IFeature feature = this.jobs[i].getFeature();
            if (feature.isPatch()) {
                IInstallFeatureOperation patchedFeatureJob = this.findPatchedFeature(feature);
                if (patchedFeatureJob != null && patchedFeatureJob.getTargetSite() != null && !this.jobs[i].getTargetSite().equals(patchedFeatureJob.getTargetSite())) {
                    String msg = UpdateUI.getFormattedMessage("InstallWizard.TargetPage.patchError", new String[]{feature.getLabel(), patchedFeatureJob.getFeature().getLabel()});
                    this.setErrorMessage(msg);
                    this.setPageComplete(false);
                    return;
                }
                IFeature patchedFeature = UpdateUtils.getPatchedFeature((IFeature)feature);
                if (patchedFeature != null && !this.jobs[i].getTargetSite().equals(patchedFeature.getSite().getCurrentConfiguredSite())) {
                    String msg = UpdateUI.getFormattedMessage("InstallWizard.TargetPage.patchError2", new String[]{feature.getLabel(), patchedFeature.getLabel(), patchedFeature.getSite().getCurrentConfiguredSite().getSite().getURL().getFile()});
                    this.setErrorMessage(msg);
                    this.setPageComplete(false);
                    return;
                }
            }
            ++i;
        }
        this.verifyNotEmpty(empty);
    }

    void removeAddedSites() {
        if (this.added != null) {
            while (!this.added.isEmpty()) {
                Iterator it = this.added.iterator();
                if (!it.hasNext()) continue;
                this.config.removeConfiguredSite((IConfiguredSite)it.next());
            }
        }
    }

    private boolean getSiteVisibility(IConfiguredSite site, IInstallFeatureOperation job) {
        if (!site.isUpdatable()) {
            return false;
        }
        IConfiguredSite affinitySite = UpdateUtils.getAffinitySite((IInstallConfiguration)this.config, (IFeature)job.getFeature());
        if (affinitySite != null) {
            return site.getSite().equals(affinitySite.getSite());
        }
        if (job.getOldFeature() != null) {
            IConfiguredSite oldSite = UpdateUtils.getSiteWithFeature((IInstallConfiguration)this.config, (String)job.getOldFeature().getVersionedIdentifier().getIdentifier());
            return site == oldSite;
        }
        return true;
    }

    private void initializeDefaultTargetSites() {
        int i = 0;
        while (i < this.jobs.length) {
            if (this.jobs[i].getTargetSite() == null) {
                IConfiguredSite affinitySite = UpdateUtils.getAffinitySite((IInstallConfiguration)this.config, (IFeature)this.jobs[i].getFeature());
                if (affinitySite != null) {
                    this.jobs[i].setTargetSite(affinitySite);
                } else {
                    IConfiguredSite defaultSite = UpdateUtils.getDefaultTargetSite((IInstallConfiguration)this.config, (IInstallFeatureOperation)this.jobs[i], (boolean)false);
                    if (defaultSite != null) {
                        this.jobs[i].setTargetSite(defaultSite);
                    } else {
                        this.jobs[i].setTargetSite(this.getFirstTargetSite(this.jobs[i]));
                    }
                }
            }
            ++i;
        }
    }

    private IConfiguredSite getFirstTargetSite(IInstallFeatureOperation job) {
        IConfiguredSite[] sites = this.config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IConfiguredSite csite = sites[i];
            if (this.getSiteVisibility(csite, job)) {
                return csite;
            }
            ++i;
        }
        return null;
    }

    public IInstallFeatureOperation findPatchedFeature(IFeature patch) {
        int i = 0;
        while (i < this.jobs.length) {
            IFeature target = this.jobs[i].getFeature();
            if (!target.equals(patch) && UpdateUtils.isPatch((IFeature)target, (IFeature)patch)) {
                return this.jobs[i];
            }
            ++i;
        }
        return null;
    }

    class JobsContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        JobsContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TargetPage.this.jobs;
        }
    }

    class SitesContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        SitesContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TargetPage.this.config.getConfiguredSites();
        }
    }

    class JobsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        JobsLabelProvider() {
        }

        public Image getColumnImage(Object obj, int col) {
            UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
            IInstallFeatureOperation job = (IInstallFeatureOperation)obj;
            ImageDescriptor base = job.getFeature().isPatch() ? UpdateUIImages.DESC_EFIX_OBJ : UpdateUIImages.DESC_FEATURE_OBJ;
            int flags = 0;
            if (job.getTargetSite() == null) {
                flags = 1;
            }
            return provider.get(base, flags);
        }

        public String getColumnText(Object obj, int col) {
            if (col == 0) {
                IFeature feature = ((IInstallFeatureOperation)obj).getFeature();
                return String.valueOf(feature.getLabel()) + " " + feature.getVersionedIdentifier().getVersion().toString();
            }
            return null;
        }
    }

    class SitesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SitesLabelProvider() {
        }

        public Image getColumnImage(Object obj, int col) {
            UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
            return provider.getLocalSiteImage((IConfiguredSite)obj);
        }

        public String getColumnText(Object obj, int col) {
            if (col == 0) {
                ISite site = ((IConfiguredSite)obj).getSite();
                return new File(site.getURL().getFile()).toString();
            }
            return null;
        }
    }

    class ConfigListener
    implements IInstallConfigurationChangedListener {
        ConfigListener() {
        }

        public void installSiteAdded(IConfiguredSite csite) {
            TargetPage.this.siteViewer.add((Object)csite);
            if (TargetPage.this.added == null) {
                TargetPage.this.added = new HashSet();
            }
            TargetPage.this.added.add(csite);
            int i = 0;
            while (TargetPage.this.jobs != null && i < TargetPage.this.jobs.length) {
                if (TargetPage.this.jobs[i].getTargetSite() == null && TargetPage.this.getSiteVisibility(csite, TargetPage.this.jobs[i])) {
                    TargetPage.this.jobs[i].setTargetSite(csite);
                }
                ++i;
            }
            TargetPage.this.jobViewer.refresh();
            TargetPage.this.siteViewer.setSelection((ISelection)new StructuredSelection((Object)csite));
            TargetPage.this.siteViewer.getControl().setFocus();
        }

        public void installSiteRemoved(IConfiguredSite csite) {
            TargetPage.this.siteViewer.remove((Object)csite);
            if (TargetPage.this.added != null) {
                TargetPage.this.added.remove(csite);
            }
            boolean refreshJobs = false;
            int i = 0;
            while (TargetPage.this.jobs != null && i < TargetPage.this.jobs.length) {
                if (TargetPage.this.jobs[i].getTargetSite() == csite) {
                    TargetPage.this.jobs[i].setTargetSite(null);
                    refreshJobs = true;
                }
                ++i;
            }
            TargetPage.this.pageChanged();
            TargetPage.this.jobViewer.refresh();
            if (refreshJobs) {
                TargetPage.this.jobViewer.getControl().setFocus();
            } else {
                TargetPage.this.siteViewer.getControl().setFocus();
            }
        }
    }
}

