/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.builders.ISchemaTransformer;
import org.eclipse.pde.internal.builders.SchemaHandler;
import org.eclipse.pde.internal.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.FileSchemaDescriptor;

public class ExtensionPointSchemaBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDERS_SCHEMA_COMPILING = "Builders.Schema.compiling";
    public static final String BUILDERS_SCHEMA_COMPILING_SCHEMAS = "Builders.Schema.compilingSchemas";
    public static final String BUILDERS_UPDATING = "Builders.updating";
    public static final String BUILDERS_SCHEMA_REMOVING = "Builders.Schema.removing";
    private ISchemaTransformer transformer = new SchemaTransformer();
    private URL cssURL = null;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            IProject project = this.getProject();
            if (!this.isInterestingProject(project)) {
                return null;
            }
            this.compileSchemasIn((IContainer)project, monitor);
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        }
        return null;
    }

    private boolean isInterestingProject(IProject project) {
        if (!PDE.hasPluginNature(project)) {
            return false;
        }
        return !WorkspaceModelManager.isBinaryPluginProject((IProject)project);
    }

    private void compileFile(IFile file, IProgressMonitor monitor) {
        String message = PDE.getFormattedMessage(BUILDERS_SCHEMA_COMPILING, file.getFullPath().toString());
        monitor.subTask(message);
        SchemaHandler reporter = new SchemaHandler(file);
        String outputFileName = this.getOutputFileName(file);
        IWorkspace workspace = file.getWorkspace();
        Path outputPath = new Path(outputFileName);
        try {
            InputStream source = file.getContents(false);
            StringWriter stringWriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(stringWriter);
            FileSchemaDescriptor desc = new FileSchemaDescriptor(file);
            this.transform((ISchemaDescriptor)desc, source, pwriter, reporter, this.cssURL);
            stringWriter.close();
            if (reporter.getErrorCount() == 0 && CompilerFlags.getBoolean("compilers.s.create-docs")) {
                String docLocation = this.getDocLocation();
                this.ensureFoldersExist(file.getProject(), docLocation);
                IFile outputFile = workspace.getRoot().getFile((IPath)outputPath);
                ByteArrayInputStream target = new ByteArrayInputStream(stringWriter.toString().getBytes("UTF8"));
                if (!workspace.getRoot().exists((IPath)outputPath)) {
                    outputFile.create((InputStream)target, true, monitor);
                } else {
                    outputFile.setContents((InputStream)target, true, false, monitor);
                }
                IPath path = file.getProject().getFullPath().append(this.getDocLocation());
                outputPath = (Path)path.append(SchemaTransformer.getSchemaCSSName());
                IFile schemaCSSFile = workspace.getRoot().getFile((IPath)outputPath);
                stringWriter = new StringWriter();
                pwriter = new PrintWriter(stringWriter);
                if (this.addCSS(outputPath, pwriter)) {
                    if (schemaCSSFile.exists()) {
                        schemaCSSFile.delete(true, false, null);
                    }
                    stringWriter.close();
                    target = new ByteArrayInputStream(stringWriter.toString().getBytes("UTF8"));
                    schemaCSSFile.create((InputStream)target, true, monitor);
                }
                outputPath = this.getCSSURL() == null ? (Path)path.append(SchemaTransformer.getPlatformCSSName()) : new Path(this.getCSSURL().getPath());
                outputPath = (Path)path.append(outputPath.toFile().getName());
                IFile cssFile = workspace.getRoot().getFile((IPath)outputPath);
                stringWriter = new StringWriter();
                pwriter = new PrintWriter(stringWriter);
                if (this.addCSS(outputPath, pwriter)) {
                    if (cssFile.exists()) {
                        cssFile.delete(true, false, null);
                    }
                    stringWriter.close();
                    target = new ByteArrayInputStream(stringWriter.toString().getBytes("UTF8"));
                    cssFile.create((InputStream)target, true, monitor);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            PDE.logException(e);
        }
        catch (CoreException e) {
            PDE.logException(e);
        }
        catch (IOException e) {
            PDE.logException(e);
        }
        monitor.subTask(PDE.getResourceString(BUILDERS_UPDATING));
        monitor.done();
    }

    private boolean addCSS(Path outputPath, PrintWriter pwriter) {
        File cssFile;
        IPluginDescriptor descriptor;
        if (outputPath.toFile().getName().equals(SchemaTransformer.getPlatformCSSName())) {
            descriptor = Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.platform.doc.isv");
            if (descriptor == null) {
                return false;
            }
            cssFile = new File(String.valueOf(BootLoader.getInstallURL().getFile()) + "/plugins/" + descriptor.toString() + File.separator + SchemaTransformer.getPlatformCSSName());
        } else if (outputPath.toFile().getName().equals(SchemaTransformer.getSchemaCSSName())) {
            descriptor = Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.platform.doc.isv");
            if (descriptor == null) {
                return false;
            }
            cssFile = new File(String.valueOf(BootLoader.getInstallURL().getFile()) + "/plugins/" + descriptor.toString() + File.separator + SchemaTransformer.getSchemaCSSName());
        } else {
            if (this.getCSSURL() == null) {
                return false;
            }
            cssFile = new File(this.getCSSURL().getFile());
        }
        try {
            FileReader freader = new FileReader(cssFile);
            BufferedReader breader = new BufferedReader(freader);
            while (breader.ready()) {
                pwriter.println(breader.readLine());
            }
            breader.close();
            freader.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void ensureFoldersExist(IProject project, String pathName) throws CoreException {
        Path path = new Path(pathName);
        IProject parent = project;
        int i = 0;
        while (i < path.segmentCount()) {
            String segment = path.segment(i);
            IFolder folder = parent.getFolder((IPath)new Path(segment));
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            parent = folder;
            ++i;
        }
    }

    private void compileSchemasIn(IContainer container, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(PDE.getResourceString(BUILDERS_SCHEMA_COMPILING_SCHEMAS));
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member instanceof IContainer) {
                this.compileSchemasIn((IContainer)member, monitor);
            } else if (member instanceof IFile && this.isSchemaFile((IFile)member)) {
                this.compileFile((IFile)member, monitor);
            }
            ++i;
        }
        monitor.done();
    }

    public String getDocLocation() {
        return CompilerFlags.getString("compilers.s.doc-folder");
    }

    private String getOutputFileName(IFile file) {
        String fileName = file.getName();
        int dot = fileName.lastIndexOf(46);
        String pageName = String.valueOf(fileName.substring(0, dot)) + ".html";
        String mangledPluginId = this.getMangledPluginId(file);
        if (mangledPluginId != null) {
            pageName = String.valueOf(mangledPluginId) + "_" + pageName;
        }
        IPath path = file.getProject().getFullPath().append(this.getDocLocation()).append(pageName);
        return path.toString();
    }

    private String getMangledPluginId(IFile file) {
        IPluginBase plugin;
        IProject project = file.getProject();
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project);
        if (model instanceof IPluginModelBase && (plugin = model.getPluginBase()) != null) {
            String id = plugin.getId();
            return id.replace('.', '_');
        }
        return null;
    }

    public URL getCSSURL() {
        return this.cssURL;
    }

    public void setCSSURL(String url) {
        try {
            this.cssURL = new URL(url);
        }
        catch (MalformedURLException e) {
            PDE.logException(e);
        }
    }

    public void setCSSURL(URL url) {
        this.cssURL = url;
    }

    private boolean isSchemaFile(IFile file) {
        return "exsd".equals(file.getFileExtension());
    }

    private void removeOutputFile(IFile file, IProgressMonitor monitor) {
        IFile outputFile;
        String outputFileName = this.getOutputFileName(file);
        String message = PDE.getFormattedMessage(BUILDERS_SCHEMA_REMOVING, outputFileName);
        monitor.subTask(message);
        IWorkspace workspace = file.getWorkspace();
        Path path = new Path(outputFileName);
        if (workspace.getRoot().exists((IPath)path) && (outputFile = workspace.getRoot().getFile((IPath)path)) != null) {
            try {
                outputFile.delete(true, true, monitor);
            }
            catch (CoreException e) {
                PDE.logException(e);
            }
        }
        monitor.done();
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    private void transform(ISchemaDescriptor desc, InputStream input, PrintWriter output, SchemaHandler reporter, URL cssURL) {
        this.transformer.transform(desc, input, output, reporter, cssURL);
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                return ExtensionPointSchemaBuilder.this.isInterestingProject(project);
            }
            if (resource instanceof IFolder) {
                return true;
            }
            if (resource instanceof IFile && ExtensionPointSchemaBuilder.this.isSchemaFile(candidate = (IFile)resource)) {
                if (delta.getKind() != 2) {
                    ExtensionPointSchemaBuilder.this.compileFile(candidate, this.monitor);
                    return true;
                }
                ExtensionPointSchemaBuilder.this.removeOutputFile(candidate, this.monitor);
            }
            return false;
        }
    }
}

