/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.builders.PluginErrorReporter;
import org.eclipse.pde.internal.builders.SchemaMarkerFactory;
import org.eclipse.pde.internal.builders.ValidatingSAXParser;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;

public class ManifestConsistencyChecker
extends IncrementalProjectBuilder {
    public static final String BUILDERS_VERIFYING = "Builders.verifying";
    public static final String BUILDERS_FRAGMENT_BROKEN_LINK = "Builders.Fragment.brokenLink";
    public static final String BUILDERS_UPDATING = "Builders.updating";
    public static final String BUILDERS_VERSION_FORMAT = "Builders.versionFormat";
    private boolean javaDelta = false;
    private boolean fileCompiled = false;
    private boolean ignoreJavaChanges = false;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (PDECore.getDefault().getBundle().getState() != 32 || monitor.isCanceled()) {
            return new IProject[0];
        }
        IProject project = this.getProject();
        this.fileCompiled = false;
        this.javaDelta = false;
        boolean bl = this.ignoreJavaChanges = CompilerFlags.getFlag("compilers.p.unknown-class") == 2;
        if (WorkspaceModelManager.isBinaryPluginProject((IProject)project)) {
            return null;
        }
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            this.checkThisProject(project, monitor);
        } else {
            this.processDelta(delta, monitor);
        }
        IProject[] interestingProjects = null;
        IPluginModelBase thisModel = PDECore.getDefault().getModelManager().findModel(project);
        if (thisModel != null) {
            interestingProjects = this.computeInterestingProjects(thisModel);
        }
        if (!this.fileCompiled && kind != 6 && interestingProjects != null) {
            this.checkInterestingProjectDeltas(project, interestingProjects, monitor);
        }
        return interestingProjects;
    }

    private void checkThisProject(IProject project, IProgressMonitor monitor) {
        if (!PDE.hasPluginNature(project)) {
            return;
        }
        IPath path = project.getFullPath().append("plugin.xml");
        IWorkspace workspace = project.getWorkspace();
        IFile file = workspace.getRoot().getFile(path);
        if (file.exists()) {
            this.checkFile(file, monitor);
        } else {
            path = project.getFullPath().append("fragment.xml");
            file = workspace.getRoot().getFile(path);
            if (file.exists()) {
                this.checkFile(file, monitor);
            }
        }
    }

    private void checkInterestingProjectDeltas(IProject project, IProject[] interestingProjects, IProgressMonitor monitor) throws CoreException {
        ReferenceDeltaVisitor rvisitor = new ReferenceDeltaVisitor();
        int i = 0;
        while (i < interestingProjects.length) {
            IProject interestingProject = interestingProjects[i];
            IResourceDelta delta = this.getDelta(interestingProject);
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)rvisitor);
                if (rvisitor.isInterestingChange()) break;
            }
            ++i;
        }
        if (rvisitor.isInterestingChange()) {
            this.checkThisProject(project, monitor);
        }
    }

    private void processDelta(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.javaDelta = false;
        delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        if (this.javaDelta) {
            IProject project = this.getProject();
            IFile file = project.getFile("plugin.xml");
            if (!file.exists()) {
                file = project.getFile("fragment.xml");
            }
            if (file.exists()) {
                this.checkFile(file, monitor);
            }
        }
    }

    private void checkFile(IFile file, IProgressMonitor monitor) {
        PluginErrorReporter reporter = new PluginErrorReporter(file);
        if (WorkspaceModelManager.isBinaryPluginProject((IProject)file.getProject()) || monitor.isCanceled()) {
            return;
        }
        String message = PDE.getFormattedMessage(BUILDERS_VERIFYING, file.getFullPath().toString());
        monitor.subTask(message);
        ValidatingSAXParser.parse(file, reporter);
        IFile bundleManifest = file.getProject().getFile("META-INF/MANIFEST.MF");
        boolean bundle = bundleManifest.exists();
        if (reporter.getErrorCount() == 0) {
            if (this.isFragment(file)) {
                this.validateFragment(file, reporter, bundle, monitor);
            } else {
                this.validatePlugin(file, reporter, bundle, monitor);
            }
        }
        monitor.subTask(PDE.getResourceString(BUILDERS_UPDATING));
        monitor.done();
        this.fileCompiled = true;
    }

    private boolean isFragment(IFile file) {
        String name = file.getName().toLowerCase();
        return name.equals("fragment.xml");
    }

    private boolean isManifestFile(IFile file) {
        if (file.getParent() instanceof IFolder) {
            return false;
        }
        String name = file.getName().toLowerCase();
        return name.equals("plugin.xml") || name.equals("fragment.xml");
    }

    private boolean isJavaFile(IFile file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".java");
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    private void validatePlugin(IFile file, PluginErrorReporter reporter, boolean bundle, IProgressMonitor monitor) {
        WorkspacePluginModel model = new WorkspacePluginModel(file);
        model.load();
        if (model.isLoaded()) {
            IPlugin plugin = model.getPlugin();
            if (!bundle) {
                this.validateRequiredAttributes((IPluginBase)plugin, reporter);
            }
            if (reporter.getErrorCount() == 0) {
                if (!bundle) {
                    this.validateVersion((IPluginBase)plugin, reporter);
                }
                this.validateValues((IPluginBase)plugin, reporter, bundle, monitor);
            }
        }
        model.dispose();
    }

    private void validateFragment(IFile file, PluginErrorReporter reporter, boolean bundle, IProgressMonitor monitor) {
        WorkspaceFragmentModel model = new WorkspaceFragmentModel(file);
        model.load();
        if (model.isLoaded()) {
            IFragment fragment = model.getFragment();
            if (!bundle) {
                this.validateRequiredAttributes((IPluginBase)fragment, reporter);
            }
            if (reporter.getErrorCount() == 0) {
                if (!bundle) {
                    this.validateVersion((IPluginBase)fragment, reporter);
                    String pluginId = fragment.getPluginId();
                    String pluginVersion = fragment.getPluginVersion();
                    int match = fragment.getRule();
                    IPlugin plugin = PDECore.getDefault().findPlugin(pluginId, pluginVersion, match);
                    if (plugin == null) {
                        String[] args = new String[]{pluginId, pluginVersion};
                        String message = PDE.getFormattedMessage(BUILDERS_FRAGMENT_BROKEN_LINK, args);
                        int line = 1;
                        if (fragment instanceof ISourceObject) {
                            line = ((ISourceObject)fragment).getStartLine();
                        }
                        reporter.reportError(message, line);
                    }
                }
                this.validateValues((IPluginBase)fragment, reporter, bundle, monitor);
            }
        }
        model.dispose();
    }

    private IProject[] computeInterestingProjects(IPluginModelBase model) {
        IFragment fragment;
        IPluginBase plugin = model.getPluginBase();
        if (plugin == null) {
            return null;
        }
        PluginModelManager modelManager = PDECore.getDefault().getModelManager();
        ArrayList projects = new ArrayList();
        IPluginImport[] iimports = plugin.getImports();
        int i = 0;
        while (i < iimports.length) {
            IPluginImport iimport = iimports[i];
            if (iimport.getId() != null) {
                IPluginModelBase importModel = modelManager.findPlugin(iimport.getId(), iimport.getVersion(), iimport.getMatch());
                this.addInterestingProject(iimport.getId(), importModel, projects);
            }
            ++i;
        }
        if (model.isFragmentModel() && (fragment = (IFragment)plugin).getPluginId() != null && fragment.getPluginVersion() != null) {
            IPluginModelBase refPlugin = modelManager.findPlugin(fragment.getPluginId(), fragment.getPluginVersion(), fragment.getRule());
            this.addInterestingProject(fragment.getPluginId(), refPlugin, projects);
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    private void addInterestingProject(String id, IPluginModelBase model, ArrayList list) {
        if (model != null && model.isEnabled()) {
            if (model.getUnderlyingResource() != null) {
                list.add(model.getUnderlyingResource().getProject());
            }
        } else {
            IProject missingProject = PDECore.getWorkspace().getRoot().getProject(id);
            list.add(missingProject);
        }
    }

    private void validateVersion(IPluginBase pluginBase, PluginErrorReporter reporter) {
        String version = pluginBase.getVersion();
        if (version == null) {
            version = "";
        }
        try {
            PluginVersionIdentifier pvi = new PluginVersionIdentifier(version);
            pvi.toString();
        }
        catch (Throwable throwable) {
            String message = PDE.getFormattedMessage(BUILDERS_VERSION_FORMAT, version);
            int line = 1;
            if (pluginBase instanceof ISourceObject) {
                line = ((ISourceObject)pluginBase).getStartLine();
            }
            reporter.reportError(message, line);
        }
    }

    private void validateValues(IPluginBase pluginBase, PluginErrorReporter reporter, boolean bundle, IProgressMonitor monitor) {
        if (!CompilerFlags.isGroupActive(0)) {
            return;
        }
        if (!bundle) {
            this.validateRequires(pluginBase, reporter, CompilerFlags.getFlag("compilers.p.unresolved-import"));
        }
        this.validateExtensions(pluginBase, reporter, monitor);
    }

    private void validateRequiredAttributes(IPluginBase pluginBase, PluginErrorReporter reporter) {
        String rootName = "plugin";
        if (pluginBase instanceof IFragment) {
            IFragment fragment = (IFragment)pluginBase;
            rootName = "fragment";
            ManifestConsistencyChecker.assertNotNull("plugin-id", rootName, ManifestConsistencyChecker.getLine((IPluginObject)fragment), fragment.getPluginId(), reporter);
            ManifestConsistencyChecker.assertNotNull("plugin-version", rootName, ManifestConsistencyChecker.getLine((IPluginObject)fragment), fragment.getPluginVersion(), reporter);
        }
        ManifestConsistencyChecker.assertNotNull("name", rootName, ManifestConsistencyChecker.getLine((IPluginObject)pluginBase), pluginBase.getName(), reporter);
        ManifestConsistencyChecker.assertNotNull("id", rootName, ManifestConsistencyChecker.getLine((IPluginObject)pluginBase), pluginBase.getId(), reporter);
        ManifestConsistencyChecker.assertNotNull("version", rootName, ManifestConsistencyChecker.getLine((IPluginObject)pluginBase), pluginBase.getVersion(), reporter);
        IPluginLibrary[] libraries = pluginBase.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IPluginLibrary library = libraries[i];
            ManifestConsistencyChecker.assertNotNull("name", "library", ManifestConsistencyChecker.getLine((IPluginObject)library), library.getName(), reporter);
            ++i;
        }
        IPluginImport[] iimports = pluginBase.getImports();
        int i2 = 0;
        while (i2 < iimports.length) {
            IPluginImport iimport = iimports[i2];
            ManifestConsistencyChecker.assertNotNull("plugin", "import", ManifestConsistencyChecker.getLine((IPluginObject)iimport), iimport.getId(), reporter);
            ++i2;
        }
        IPluginExtension[] extensions = pluginBase.getExtensions();
        int i3 = 0;
        while (i3 < extensions.length) {
            IPluginExtension extension = extensions[i3];
            ManifestConsistencyChecker.assertNotNull("point", "extension", ManifestConsistencyChecker.getLine((IPluginObject)extension), extension.getPoint(), reporter);
            ++i3;
        }
        IPluginExtensionPoint[] expoints = pluginBase.getExtensionPoints();
        int i4 = 0;
        while (i4 < expoints.length) {
            IPluginExtensionPoint expoint = expoints[i4];
            ManifestConsistencyChecker.assertNotNull("id", "extension-point", ManifestConsistencyChecker.getLine((IPluginObject)expoint), expoint.getId(), reporter);
            ManifestConsistencyChecker.assertNotNull("name", "extension-point", ManifestConsistencyChecker.getLine((IPluginObject)expoint), expoint.getName(), reporter);
            ++i4;
        }
    }

    private static void assertNotNull(String att, String el, int line, String value, PluginErrorReporter reporter) {
        if (value == null) {
            String message = PDE.getFormattedMessage("Builders.manifest.missingRequired", new String[]{att, el});
            reporter.reportError(message, line);
        }
    }

    private void validateRequires(IPluginBase pluginBase, PluginErrorReporter reporter, int flag) {
        if (flag == 2) {
            return;
        }
        IPluginImport[] imports = pluginBase.getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport iimport = imports[i];
            if (!imports[i].isOptional() && PDECore.getDefault().findPlugin(iimport.getId(), iimport.getVersion(), iimport.getMatch()) == null) {
                reporter.report(PDE.getFormattedMessage("Builders.Manifest.dependency", iimport.getId()), ManifestConsistencyChecker.getLine((IPluginObject)iimport), flag);
            }
            ++i;
        }
    }

    private void validateExtensions(IPluginBase pluginBase, PluginErrorReporter reporter, IProgressMonitor monitor) {
        IPluginExtension[] extensions = pluginBase.getExtensions();
        SchemaMarkerFactory factory = new SchemaMarkerFactory();
        int i = 0;
        while (i < extensions.length) {
            if (monitor.isCanceled()) break;
            IPluginExtension extension = extensions[i];
            IPluginExtensionPoint point = PDECore.getDefault().findExtensionPoint(extension.getPoint());
            if (point == null) {
                int flag = CompilerFlags.getFlag("compilers.p.unresolved-ex-points");
                if (flag != 2) {
                    reporter.report(PDE.getFormattedMessage("Builders.Manifest.ex-point", extension.getPoint()), ManifestConsistencyChecker.getLine((IPluginObject)extension), flag);
                }
            } else {
                ISchema schema = PDECore.getDefault().getSchemaRegistry().getSchema(extension.getPoint());
                if (schema != null) {
                    factory.setPoint(extension.getPoint());
                    reporter.setMarkerFactory(factory);
                    this.validateExtensionContent(extension, schema, reporter, monitor);
                    reporter.setMarkerFactory(null);
                }
            }
            ++i;
        }
    }

    private void validateExtensionContent(IPluginExtension extension, ISchema schema, PluginErrorReporter reporter, IProgressMonitor monitor) {
        IPluginObject[] elements = extension.getChildren();
        int i = 0;
        while (i < elements.length) {
            if (monitor.isCanceled()) break;
            IPluginElement element = (IPluginElement)elements[i];
            this.validateElement(element, schema, reporter);
            ++i;
        }
    }

    private void validateContentModel(IPluginParent parent, ISchemaElement elementInfo, PluginErrorReporter reporter) {
        if (CompilerFlags.getFlag("compilers.p.unknown-element") == 2) {
            return;
        }
        IPluginObject[] children = parent.getChildren();
        ISchemaType type = elementInfo.getType();
        HashSet allowedElements = new HashSet();
        this.computeAllowedElements(type, allowedElements);
        int i = 0;
        while (i < children.length) {
            IPluginElement child = (IPluginElement)children[i];
            String name = child.getName();
            if (!allowedElements.contains(name)) {
                reporter.report(PDE.getFormattedMessage("Builders.Manifest.child", new String[]{child.getName(), parent.getName()}), ManifestConsistencyChecker.getLine((IPluginObject)child), CompilerFlags.getFlag("compilers.p.unknown-element"));
            }
            ++i;
        }
    }

    private void computeAllowedElements(ISchemaType type, HashSet elementSet) {
        if (type instanceof ISchemaComplexType) {
            ISchemaComplexType complexType = (ISchemaComplexType)type;
            ISchemaCompositor compositor = complexType.getCompositor();
            if (compositor != null) {
                this.computeAllowedElements(compositor, elementSet);
            }
            ISchemaAttribute[] attrs = complexType.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                if (attrs[i].getKind() == 1) {
                    elementSet.add(attrs[i].getName());
                }
                ++i;
            }
        }
    }

    private void computeAllowedElements(ISchemaCompositor compositor, HashSet elementSet) {
        ISchemaObject[] children = compositor.getChildren();
        int i = 0;
        while (i < children.length) {
            ISchemaObject child = children[i];
            if (child instanceof ISchemaObjectReference) {
                ISchemaObjectReference ref = (ISchemaObjectReference)child;
                ISchemaElement refElement = (ISchemaElement)ref.getReferencedObject();
                if (refElement != null) {
                    elementSet.add(refElement.getName());
                }
            } else if (child instanceof ISchemaCompositor) {
                this.computeAllowedElements((ISchemaCompositor)child, elementSet);
            }
            ++i;
        }
    }

    private void validateElement(IPluginElement element, ISchema schema, PluginErrorReporter reporter) {
        ISchemaAttribute attr;
        ISchemaElement schemaElement = schema.findElement(element.getName());
        boolean valid = schemaElement != null;
        boolean executableElement = false;
        ISchemaElement parentSchema = schema.findElement(element.getParent().getName());
        if (schemaElement == null && parentSchema != null && (attr = parentSchema.getAttribute(element.getName())) != null && attr.getKind() == 1) {
            valid = true;
            executableElement = true;
        }
        if (!valid) {
            int flag = CompilerFlags.getFlag("compilers.p.unknown-element");
            if (flag != 2) {
                reporter.report(PDE.getFormattedMessage("Builders.Manifest.element", element.getName()), ManifestConsistencyChecker.getLine((IPluginObject)element), flag);
            }
        } else {
            if (executableElement) {
                this.validateJava(element.getAttribute("class"), parentSchema.getAttribute(element.getName()), reporter);
                return;
            }
            IPluginAttribute[] atts = element.getAttributes();
            this.validateExistingAttributes(atts, schemaElement, reporter);
            this.validateRequiredAttributes(element, schemaElement, reporter);
        }
        if (schemaElement != null) {
            this.validateContentModel((IPluginParent)element, schemaElement, reporter);
        }
        IPluginObject[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginElement child = (IPluginElement)children[i];
            this.validateElement(child, schema, reporter);
            ++i;
        }
    }

    private void validateExistingAttributes(IPluginAttribute[] atts, ISchemaElement schemaElement, PluginErrorReporter reporter) {
        int i = 0;
        while (i < atts.length) {
            IPluginAttribute att = atts[i];
            ISchemaAttribute attInfo = schemaElement.getAttribute(att.getName());
            if (attInfo == null) {
                int flag = CompilerFlags.getFlag("compilers.p.unknown-attribute");
                if (flag != 2) {
                    reporter.report(PDE.getFormattedMessage("Builders.Manifest.attribute", att.getName()), ManifestConsistencyChecker.getLine(att.getParent()), flag);
                }
            } else {
                this.validateAttribute(att, attInfo, reporter);
            }
            ++i;
        }
    }

    private void validateAttribute(IPluginAttribute att, ISchemaAttribute attInfo, PluginErrorReporter reporter) {
        int kind;
        ISchemaSimpleType type = attInfo.getType();
        ISchemaRestriction restriction = type.getRestriction();
        if (restriction != null) {
            this.validateRestriction(att, restriction, reporter);
        }
        if ((kind = attInfo.getKind()) == 1) {
            this.validateJava(att, attInfo, reporter);
        } else if (kind == 2) {
            this.validateResource(att, attInfo, reporter);
        } else if (type.getName().equals("boolean")) {
            this.validateBoolean(att, reporter);
        }
    }

    private void validateRestriction(IPluginAttribute att, ISchemaRestriction restriction, PluginErrorReporter reporter) {
        if (CompilerFlags.getFlag("compilers.p.illegal-att-value") == 2) {
            return;
        }
        Object[] children = restriction.getChildren();
        String value = att.getValue();
        int i = 0;
        while (i < children.length) {
            ISchemaEnumeration iSchemaEnumeration;
            Object child = children[i];
            if (child instanceof ISchemaEnumeration && (iSchemaEnumeration = (ISchemaEnumeration)child).getName().equals(value)) {
                return;
            }
            ++i;
        }
        reporter.report(PDE.getFormattedMessage("Builders.Manifest.att-value", new String[]{value, att.getName()}), ManifestConsistencyChecker.getLine(att.getParent()), CompilerFlags.getFlag("compilers.p.illegal-att-value"));
    }

    private void validateBoolean(IPluginAttribute att, PluginErrorReporter reporter) {
        if (CompilerFlags.getFlag("compilers.p.illegal-att-value") == 2) {
            return;
        }
        String value = att.getValue();
        if (value.equalsIgnoreCase("true")) {
            return;
        }
        if (value.equalsIgnoreCase("false")) {
            return;
        }
        reporter.report(PDE.getFormattedMessage("Builders.Manifest.att-value", new String[]{value, att.getName()}), ManifestConsistencyChecker.getLine(att.getParent()), CompilerFlags.getFlag("compilers.p.illegal-att-value"));
    }

    private void validateJava(IPluginAttribute att, ISchemaAttribute attInfo, PluginErrorReporter reporter) {
        if (CompilerFlags.getFlag("compilers.p.unknown-class") == 2) {
            return;
        }
        String qName = att.getValue();
        IProject project = att.getModel().getUnderlyingResource().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            int index = qName.indexOf(":");
            if (index != -1) {
                qName = qName.substring(0, index);
            }
            if (javaProject.findType(qName) == null) {
                reporter.report(PDE.getFormattedMessage("Builders.Manifest.class", new String[]{qName, att.getName()}), ManifestConsistencyChecker.getLine(att.getParent()), CompilerFlags.getFlag("compilers.p.unknown-class"));
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void validateResource(IPluginAttribute att, ISchemaAttribute attInfo, PluginErrorReporter reporter) {
        if (CompilerFlags.getFlag("compilers.p.unknown-resource") == 2) {
            return;
        }
        String path = att.getValue();
        IProject project = att.getModel().getUnderlyingResource().getProject();
        IResource resource = project.findMember((IPath)new Path(path));
        if (resource == null) {
            reporter.report(PDE.getFormattedMessage("Builders.Manifest.resource", new String[]{path, att.getName()}), ManifestConsistencyChecker.getLine(att.getParent()), CompilerFlags.getFlag("compilers.p.unknown-resource"));
        }
    }

    private void validateRequiredAttributes(IPluginElement element, ISchemaElement schemaElement, PluginErrorReporter reporter) {
        if (CompilerFlags.getFlag("compilers.p.no-required-att") == 2) {
            return;
        }
        ISchemaAttribute[] attInfos = schemaElement.getAttributes();
        int i = 0;
        while (i < attInfos.length) {
            ISchemaAttribute attInfo = attInfos[i];
            if (attInfo.getUse() == 1) {
                boolean valid;
                boolean bl = valid = element.getAttribute(attInfo.getName()) != null;
                if (!valid && attInfo.getKind() == 1) {
                    IPluginObject[] children = element.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        if (attInfo.getName().equals(children[j].getName())) {
                            valid = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!valid) {
                    reporter.report(PDE.getFormattedMessage("Builders.Manifest.required", attInfo.getName()), ManifestConsistencyChecker.getLine((IPluginObject)element), CompilerFlags.getFlag("compilers.p.no-required-att"));
                }
            }
            ++i;
        }
    }

    private static int getLine(IPluginObject object) {
        int line = -1;
        if (object instanceof ISourceObject) {
            line = ((ISourceObject)object).getStartLine();
        }
        return line;
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                return project.isOpen() && PDE.hasPluginNature(project);
            }
            if (resource instanceof IFile) {
                IFile candidate = (IFile)resource;
                if (ManifestConsistencyChecker.this.isManifestFile(candidate)) {
                    if (delta.getKind() != 2) {
                        ManifestConsistencyChecker.this.checkFile(candidate, this.monitor);
                        return false;
                    }
                } else if (!ManifestConsistencyChecker.this.ignoreJavaChanges && ManifestConsistencyChecker.this.isJavaFile(candidate)) {
                    ManifestConsistencyChecker.this.javaDelta = true;
                    return false;
                }
            }
            return true;
        }
    }

    class ReferenceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean interestingChange;

        public boolean isInterestingChange() {
            return this.interestingChange;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                return project.isOpen() && PDE.hasPluginNature(project);
            }
            if (resource instanceof IFile && ManifestConsistencyChecker.this.isManifestFile(candidate = (IFile)resource)) {
                this.interestingChange = true;
                return false;
            }
            return true;
        }
    }
}

