/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.builders.ISchemaTransformer;
import org.eclipse.pde.internal.builders.PluginErrorReporter;
import org.eclipse.pde.internal.builders.SchemaHandler;
import org.eclipse.pde.internal.builders.ValidatingSAXParser;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.ChoiceRestriction;
import org.eclipse.pde.internal.core.schema.DocumentSection;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.w3c.dom.Node;

public class SchemaTransformer
implements ISchemaTransformer {
    private static final String KEY_BOOLEAN_INVALID = "Builders.Schema.Verifier.booleanInvalid";
    private static final String KEY_RESTRICTION_INVALID = "Builders.Schema.Verifier.restrictionInvalid";
    private static final String KEY_BASED_ON_INVALID = "Builders.Schema.Verifier.basedOnInvalid";
    private static final String KEY_VALUE_WITHOUT_DEFAULT = "Builders.Schema.Verifier.valueWithoutDefault";
    private static final String KEY_DEFAULT_WITHOUT_VALUE = "Builders.Schema.Verifier.defaultWithoutValue";
    public static final String KEY_DEPRECATED_TYPE = "Builders.Schema.deprecatedType";
    public static final String REPORT_UNMATCHED = "SchemaTransformer.Validator.unmatched";
    public static final String REPORT_FORBIDDEN = "SchemaTransformer.Validator.forbidden";
    public static final String REPORT_OPTIONAL = "SchemaTransformer.Validator.optional";
    public static final String REPORT_GENERAL = "SchemaTransformer.Validator.general";
    public static final String REPORT_OPEN = "SchemaTransformer.Validator.open_tag";
    public static final String PLATFORM_PLUGIN_DOC = "org.eclipse.platform.doc.isv";
    public static final byte TEMP = 0;
    public static final byte BUILD = 1;
    public static final byte GENERATE_DOC = 2;
    public static final String[] forbiddenEndTagKeys = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
    private static final String[] optionalEndTagKeys = new String[]{"body", "colgroup", "dd", "dt", "head", "html", "li", "option", "p", "tbody", "td", "tfoot", "th", "thead", "tr"};

    private void appendAttlist(PrintWriter out, ISchemaAttribute att, int maxWidth) {
        String typeName;
        out.print("<p class=code id=dtdAttlist>");
        out.print(att.getName());
        int delta = maxWidth - att.getName().length();
        int i = 0;
        while (i < delta + 1) {
            out.print("&nbsp;");
            ++i;
        }
        ISchemaSimpleType type = att.getType();
        ISchemaRestriction restriction = null;
        boolean choices = false;
        if (type != null) {
            restriction = type.getRestriction();
        }
        String string = typeName = type != null ? type.getName().toLowerCase() : "string";
        if (typeName.equals("boolean")) {
            out.print("(true | false) ");
            choices = true;
        } else if (restriction != null) {
            this.appendRestriction(restriction, out);
            choices = true;
        } else {
            out.print("CDATA ");
        }
        if (att.getUse() == 1) {
            if (!choices) {
                out.print("#REQUIRED");
            }
        } else if (att.getUse() == 2) {
            out.print("\"" + att.getValue() + "\"");
        } else if (!choices) {
            out.print("#IMPLIED");
        }
    }

    private void appendRestriction(ISchemaRestriction restriction, PrintWriter out) {
        if (restriction instanceof ChoiceRestriction) {
            ChoiceRestriction cr = (ChoiceRestriction)restriction;
            String[] choices = cr.getChoicesAsStrings();
            out.print("(");
            int i = 0;
            while (i < choices.length) {
                if (i > 0) {
                    out.print("|");
                }
                out.print(choices[i]);
                ++i;
            }
            out.print(") ");
        }
    }

    private int calculateMaxAttributeWidth(ISchemaAttribute[] attributes) {
        int width = 0;
        int i = 0;
        while (i < attributes.length) {
            ISchemaAttribute att = attributes[i];
            width = Math.max(width, att.getName().length());
            ++i;
        }
        return width;
    }

    private boolean isPreEnd(String text, int loc) {
        if (loc + 5 >= text.length()) {
            return false;
        }
        String tag = text.substring(loc, loc + 6);
        return tag.toLowerCase().equals("</pre>");
    }

    private boolean isPreStart(String text, int loc) {
        if (loc + 4 >= text.length()) {
            return false;
        }
        String tag = text.substring(loc, loc + 5);
        return tag.toLowerCase().equals("<pre>");
    }

    public void transform(ISchemaDescriptor desc, InputStream is, PrintWriter out, SchemaHandler reporter) {
        this.transform(desc, is, out, reporter, null);
    }

    public void transform(ISchemaDescriptor desc, InputStream is, PrintWriter out, SchemaHandler reporter, URL cssURL) {
        ValidatingSAXParser.parse(is, (PluginErrorReporter)reporter);
        Node root = reporter.getDocumentElement();
        if (root == null || reporter.getErrorCount() > 0) {
            return;
        }
        Schema schema = new Schema(desc, desc.getSchemaURL());
        schema.traverseDocumentTree(root, reporter.getLineTable());
        if (this.verifySchema(schema, reporter) && this.verifySections((ISchema)schema, reporter) && CompilerFlags.getBoolean("compilers.s.create-docs")) {
            this.transform(out, (ISchema)schema, cssURL, (byte)2);
        }
    }

    private boolean verifySchema(Schema schema, PluginErrorReporter reporter) {
        if (!schema.isLoaded()) {
            return false;
        }
        if (!schema.isValid()) {
            return false;
        }
        this.checkFileType(reporter.getFile(), reporter);
        ISchemaElement[] elements = schema.getElements();
        int errors = 0;
        int i = 0;
        while (i < elements.length) {
            ISchemaElement element = elements[i];
            ISchemaAttribute[] attributes = element.getAttributes();
            int j = 0;
            while (j < attributes.length) {
                ISchemaAttribute attribute = attributes[j];
                errors += this.verifyAttribute(element, attribute, reporter);
                ++j;
            }
            ++i;
        }
        return errors == 0;
    }

    private void checkFileType(IFile file, PluginErrorReporter reporter) {
        String ext;
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        if (dot != -1 && (ext = name.substring(dot + 1)).equalsIgnoreCase("xsd")) {
            String message = PDE.getResourceString(KEY_DEPRECATED_TYPE);
            reporter.reportWarning(message);
        }
    }

    private int verifyAttribute(ISchemaElement element, ISchemaAttribute attribute, PluginErrorReporter reporter) {
        String message;
        int errors = 0;
        ISchemaSimpleType type = attribute.getType();
        String[] args = new String[]{element.getName(), attribute.getName()};
        int line = -1;
        if (attribute instanceof ISourceObject) {
            line = ((ISourceObject)attribute).getStartLine();
        }
        if (attribute.getKind() != 0 && type != null) {
            if (type.getName().equals("boolean")) {
                message = PDE.getFormattedMessage(KEY_BOOLEAN_INVALID, args);
                reporter.reportError(message, line);
                ++errors;
            }
            if (type instanceof SchemaSimpleType && ((SchemaSimpleType)type).getRestriction() != null) {
                message = PDE.getFormattedMessage(KEY_RESTRICTION_INVALID, args);
                reporter.reportError(message, line);
                ++errors;
            }
        }
        if (attribute.getKind() != 1 && attribute.getBasedOn() != null) {
            message = PDE.getFormattedMessage(KEY_BASED_ON_INVALID, args);
            reporter.reportError(message, line);
            ++errors;
        }
        if (type != null && type.getName().equals("boolean") && type instanceof SchemaSimpleType && ((SchemaSimpleType)type).getRestriction() != null) {
            message = PDE.getFormattedMessage(KEY_RESTRICTION_INVALID, args);
            reporter.reportError(message, line);
            ++errors;
        }
        if (attribute.getUse() != 2) {
            if (attribute.getValue() != null) {
                message = PDE.getFormattedMessage(KEY_VALUE_WITHOUT_DEFAULT, args);
                reporter.reportError(message, line);
                ++errors;
            }
        } else if (attribute.getValue() == null) {
            message = PDE.getFormattedMessage(KEY_DEFAULT_WITHOUT_VALUE, args);
            reporter.reportError(message, line);
            ++errors;
        }
        return errors;
    }

    public static String getSchemaCSSName() {
        return "schema.css";
    }

    public static String getPlatformCSSName() {
        return "book.css";
    }

    public void addCSS(PrintWriter out, URL cssURL, byte cssPurpose) {
        File cssFile;
        if (cssURL == null) {
            if (cssPurpose == 2) {
                out.println("<!-- default platform documentation stylesheets -->");
                out.println("<style>@import url(\"" + SchemaTransformer.getPlatformCSSName() + "\");</style>");
                return;
            }
            if (cssPurpose == 1) {
                out.println("<!-- default platform documentation stylesheets -->");
                out.println("<style>@import url(\"../../" + SchemaTransformer.getPlatformCSSName() + "\");</style>");
                return;
            }
            IPluginDescriptor descriptor = Platform.getPluginRegistry().getPluginDescriptor(PLATFORM_PLUGIN_DOC);
            if (descriptor == null) {
                return;
            }
            cssFile = new File(String.valueOf(BootLoader.getInstallURL().getFile()) + "/plugins/" + descriptor.toString() + File.separator + SchemaTransformer.getPlatformCSSName());
        } else {
            cssFile = new File(cssURL.getFile());
            if (cssPurpose == 2) {
                out.println("<!-- custom platform documentation stylesheets -->");
                out.println("<style>@import url(\"" + cssFile.getName() + "\");</style>");
                return;
            }
            if (cssPurpose == 1) {
                out.println("<!-- custom platform documentation stylesheets -->");
                out.println("<style>@import url(\"" + cssURL.toString() + "\");</style>");
                return;
            }
        }
        try {
            File tempCSSFile = File.createTempFile("book", ".css");
            tempCSSFile.deleteOnExit();
            FileReader freader = new FileReader(cssFile);
            BufferedReader breader = new BufferedReader(freader);
            PrintWriter pwriter = new PrintWriter(new FileOutputStream(tempCSSFile));
            while (breader.ready()) {
                pwriter.println(breader.readLine());
            }
            out.println("<!-- temporary documentation stylesheets -->");
            out.println("<style>@import url(\"" + tempCSSFile.getName() + "\");</style>");
            pwriter.close();
            breader.close();
            freader.close();
        }
        catch (Exception exception) {}
    }

    public void transform(PrintWriter out, ISchema schema) {
        this.transform(out, schema, null, (byte)0);
    }

    public void transform(PrintWriter out, ISchema schema, URL cssURL, byte cssPurpose) {
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
        out.print("<HEAD>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        this.addCSS(out, cssURL, cssPurpose);
        this.addSchemaStyle(out, cssPurpose);
        out.println("</HEAD>");
        out.println("<HTML>");
        out.println("<BODY>");
        out.println("<H1><CENTER>" + schema.getName() + "</CENTER></H1>");
        out.println("<p></p>");
        out.print("<h6 class=CaptionFigColumn id=header>Identifier: </h6>");
        out.print(schema.getQualifiedPointId());
        out.println("<p></p>");
        this.transformSection(out, schema, "Since:", "since");
        this.transformDescription(out, schema);
        out.println("<p><h6 class=CaptionFigColumn id=header>Configuration Markup:</h6></p>");
        this.transformMarkup(out, schema);
        this.transformSection(out, schema, "Examples:", "examples");
        this.transformSection(out, schema, "API Information:", "apiInfo");
        this.transformSection(out, schema, "Supplied Implementation:", "implementation");
        out.println("<br>");
        out.println("<p class=note id=copyright>");
        this.transformSection(out, schema, "copyright");
        out.println("</p>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    private void addSchemaStyle(PrintWriter out, byte cssPurpose) {
        try {
            switch (cssPurpose) {
                case 0: {
                    IPluginDescriptor descriptor = Platform.getPluginRegistry().getPluginDescriptor(PLATFORM_PLUGIN_DOC);
                    if (descriptor == null) {
                        return;
                    }
                    this.addCSS(out, new URL(BootLoader.getInstallURL() + "/plugins/" + descriptor.toString() + File.separator + SchemaTransformer.getSchemaCSSName()), cssPurpose);
                    break;
                }
                case 2: {
                    out.println("<!-- default schema documentation stylesheets -->");
                    out.println("<style>@import url(\"" + SchemaTransformer.getSchemaCSSName() + "\");</style>");
                    break;
                }
                case 1: {
                    out.println("<!-- default schema documentation stylesheets -->");
                    out.println("<style>@import url(\"../../" + SchemaTransformer.getSchemaCSSName() + "\");</style>");
                    break;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void transformDescription(PrintWriter out, ISchema schema) {
        out.println("<p>");
        out.print("<h6 class=CaptionFigColumn id=header>Description: </h6>");
        this.transformText(out, schema.getDescription());
        ISchemaInclude[] includes = schema.getIncludes();
        int i = 0;
        while (i < includes.length) {
            ISchema ischema = includes[i].getIncludedSchema();
            if (ischema != null) {
                out.println("<p>");
                this.transformText(out, ischema.getDescription());
            }
            ++i;
        }
        out.println("</p>");
    }

    private void transformElement(PrintWriter out, ISchemaElement element) {
        int i;
        String name = element.getName();
        String dtd = element.getDTDRepresentation(true);
        String nameLink = "<a name=\"e." + name + "\">" + name + "</a>";
        out.print("<p class=code id=dtd>&lt;!ELEMENT " + nameLink + " " + dtd);
        out.println("&gt;</p>");
        ISchemaAttribute[] attributes = element.getAttributes();
        if (attributes.length > 0) {
            out.println("<p class=code id=dtd>&lt;!ATTLIST " + name + "</p>");
            int maxWidth = this.calculateMaxAttributeWidth(element.getAttributes());
            i = 0;
            while (i < attributes.length) {
                this.appendAttlist(out, attributes[i], maxWidth);
                ++i;
            }
            out.println("&gt;</p>");
        }
        out.println("<p></p>");
        String description = element.getDescription();
        if (description != null && description.trim().length() > 0) {
            out.println("<p class=ConfigMarkup id=elementDesc>");
            this.transformText(out, description);
            out.println("</p>");
        }
        if (attributes.length == 0) {
            out.println("<br><br>");
            return;
        }
        if (description != null && description.trim().length() > 0) {
            out.println("<br>");
        }
        out.println("<ul class=ConfigMarkup id=attlistDesc>");
        i = 0;
        while (i < attributes.length) {
            ISchemaAttribute att = attributes[i];
            if (!name.equals("extension") || att.getDescription() != null && att.getDescription().trim().length() != 0) {
                out.print("<li><b>" + att.getName() + "</b> - ");
                this.transformText(out, att.getDescription());
                out.println("</li>");
            }
            ++i;
        }
        out.println("</ul>");
        out.print("<br>");
    }

    private void transformMarkup(PrintWriter out, ISchema schema) {
        ISchemaElement[] elements = schema.getResolvedElements();
        int i = 0;
        while (i < elements.length) {
            ISchemaElement element = elements[i];
            this.transformElement(out, element);
            ++i;
        }
    }

    private void transformSection(PrintWriter out, ISchema schema, String sectionId) {
        this.transformSection(out, schema, null, sectionId);
    }

    private DocumentSection findSection(IDocumentSection[] sections, String sectionId) {
        int i = 0;
        while (i < sections.length) {
            if (sections[i].getSectionId().equals(sectionId)) {
                return (DocumentSection)sections[i];
            }
            ++i;
        }
        return null;
    }

    private boolean optionalEndTag(String tag) {
        int i = 0;
        while (i < optionalEndTagKeys.length) {
            if (tag.equalsIgnoreCase(optionalEndTagKeys[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean forbiddenEndTag(String tag) {
        int i = 0;
        while (i < forbiddenEndTagKeys.length) {
            if (tag.equalsIgnoreCase(forbiddenEndTagKeys[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean verifyDescription(String desc, PlatformObject container, PluginErrorReporter reporter) {
        openTag = false;
        isPre = false;
        flagForbidden = CompilerFlags.getFlag("compilers.s.forbidden-end-tags") != 2;
        flagOptional = CompilerFlags.getFlag("compilers.s.optional-end-tags") != 2;
        flagGeneral = CompilerFlags.getFlag("compilers.s.open-tags") != 2;
        tagStack = new Stack<String>();
        lineStack = new Stack<Integer>();
        linenum = 1;
        if (desc == null || desc.trim().length() == 0) {
            return false;
        }
        text = new StringTokenizer(desc, "<>", true);
        while (text.countTokens() > 0) {
            block24: {
                block26: {
                    block31: {
                        block30: {
                            block29: {
                                block27: {
                                    block28: {
                                        block25: {
                                            next = text.nextToken();
                                            if (!next.equals("<")) break block24;
                                            openTag = true;
                                            if (!text.hasMoreTokens()) continue;
                                            tempTag = tag = text.nextToken();
                                            if ((tag = tag.trim()).indexOf(10) != -1) {
                                                tag = tag.replace('\n', ' ');
                                            }
                                            loc = tag.indexOf(" ");
                                            locEnd = tag.lastIndexOf("/");
                                            if (tag.equalsIgnoreCase(">") || locEnd == tag.length() - 1 && text.hasMoreTokens() && text.nextToken().equals(">") || tag.indexOf("!") == 0 && text.hasMoreTokens() && text.nextToken().equals(">")) {
                                                openTag = false;
                                                linenum += this.getLineBreakCount(tempTag);
                                                continue;
                                            }
                                            v0 = tag = loc == -1 ? tag : tag.substring(0, loc);
                                            if (locEnd == 0) break block25;
                                            if (tag.equalsIgnoreCase("pre") && !isPre) {
                                                isPre = true;
                                                tagStack.push(tag);
                                                lineStack.push(new Integer(linenum));
                                            } else if (!isPre && !this.forbiddenEndTag(tag)) {
                                                tagStack.push(tag);
                                                lineStack.push(new Integer(linenum));
                                            }
                                            break block26;
                                        }
                                        tag = tag.substring(1);
                                        if (!isPre) break block27;
                                        if (!tag.equalsIgnoreCase("pre")) break block28;
                                        isPre = false;
                                        tagStack.pop();
                                        lineStack.pop();
                                        break block26;
                                    }
                                    openTag = false;
                                    linenum += this.getLineBreakCount(tempTag);
                                    continue;
                                }
                                if (tagStack.isEmpty() || !tagStack.peek().toString().equalsIgnoreCase(tag)) break block29;
                                tagStack.pop();
                                lineStack.pop();
                                break block26;
                            }
                            if (!this.forbiddenEndTag(tag)) break block30;
                            if (flagForbidden) {
                                this.report("FORBIDDEN", "/" + tag, linenum, container, reporter);
                            }
                            break block26;
                        }
                        if (!tagStack.isEmpty() && tagStack.search(tag) != -1) break block31;
                        if (flagGeneral) {
                            this.report("GENERAL", "/" + tag, linenum, container, reporter);
                        }
                        break block26;
                    }
                    search = tagStack.search(tag);
                    do {
                        block33: {
                            block32: {
                                if (flagGeneral) ** GOTO lbl89
                                while (search > 1 && !this.optionalEndTag(tagStack.peek().toString())) {
                                    tagStack.pop();
                                    lineStack.pop();
                                    --search;
                                }
                                break block32;
lbl-1000:
                                // 1 sources

                                {
                                    this.report("GENERAL", tagStack.pop().toString(), (Integer)lineStack.pop(), container, reporter);
                                    --search;
lbl89:
                                    // 2 sources

                                    ** while (search > 1 && !this.optionalEndTag((String)tagStack.peek().toString()))
                                }
                            }
                            if (flagOptional) ** GOTO lbl103
                            while (search > 1 && this.optionalEndTag(tagStack.peek().toString())) {
                                tagStack.pop();
                                lineStack.pop();
                                --search;
                            }
                            break block33;
lbl-1000:
                            // 1 sources

                            {
                                this.report("OPTIONAL", tagStack.pop().toString(), (Integer)lineStack.pop(), container, reporter);
                                --search;
lbl103:
                                // 2 sources

                                ** while (search > 1 && this.optionalEndTag((String)tagStack.peek().toString()))
                            }
                        }
                        if (search != 1) continue;
                        tagStack.pop();
                        lineStack.pop();
                        --search;
                    } while (search > 0);
                }
                if (text.hasMoreTokens() && text.nextToken().equals(">")) {
                    openTag = false;
                } else if (flagGeneral) {
                    if (locEnd == -1) {
                        this.report("OPEN_TAG", "null", linenum, container, reporter);
                    } else {
                        this.report("OPEN_TAG", "null", linenum, container, reporter);
                    }
                    openTag = false;
                }
                linenum += this.getLineBreakCount(tempTag);
                continue;
            }
            linenum += this.getLineBreakCount(next);
        }
        if (openTag) {
            this.report("OPEN_TAG", "null", linenum, container, reporter);
        }
        while (!tagStack.isEmpty()) {
            if (this.optionalEndTag(tagStack.peek().toString())) {
                if (!flagOptional) {
                    tagStack.pop();
                    lineStack.pop();
                    continue;
                }
                this.report("OPTIONAL", tagStack.pop().toString(), (Integer)lineStack.pop(), container, reporter);
                continue;
            }
            if (!flagGeneral) {
                tagStack.pop();
                lineStack.pop();
                continue;
            }
            this.report("GENERAL", tagStack.pop().toString(), (Integer)lineStack.pop(), container, reporter);
        }
        return false;
    }

    private boolean report(String errType, String errTag, int linenum, PlatformObject container, PluginErrorReporter reporter) {
        if (container instanceof SchemaObject) {
            if (errTag.equals("")) {
                reporter.report(PDE.getResourceString(REPORT_UNMATCHED), ((SchemaObject)container).getStartLine() + linenum, CompilerFlags.getFlag("compilers.s.open-tags"));
                return CompilerFlags.getFlag("compilers.s.open-tags") == 0;
            }
            if (errType.equals("FORBIDDEN")) {
                reporter.report(PDE.getFormattedMessage(REPORT_FORBIDDEN, errTag), ((SchemaObject)container).getStartLine() + linenum, CompilerFlags.getFlag("compilers.s.forbidden-end-tags"));
                return CompilerFlags.getFlag("compilers.s.forbidden-end-tags") == 0;
            }
            if (errType.equals("OPTIONAL")) {
                reporter.report(PDE.getFormattedMessage(REPORT_OPTIONAL, errTag), ((SchemaObject)container).getStartLine() + linenum, CompilerFlags.getFlag("compilers.s.optional-end-tags"));
                return CompilerFlags.getFlag("compilers.s.optional-end-tags") == 0;
            }
            if (errType.equals("OPEN_TAG")) {
                reporter.report(PDE.getResourceString(REPORT_OPEN), ((SchemaObject)container).getStartLine() + linenum, CompilerFlags.getFlag("compilers.s.open-tags"));
                return CompilerFlags.getFlag("compilers.s.open-tags") == 0;
            }
            reporter.report(PDE.getFormattedMessage(REPORT_GENERAL, errTag), ((SchemaObject)container).getStartLine() + linenum, CompilerFlags.getFlag("compilers.s.open-tags"));
            return CompilerFlags.getFlag("compilers.s.open-tags") == 0;
        }
        if (errTag.equals("")) {
            reporter.report(PDE.getResourceString(REPORT_UNMATCHED), ((Schema)container).getOverviewStartLine() + linenum, CompilerFlags.getFlag("compilers.s.open-tags"));
            return CompilerFlags.getFlag("compilers.s.open-tags") == 0;
        }
        if (errType.equals("FORBIDDEN")) {
            reporter.report(PDE.getFormattedMessage(REPORT_FORBIDDEN, errTag), ((Schema)container).getOverviewStartLine() + linenum, CompilerFlags.getFlag("compilers.s.forbidden-end-tags"));
            return CompilerFlags.getFlag("compilers.s.forbidden-end-tags") == 0;
        }
        if (errType.equals("OPTIONAL")) {
            reporter.report(PDE.getFormattedMessage(REPORT_OPTIONAL, errTag), ((Schema)container).getOverviewStartLine() + linenum, CompilerFlags.getFlag("compilers.s.optional-end-tags"));
            return CompilerFlags.getFlag("compilers.s.optional-end-tags") == 0;
        }
        if (errType.equals("OPEN_TAG")) {
            reporter.report(PDE.getResourceString(REPORT_OPEN), ((Schema)container).getOverviewStartLine() + linenum, CompilerFlags.getFlag("compilers.s.open-tags"));
            return CompilerFlags.getFlag("compilers.s.open-tags") == 0;
        }
        reporter.report(PDE.getFormattedMessage(REPORT_GENERAL, errTag), ((Schema)container).getOverviewStartLine() + linenum, CompilerFlags.getFlag("compilers.s.open-tags"));
        return CompilerFlags.getFlag("compilers.s.open-tags") == 0;
    }

    private boolean verifySections(ISchema schema, PluginErrorReporter reporter) {
        if (CompilerFlags.getFlag("compilers.s.open-tags") == 2 && CompilerFlags.getFlag("compilers.s.forbidden-end-tags") == 2 && CompilerFlags.getFlag("compilers.s.optional-end-tags") == 2) {
            return true;
        }
        boolean hasError = false;
        DocumentSection section = null;
        String[] sectionIds = new String[]{"apiInfo", "examples", "implementation", "description", "copyright", "since"};
        int i = 0;
        while (i < sectionIds.length) {
            section = this.findSection(schema.getDocumentSections(), sectionIds[i]);
            if (section != null) {
                String desc = section.getDescription();
                hasError = this.verifyDescription(desc, (PlatformObject)section, reporter) ? true : hasError;
            }
            ++i;
        }
        hasError = this.verifyDescription(schema.getDescription(), (PlatformObject)((Schema)schema), reporter) ? true : hasError;
        return !hasError;
    }

    private void transformSection(PrintWriter out, ISchema schema, String title, String sectionId) {
        DocumentSection section = this.findSection(schema.getDocumentSections(), sectionId);
        if (section == null) {
            return;
        }
        String description = section.getDescription();
        if (description == null || description.trim().length() == 0) {
            return;
        }
        if (title != null) {
            out.print("<h6 class=CaptionFigColumn id=header>" + title + " </h6>");
        }
        this.transformText(out, description);
        out.println();
        out.println("<p></p>");
        out.println();
    }

    private void transformText(PrintWriter out, String text) {
        if (text == null) {
            return;
        }
        boolean preformatted = false;
        boolean inTag = false;
        boolean inCstring = false;
        int i = 0;
        while (i < text.length()) {
            block13: {
                char c;
                block14: {
                    block11: {
                        block12: {
                            c = text.charAt(i);
                            if (c != '<') break block11;
                            if (!this.isPreStart(text, i)) break block12;
                            out.print("<pre>");
                            i += 4;
                            preformatted = true;
                            break block13;
                        }
                        if (!this.isPreEnd(text, i)) break block11;
                        out.print("</pre>");
                        i += 5;
                        preformatted = false;
                        inTag = false;
                        inCstring = false;
                        break block13;
                    }
                    if (!preformatted) break block14;
                    switch (c) {
                        case '<': {
                            inTag = true;
                            out.print("<p class=code id=tag>");
                            out.print("&lt;");
                            break;
                        }
                        case '>': {
                            out.print("&gt;");
                            out.print("</p>");
                            inTag = false;
                            inCstring = false;
                            break;
                        }
                        case '&': {
                            out.print("&amp;");
                            break;
                        }
                        case '\'': {
                            out.print("&apos;");
                            break;
                        }
                        case '\"': {
                            if (inTag) {
                                if (inCstring) {
                                    out.print("&quot;");
                                    out.print("</p>");
                                    out.print("<p class=code id=tag>");
                                    inCstring = false;
                                    break;
                                }
                                inCstring = true;
                                out.print("<p class=code id=cstring>");
                                out.print("&quot;");
                                break;
                            }
                            break block13;
                        }
                        default: {
                            out.print(c);
                            break;
                        }
                    }
                    break block13;
                }
                out.print(c);
            }
            ++i;
        }
    }

    public int getLineBreakCount(String tag) {
        StringTokenizer tokenizer = new StringTokenizer(tag, "\n", true);
        int token = 0;
        while (tokenizer.hasMoreTokens()) {
            if (!tokenizer.nextToken().equals("\n")) continue;
            ++token;
        }
        return token;
    }
}

