/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventThread;
import org.eclipse.osgi.framework.eventmgr.ListElement;

public class EventManager {
    static final boolean DEBUG = false;
    private EventThread thread = null;
    protected final String threadName;

    public EventManager() {
        this(null);
    }

    public EventManager(String threadName) {
        this.threadName = threadName;
    }

    public synchronized void close() {
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
    }

    synchronized EventThread getEventThread() {
        if (this.thread == null) {
            this.thread = this.threadName == null ? new EventThread() : new EventThread(this.threadName);
            this.thread.start();
        }
        return this.thread;
    }

    static void dispatchEvent(ListElement[] listeners, EventDispatcher dispatcher, int eventAction, Object eventObject) {
        int size = listeners.length;
        int i = 0;
        while (i < size) {
            ListElement listener = listeners[i];
            if (listener == null) break;
            try {
                dispatcher.dispatchEvent(listener.primary, listener.companion, eventAction, eventObject);
            }
            catch (Throwable throwable) {}
            ++i;
        }
    }
}

