/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.appserver.AppserverPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class AppserverPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Text textServerAddr;
    protected Text textServerPort;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.help.ui.prefPageAppServer");
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        Label label = new Label(mainComposite, 0);
        label.setText(HelpUIResources.getString("AppserverPreferencePage.description"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        label = new Label(mainComposite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        label = new Label(mainComposite, 0);
        label.setFont(font);
        label.setText(HelpUIResources.getString("AppserverPreferencePage.hostDescription"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.textServerAddr = new Text(mainComposite, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.textServerAddr.setLayoutData((Object)data);
        this.textServerAddr.setFont(font);
        label = new Label(mainComposite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        label = new Label(mainComposite, 0);
        label.setFont(font);
        label.setText(HelpUIResources.getString("AppserverPreferencePage.portDescription"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.textServerPort = new Text(mainComposite, 2052);
        this.textServerPort.setTextLimit(5);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(8);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.textServerPort.setLayoutData((Object)data);
        this.textServerPort.setFont(font);
        this.textServerPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int num = Integer.valueOf(AppserverPreferencePage.this.textServerPort.getText());
                    if (num >= 0 && num <= 65535) {
                        AppserverPreferencePage.this.setValid(true);
                        AppserverPreferencePage.this.setErrorMessage(null);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                AppserverPreferencePage.this.setValid(false);
                AppserverPreferencePage.this.setErrorMessage(HelpUIResources.getString("AppserverPreferencePage.invalidPort"));
            }
        });
        label = new Label(mainComposite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        label = new Label(mainComposite, 0);
        label.setText(HelpUIResources.getString("AppserverPreferencePage.Note"));
        FontData[] fontData = font.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 1);
            ++i;
        }
        final Font boldFont = new Font((Device)label.getDisplay(), fontData);
        label.setFont(boldFont);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                boldFont.dispose();
            }
        });
        data = new GridData(2);
        label.setLayoutData((Object)data);
        label = new Label(mainComposite, 0);
        label.setText(HelpUIResources.getString("AppserverPreferencePage.requireRestart"));
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setFont(font);
        Preferences pref = AppserverPlugin.getDefault().getPluginPreferences();
        this.textServerAddr.setText(pref.getString("host"));
        this.textServerPort.setText(pref.getString("port"));
        return mainComposite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        Preferences pref = AppserverPlugin.getDefault().getPluginPreferences();
        this.textServerAddr.setText(pref.getDefaultString("host"));
        this.textServerPort.setText(pref.getDefaultString("port"));
        super.performDefaults();
    }

    public boolean performOk() {
        Preferences pref = AppserverPlugin.getDefault().getPluginPreferences();
        pref.setValue("host", this.textServerAddr.getText());
        pref.setValue("port", this.textServerPort.getText());
        AppserverPlugin.getDefault().savePluginPreferences();
        return true;
    }
}

