/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class Bindings {
    public static final String ARRAY_LENGTH_FIELD_BINDING_STRING = "(array type):length";

    private Bindings() {
    }

    public static boolean equals(IBinding b1, IBinding b2) {
        Assert.isNotNull(b1);
        if (b1 == b2) {
            return true;
        }
        if (b2 == null) {
            return false;
        }
        String k1 = b1.getKey();
        String k2 = b2.getKey();
        if (k1 == null || k2 == null) {
            return false;
        }
        if (k1 != null) {
            return k1.equals(k2);
        }
        return k2.equals(k1);
    }

    public static boolean equals(IBinding[] b1, IBinding[] b2) {
        Assert.isNotNull(b1);
        if (b1 == b2) {
            return true;
        }
        if (b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            if (!Bindings.equals(b1[i], b2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int hashCode(IBinding binding) {
        Assert.isNotNull(binding);
        String key = binding.getKey();
        if (key == null) {
            return binding.hashCode();
        }
        return key.hashCode();
    }

    public static String asString(IBinding binding) {
        if (binding instanceof IMethodBinding) {
            return Bindings.asString((IMethodBinding)binding);
        }
        if (binding instanceof ITypeBinding) {
            return Bindings.asString((ITypeBinding)binding);
        }
        if (binding instanceof IVariableBinding) {
            return Bindings.asString((IVariableBinding)binding);
        }
        return binding.toString();
    }

    private static String asString(IVariableBinding variableBinding) {
        if (!variableBinding.isField()) {
            return variableBinding.toString();
        }
        if (variableBinding.getDeclaringClass() == null) {
            Assert.isTrue(variableBinding.getName().equals("length"));
            return ARRAY_LENGTH_FIELD_BINDING_STRING;
        }
        StringBuffer result = new StringBuffer();
        result.append(variableBinding.getDeclaringClass().getName());
        result.append(':');
        result.append(variableBinding.getName());
        return result.toString();
    }

    private static String asString(ITypeBinding type) {
        return type.getQualifiedName();
    }

    private static String asString(IMethodBinding method) {
        StringBuffer result = new StringBuffer();
        result.append(method.getDeclaringClass().getName());
        result.append(':');
        result.append(method.getName());
        result.append('(');
        ITypeBinding[] parameters = method.getParameterTypes();
        int lastComma = parameters.length - 1;
        int i = 0;
        while (i < parameters.length) {
            ITypeBinding parameter = parameters[i];
            result.append(parameter.getName());
            if (i < lastComma) {
                result.append(", ");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    public static String getTypeQualifiedName(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < result.size()) {
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append((String)result.get(i));
            ++i;
        }
        return buffer.toString();
    }

    public static String getFullyQualifiedName(ITypeBinding type) {
        return type.getQualifiedName();
    }

    private static void createName(ITypeBinding type, boolean includePackage, List list) {
        ITypeBinding baseType = type;
        if (type.isArray()) {
            baseType = type.getElementType();
        }
        if (!baseType.isPrimitive() && !baseType.isNullType()) {
            ITypeBinding declaringType = baseType.getDeclaringClass();
            if (declaringType != null) {
                Bindings.createName(declaringType, includePackage, list);
            } else if (includePackage && !baseType.getPackage().isUnnamed()) {
                String[] components = baseType.getPackage().getNameComponents();
                int i = 0;
                while (i < components.length) {
                    list.add(components[i]);
                    ++i;
                }
            }
        }
        if (!baseType.isAnonymous()) {
            list.add(type.getName());
        } else {
            list.add("$local$");
        }
    }

    public static String[] getNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        return result.toArray(new String[result.size()]);
    }

    public static String[] getAllNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, true, result);
        return result.toArray(new String[result.size()]);
    }

    public static ITypeBinding getTopLevelType(ITypeBinding type) {
        ITypeBinding parent = type.getDeclaringClass();
        while (parent != null) {
            type = parent;
            parent = type.getDeclaringClass();
        }
        return type;
    }

    public static boolean isRuntimeException(ITypeBinding thrownException) {
        if (thrownException == null || thrownException.isPrimitive() || thrownException.isArray()) {
            return false;
        }
        return Bindings.findTypeInHierarchy(thrownException, "java.lang.RuntimeException") != null;
    }

    public static IVariableBinding findFieldInType(ITypeBinding type, String fieldName) {
        if (type.isPrimitive()) {
            return null;
        }
        IVariableBinding[] fields = type.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            IVariableBinding field = fields[i];
            if (field.getName().equals(fieldName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (parameters == null ? methodName.equals(methods[i].getName()) : Bindings.isEqualMethod(methods[i], methodName, parameters)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IVariableBinding findFieldInHierarchy(ITypeBinding type, String fieldName) {
        IVariableBinding field = Bindings.findFieldInType(type, fieldName);
        if (field != null) {
            return field;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (field = Bindings.findFieldInType(type, fieldName)) != null) {
            return field;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            field = Bindings.findFieldInType(type, fieldName);
            if (field != null) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        IMethodBinding method = Bindings.findMethodInType(type, methodName, parameters);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findMethodInHierarchy(superClass, methodName, parameters)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = Bindings.findMethodInHierarchy(interfaces[i], methodName, parameters);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodDefininition(IMethodBinding method, boolean testVisibility) {
        IMethodBinding res;
        ITypeBinding type = method.getDeclaringClass();
        String methodName = method.getName();
        ITypeBinding[] parameters = method.getParameterTypes();
        if (!(type.getSuperclass() == null || (res = Bindings.findMethodInHierarchy(type.getSuperclass(), methodName, parameters)) == null || Modifier.isPrivate((int)res.getModifiers()) || testVisibility && !Bindings.isVisibleInHierarchy(res, method.getDeclaringClass().getPackage()))) {
            return res;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            IMethodBinding res2 = Bindings.findMethodInHierarchy(interfaces[i], methodName, parameters);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodImplementation(IMethodBinding method, boolean testVisibility) {
        ITypeBinding superClass = method.getDeclaringClass().getSuperclass();
        String methodName = method.getName();
        ITypeBinding[] parameters = method.getParameterTypes();
        while (superClass != null) {
            IMethodBinding res = Bindings.findMethodInType(superClass, methodName, parameters);
            if (res != null) {
                if (Bindings.isVisibleInHierarchy(res, method.getDeclaringClass().getPackage())) {
                    return res;
                }
                return null;
            }
            superClass = superClass.getSuperclass();
        }
        return null;
    }

    public static boolean isVisibleInHierarchy(IMethodBinding member, IPackageBinding pack) {
        int otherflags = member.getModifiers();
        ITypeBinding declaringType = member.getDeclaringClass();
        if (Modifier.isPublic((int)otherflags) || Modifier.isProtected((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Modifier.isPrivate((int)otherflags)) {
            return false;
        }
        return pack == declaringType.getPackage();
    }

    public static IMethodBinding findDeclarationInHierarchy(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            ITypeBinding curr = interfaces[i];
            IMethodBinding method = Bindings.findMethodInType(curr, methodName, parameters);
            if (method != null) {
                return method;
            }
            method = Bindings.findDeclarationInHierarchy(interfaces[i], methodName, parameters);
            if (method != null) {
                return method;
            }
            ++i;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null) {
            IMethodBinding method = Bindings.findMethodInType(superClass, methodName, parameters);
            if (method != null) {
                return method;
            }
            method = Bindings.findDeclarationInHierarchy(superClass, methodName, parameters);
            if (method != null) {
                return method;
            }
        }
        return null;
    }

    public static ITypeBinding[] getAllSuperTypes(ITypeBinding type) {
        HashSet result = new HashSet();
        Bindings.collectSuperTypes(type, result);
        result.remove(type);
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private static void collectSuperTypes(ITypeBinding curr, Set collection) {
        if (collection.add(curr)) {
            ITypeBinding[] interfaces = curr.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                Bindings.collectSuperTypes(interfaces[i], collection);
                ++i;
            }
            ITypeBinding superClass = curr.getSuperclass();
            if (superClass != null) {
                Bindings.collectSuperTypes(superClass, collection);
            }
        }
    }

    public static boolean visitHierarchy(ITypeBinding type, TypeBindingVisitor visitor) {
        boolean result = Bindings.visitSuperclasses(type, visitor);
        if (result) {
            result = Bindings.visitInterfaces(type, visitor);
        }
        return result;
    }

    public static boolean visitInterfaces(ITypeBinding type, TypeBindingVisitor visitor) {
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!visitor.visit(interfaces[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean visitSuperclasses(ITypeBinding type, TypeBindingVisitor visitor) {
        while ((type = type.getSuperclass()) != null) {
            if (visitor.visit(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualMethod(IMethodBinding method, String methodName, ITypeBinding[] parameters) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        ITypeBinding[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] != methodParameters[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding hierarchyType, String fullyQualifiedTypeName) {
        ITypeBinding res;
        if (hierarchyType.isArray() || hierarchyType.isPrimitive()) {
            return null;
        }
        if (fullyQualifiedTypeName.equals(hierarchyType.getQualifiedName())) {
            return hierarchyType;
        }
        ITypeBinding superClass = hierarchyType.getSuperclass();
        if (superClass != null && (res = Bindings.findTypeInHierarchy(superClass, fullyQualifiedTypeName)) != null) {
            return res;
        }
        ITypeBinding[] superInterfaces = hierarchyType.getInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            ITypeBinding res2 = Bindings.findTypeInHierarchy(superInterfaces[i], fullyQualifiedTypeName);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public static IVariableBinding getAssignedVariable(Assignment assignment) {
        Expression leftHand = assignment.getLeftHandSide();
        switch (leftHand.getNodeType()) {
            case 42: {
                return (IVariableBinding)((SimpleName)leftHand).resolveBinding();
            }
            case 40: {
                return (IVariableBinding)((QualifiedName)leftHand).getName().resolveBinding();
            }
            case 22: {
                return ((FieldAccess)leftHand).resolveFieldBinding();
            }
            case 47: {
                return ((SuperFieldAccess)leftHand).resolveFieldBinding();
            }
        }
        return null;
    }

    public static boolean isSuperType(ITypeBinding type, ITypeBinding candidate) {
        if (candidate.isArray() || candidate.isPrimitive()) {
            return false;
        }
        if (Bindings.equals((IBinding)candidate, (IBinding)type)) {
            return true;
        }
        ITypeBinding superClass = candidate.getSuperclass();
        if (superClass != null && Bindings.isSuperType(type, superClass)) {
            return true;
        }
        if (type.isInterface()) {
            ITypeBinding[] superInterfaces = candidate.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                if (Bindings.isSuperType(type, superInterfaces[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static ICompilationUnit findCompilationUnit(ITypeBinding typeBinding, IJavaProject project) throws JavaModelException {
        if (typeBinding.isFromSource()) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            typeBinding = typeBinding.getDeclaringClass();
lbl4:
            // 2 sources

            ** while (typeBinding != null && !typeBinding.isTopLevel())
        }
lbl5:
        // 1 sources

        if (typeBinding != null && (type = project.findType(packageName = (pack = typeBinding.getPackage()).isUnnamed() != false ? "" : pack.getName(), typeBinding.getName())) != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    public static IField findField(IVariableBinding field, IJavaProject in) throws JavaModelException {
        Assert.isTrue(field.isField());
        ITypeBinding declaringClassBinding = field.getDeclaringClass();
        if (declaringClassBinding == null) {
            return null;
        }
        IType declaringClass = Bindings.findType(declaringClassBinding, in);
        if (declaringClass == null) {
            return null;
        }
        IField foundField = declaringClass.getField(field.getName());
        if (!foundField.exists()) {
            return null;
        }
        return foundField;
    }

    public static IType findType(ITypeBinding type, IJavaProject scope) throws JavaModelException {
        if (type.isPrimitive() || type.isAnonymous() || type.isNullType()) {
            return null;
        }
        if (type.isArray()) {
            return Bindings.findType(type.getElementType(), scope);
        }
        String[] typeElements = Bindings.getNameComponents(type);
        IJavaElement element = scope.findElement(Bindings.getPathToCompilationUnit(type.getPackage(), typeElements[0]));
        IType candidate = null;
        if (element instanceof ICompilationUnit) {
            candidate = ((ICompilationUnit)element).getType(typeElements[0]);
        } else if (element instanceof IClassFile) {
            candidate = ((IClassFile)element).getType();
        } else if (element == null) {
            candidate = type.isMember() ? JavaModelUtil.findType(scope, Bindings.getFullyQualifiedName(type.getDeclaringClass())) : JavaModelUtil.findType(scope, Bindings.getFullyQualifiedName(type));
        }
        if (candidate == null || typeElements.length == 1) {
            return candidate;
        }
        return Bindings.findTypeInType(typeElements, candidate);
    }

    public static IMethod findMethod(IMethodBinding method, IJavaProject scope) throws JavaModelException {
        IType type = Bindings.findType(method.getDeclaringClass(), scope);
        if (type == null) {
            return null;
        }
        return Bindings.findMethod(method, type);
    }

    public static IMethod findMethod(IMethodBinding method, IType type) throws JavaModelException {
        IMethod[] candidates = type.getMethods();
        int i = 0;
        while (i < candidates.length) {
            IMethod candidate = candidates[i];
            if (candidate.getElementName().equals(method.getName()) && Bindings.sameParameters(method, candidate)) {
                return candidate;
            }
            ++i;
        }
        return null;
    }

    private static IPath getPathToCompilationUnit(IPackageBinding packageBinding, String topLevelTypeName) {
        Path result = new Path("");
        String[] packageNames = packageBinding.getNameComponents();
        int i = 0;
        while (i < packageNames.length) {
            result = result.append(packageNames[i]);
            ++i;
        }
        return result.append(String.valueOf(topLevelTypeName) + ".java");
    }

    private static IType findTypeInType(String[] typeElements, IType jmType) {
        IType result = jmType;
        int i = 1;
        while (i < typeElements.length) {
            if (!(result = result.getType(typeElements[i])).exists()) {
                return null;
            }
            ++i;
        }
        return result == jmType ? null : result;
    }

    private static boolean sameParameters(IMethodBinding method, IMethod candidate) throws JavaModelException {
        String[] candidateParameters;
        ITypeBinding[] methodParamters = method.getParameterTypes();
        if (methodParamters.length != (candidateParameters = candidate.getParameterTypes()).length) {
            return false;
        }
        IType scope = candidate.getDeclaringType();
        int i = 0;
        while (i < methodParamters.length) {
            ITypeBinding methodParameter = methodParamters[i];
            String candidateParameter = candidateParameters[i];
            if (!Bindings.sameParameter(methodParameter, candidateParameter, scope)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean sameParameter(ITypeBinding type, String candidate, IType scope) throws JavaModelException {
        if (type.getDimensions() != Signature.getArrayCount((String)candidate)) {
            return false;
        }
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (Bindings.isPrimitiveType(candidate = Signature.getElementType((String)candidate)) || type.isPrimitive()) {
            return type.getName().equals(Signature.toString((String)candidate));
        }
        if (Bindings.isResolvedType(candidate)) {
            return Signature.toString((String)candidate).equals(Bindings.getFullyQualifiedName(type));
        }
        String[][] qualifiedCandidates = scope.resolveType(Signature.toString((String)candidate));
        if (qualifiedCandidates == null || qualifiedCandidates.length == 0) {
            return false;
        }
        String packageName = type.getPackage().isUnnamed() ? "" : type.getPackage().getName();
        String typeName = Bindings.getTypeQualifiedName(type);
        int i = 0;
        while (i < qualifiedCandidates.length) {
            String[] qualifiedCandidate = qualifiedCandidates[i];
            if (qualifiedCandidate[0].equals(packageName) && qualifiedCandidate[1].equals(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isPrimitiveType(String s) {
        char c = s.charAt(0);
        return c != 'L' && c != 'Q';
    }

    private static boolean isResolvedType(String s) {
        int arrayCount = Signature.getArrayCount((String)s);
        return s.charAt(arrayCount) == 'L';
    }

    public static ITypeBinding normalizeTypeBinding(ITypeBinding binding) {
        if (binding != null && !binding.isNullType() && !"void".equals(binding.getName())) {
            if (binding.isAnonymous()) {
                ITypeBinding[] baseBindings = binding.getInterfaces();
                if (baseBindings.length > 0) {
                    return baseBindings[0];
                }
                return binding.getSuperclass();
            }
            return binding;
        }
        return null;
    }

    public static ITypeBinding getBindingOfParentType(ASTNode node) {
        while (node != null) {
            if (node instanceof TypeDeclaration) {
                return ((TypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public static void visitAllBindings(ASTNode astRoot, TypeBindingVisitor visitor) {
        try {
            astRoot.accept((ASTVisitor)new AllBindingsVisitor(visitor));
        }
        catch (AllBindingsVisitor.VisitCancelledException visitCancelledException) {}
    }

    private static class AllBindingsVisitor
    extends GenericVisitor {
        private final TypeBindingVisitor fVisitor;

        public AllBindingsVisitor(TypeBindingVisitor visitor) {
            super(true);
            this.fVisitor = visitor;
        }

        public boolean visit(SimpleName node) {
            ITypeBinding binding = node.resolveTypeBinding();
            if (binding != null) {
                boolean res = this.fVisitor.visit(binding);
                if (res) {
                    res = Bindings.visitHierarchy(binding, this.fVisitor);
                }
                if (!res) {
                    throw new VisitCancelledException();
                }
            }
            return false;
        }

        private static class VisitCancelledException
        extends RuntimeException {
            VisitCancelledException() {
            }
        }
    }
}

