/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class CompilationUnitRewrite {
    private ICompilationUnit fCu;
    private CompilationUnit fRoot;
    private List fTextEditGroups;
    private OldASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ImportRemover fImportRemover;
    static /* synthetic */ Class class$0;

    public CompilationUnitRewrite(ICompilationUnit cu) {
        this.fCu = cu;
        this.fRoot = new RefactoringASTParser(2).parse(this.fCu, true);
        this.fTextEditGroups = new ArrayList();
    }

    public void clearASTRewrite() {
        if (this.fRewrite != null) {
            this.fRewrite.removeModifications();
        }
        this.fTextEditGroups = new ArrayList();
    }

    public void clearASTAndImportRewrites() {
        this.clearASTRewrite();
        this.fImportRewrite = null;
    }

    public TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fTextEditGroups.add(result);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextChange createChange() throws CoreException {
        boolean needsImportRewrite;
        boolean needsAstRewrite = this.fRewrite != null;
        boolean needsImportRemoval = this.fImportRemover != null && this.fImportRemover.hasRemovedNodes();
        boolean bl = needsImportRewrite = this.fImportRewrite != null && !this.fImportRewrite.isEmpty();
        if (!(needsAstRewrite || needsImportRemoval || needsImportRewrite)) {
            return null;
        }
        CompilationUnitChange cuChange = new CompilationUnitChange(this.fCu.getElementName(), this.fCu);
        TextBuffer buffer = TextBuffer.acquire(CompilationUnitRewrite.getFile(this.fCu));
        IDocument document = buffer.getDocument();
        MultiTextEdit multiEdit = new MultiTextEdit();
        try {
            TextEdit importsEdit;
            TextEdit rewriteEdit;
            cuChange.setEdit((TextEdit)multiEdit);
            if (needsAstRewrite && !CompilationUnitRewrite.isEmptyEdit(rewriteEdit = this.fRewrite.rewriteAST(document, null))) {
                multiEdit.addChild(rewriteEdit);
                Iterator iter = this.fTextEditGroups.iterator();
                while (iter.hasNext()) {
                    cuChange.addTextEditGroup((TextEditGroup)iter.next());
                }
            }
            if (needsImportRemoval) {
                ITypeBinding[] bindings = this.fImportRemover.getImportsToRemove();
                int i = 0;
                while (i < bindings.length) {
                    this.getImportRewrite().removeImport(bindings[i]);
                    ++i;
                }
            }
            if (this.fImportRewrite != null && !this.fImportRewrite.isEmpty() && !CompilationUnitRewrite.isEmptyEdit(importsEdit = this.fImportRewrite.createEdit(document))) {
                multiEdit.addChild(importsEdit);
                String importUpdateName = RefactoringCoreMessages.getString("ASTData.update_imports");
                cuChange.addTextEditGroup(new TextEditGroup(importUpdateName, importsEdit));
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            TextBuffer.release(buffer);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        TextBuffer.release(buffer);
        if (CompilationUnitRewrite.isEmptyEdit((TextEdit)multiEdit)) {
            return null;
        }
        return cuChange;
    }

    private static boolean isEmptyEdit(TextEdit edit) {
        Class<?> clazz = edit.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.text.edits.MultiTextEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz == clazz2 && !edit.hasChildren();
    }

    private static IFile getFile(ICompilationUnit cu) {
        return (IFile)cu.getPrimary().getResource();
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public CompilationUnit getRoot() {
        return this.fRoot;
    }

    public OldASTRewrite getOldRewrite() {
        if (this.fRewrite == null) {
            this.fRewrite = new OldASTRewrite((ASTNode)this.fRoot);
        }
        return this.fRewrite;
    }

    public ASTRewrite getASTRewrite() {
        return this.getOldRewrite();
    }

    public ImportRewrite getImportRewrite() {
        if (this.fImportRewrite == null) {
            try {
                this.fImportRewrite = new ImportRewrite(this.fCu);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.fImportRewrite;
    }

    public ImportRemover getImportRemover() {
        if (this.fImportRemover == null) {
            this.fImportRemover = new ImportRemover(this.fRoot);
        }
        return this.fImportRemover;
    }
}

