/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintCollector;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariableFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.DeclaringTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.FullConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.RawBindingVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeBindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeConstraintFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

class ExtractInterfaceUtil {
    private final ICompilationUnit fInputTypeWorkingCopy;
    private final ICompilationUnit fSupertypeWorkingCopy;
    private final WorkingCopyOwner fWorkingCopyOwner;
    private static ICompilationUnit fCu;
    private final IType fInputType;

    private ExtractInterfaceUtil(ICompilationUnit inputTypeWorkingCopy, ICompilationUnit supertypeWorkingCopy, WorkingCopyOwner workingCopyOwner, IType inputType) {
        Assert.isNotNull(inputTypeWorkingCopy);
        this.fSupertypeWorkingCopy = supertypeWorkingCopy;
        this.fInputTypeWorkingCopy = inputTypeWorkingCopy;
        this.fWorkingCopyOwner = workingCopyOwner;
        this.fInputType = inputType;
    }

    private static ConstraintVariable[] getAllOfType(ITypeConstraint[] constraints, ITypeBinding binding) {
        HashSet<ConstraintVariable> result = new HashSet<ConstraintVariable>();
        ITypeBinding typeBinding = binding;
        int i = 0;
        while (i < constraints.length) {
            ITypeConstraint constraint = constraints[i];
            if (constraint.isSimpleTypeConstraint()) {
                SimpleTypeConstraint simple = (SimpleTypeConstraint)constraint;
                if (simple.getLeft().isEqualBinding(typeBinding)) {
                    result.add(simple.getLeft());
                }
                if (simple.getRight().isEqualBinding(typeBinding)) {
                    result.add(simple.getRight());
                }
                if (simple.getRight().getBinding() != null && simple.getRight().getBinding().isArray() && Bindings.equals((IBinding)simple.getRight().getBinding().getElementType(), (IBinding)typeBinding)) {
                    result.add(simple.getRight());
                }
                if (simple.getLeft().getBinding() != null && simple.getLeft().getBinding().isArray() && Bindings.equals((IBinding)simple.getLeft().getBinding().getElementType(), (IBinding)typeBinding)) {
                    result.add(simple.getLeft());
                }
            } else {
                CompositeOrTypeConstraint cotc = (CompositeOrTypeConstraint)constraint;
                result.addAll(Arrays.asList(ExtractInterfaceUtil.getAllOfType(cotc.getConstraints(), binding)));
            }
            ++i;
        }
        return result.toArray(new ConstraintVariable[result.size()]);
    }

    private ConstraintVariable[] getUpdatableVariables(ITypeBinding inputTypeBinding, IType theType, IType theSupertype, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        ITypeBinding interfaceBinding = ExtractInterfaceUtil.getSuperTypeBinding(inputTypeBinding, theSupertype);
        ICompilationUnit[] referringCus = this.getCusToParse(theType, theSupertype, pm, status);
        this.checkCompileErrors(referringCus, status);
        if (status.hasFatalError()) {
            return new ConstraintVariable[0];
        }
        ITypeConstraint[] constraints = this.getConstraints(referringCus);
        return ExtractInterfaceUtil.getUpdatableVariables(constraints, inputTypeBinding, interfaceBinding);
    }

    private void checkCompileErrors(ICompilationUnit[] referringCus, RefactoringStatus status) throws JavaModelException {
        int i = 0;
        while (i < referringCus.length) {
            ICompilationUnit unit = referringCus[i];
            String source = unit.getSource();
            CompilationUnit cuNode = this.getAST(unit);
            IProblem[] problems = ASTNodes.getProblems((ASTNode)cuNode, 2, 2);
            int j = 0;
            while (j < problems.length) {
                IProblem problem = problems[j];
                if (problem.isError()) {
                    JavaStringStatusContext context = new JavaStringStatusContext(source, new SourceRange(problem));
                    status.addFatalError(problem.getMessage(), (RefactoringStatusContext)context);
                }
                ++j;
            }
            ++i;
        }
    }

    private static ITypeBinding getSuperTypeBinding(ITypeBinding typeBinding, IType superType) {
        Set setOfAll = TypeBindings.getSuperTypes(typeBinding);
        setOfAll.add(ASTCreator.createAST(fCu, null).getAST().resolveWellKnownType("java.lang.Object"));
        ITypeBinding[] all = setOfAll.toArray(new ITypeBinding[setOfAll.size()]);
        int i = 0;
        while (i < all.length) {
            ITypeBinding superTypeBinding = all[i];
            if (ExtractInterfaceUtil.isBindingForType(superTypeBinding, superType)) {
                return superTypeBinding;
            }
            ++i;
        }
        return null;
    }

    private static boolean isBindingForType(ITypeBinding typeBinding, IType type) {
        if (!typeBinding.getName().equals(type.getElementName())) {
            return false;
        }
        if (typeBinding.getPackage().isUnnamed() != type.getPackageFragment().isDefaultPackage()) {
            return false;
        }
        return typeBinding.getPackage().isUnnamed() || type.getPackageFragment().isDefaultPackage() || typeBinding.getPackage().getName().equals(type.getPackageFragment().getElementName());
    }

    public static CompilationUnitRange[] updateReferences(TextChangeManager manager, IType inputType, IType supertypeToUse, WorkingCopyOwner workingCopyOwner, boolean updateInputTypeCu, IProgressMonitor pm, RefactoringStatus status, CodeGenerationSettings settings) throws CoreException {
        ICompilationUnit typeWorkingCopy;
        fCu = typeWorkingCopy = inputType.getCompilationUnit();
        ExtractInterfaceUtil inst = new ExtractInterfaceUtil(typeWorkingCopy, supertypeToUse.getCompilationUnit(), workingCopyOwner, inputType);
        ITypeBinding inputTypeBinding = ExtractInterfaceUtil.getTypeBinding(inputType, workingCopyOwner);
        ConstraintVariable[] updatableVars = inst.getUpdatableVariables(inputTypeBinding, inputType, supertypeToUse, pm, status);
        if (status.hasFatalError()) {
            return new CompilationUnitRange[0];
        }
        String typeName = inputType.getElementName();
        CompilationUnitRange[] ranges = inst.getCompilationUnitRanges(updatableVars, inputType, inputTypeBinding);
        HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
        HashMap<ICompilationUnit, String> cuToImportType = new HashMap<ICompilationUnit, String>();
        int i = 0;
        while (i < ranges.length) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            CompilationUnitRange range = ranges[i];
            ICompilationUnit cu = range.getCompilationUnit();
            if (updateInputTypeCu || !cu.equals(typeWorkingCopy)) {
                TextChange change = ExtractInterfaceUtil.getTextChange(manager, cu);
                if (!cus.contains(cu)) {
                    cus.add(cu);
                    ImportRewrite importRewrite = new ImportRewrite(cu);
                    cuToImportType.put(cu, importRewrite.addImport(supertypeToUse.getFullyQualifiedName()));
                    TextEdit importEdit = importRewrite.createEdit((IDocument)new Document(cu.getSource()));
                    TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("ExtractInterfaceUtil.update_imports"), importEdit);
                }
                TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("ExtractInterfaceUtil.update_reference"), ExtractInterfaceUtil.createTypeUpdateEdit(range.getSourceRange(), typeName, (String)cuToImportType.get(cu)));
            }
            ++i;
        }
        return ranges;
    }

    public static TextChange getTextChange(TextChangeManager manager, ICompilationUnit cu) throws CoreException {
        if (manager.containsChangesIn(cu) || cu.getResource().exists()) {
            return manager.get(cu);
        }
        DocumentChange result = new DocumentChange(cu.getElementName(), (IDocument)new Document(cu.getSource()));
        manager.manage(cu, (TextChange)result);
        return result;
    }

    private static TextEdit createTypeUpdateEdit(ISourceRange sourceRange, String className, String interfaceName) {
        int offset = sourceRange.getOffset() + sourceRange.getLength() - className.length();
        return new ReplaceEdit(offset, className.length(), interfaceName);
    }

    private static ConstraintVariable[] getUpdatableVariables(ITypeConstraint[] constraints, ITypeBinding classBinding, ITypeBinding interfaceBinding) {
        int sizeOfBad;
        HashSet badConstraints;
        HashSet<ConstraintVariable> badVariables;
        HashSet<ConstraintVariable> allVariablesOfType = new HashSet<ConstraintVariable>(Arrays.asList(ExtractInterfaceUtil.getAllOfType(constraints, classBinding)));
        ConstraintVariable[] initialBad = ExtractInterfaceUtil.getInitialBad(allVariablesOfType, badVariables = new HashSet<ConstraintVariable>(), badConstraints = new HashSet(), constraints, interfaceBinding);
        if (initialBad == null || initialBad.length == 0) {
            return allVariablesOfType.toArray(new ConstraintVariable[allVariablesOfType.size()]);
        }
        badVariables.addAll(Arrays.asList(initialBad));
        boolean repeat = false;
        do {
            sizeOfBad = badVariables.size();
            int i = 0;
            while (i < constraints.length) {
                ITypeConstraint constraint = constraints[i];
                if (constraint.isSimpleTypeConstraint()) {
                    SimpleTypeConstraint con = (SimpleTypeConstraint)constraint;
                    ConstraintVariable left = con.getLeft();
                    ConstraintVariable right = con.getRight();
                    if (allVariablesOfType.contains(left) && badVariables.contains(right) && !badVariables.contains(left)) {
                        badVariables.add(left);
                    }
                    if ((con.isEqualsConstraint() || con.isDefinesConstraint()) && allVariablesOfType.contains(right) && badVariables.contains(left) && !badVariables.contains(right)) {
                        badVariables.add(right);
                    }
                }
                ++i;
            }
        } while (repeat = sizeOfBad < badVariables.size());
        HashSet<ConstraintVariable> updatable = new HashSet<ConstraintVariable>(allVariablesOfType);
        updatable.removeAll(badVariables);
        return updatable.toArray(new ConstraintVariable[updatable.size()]);
    }

    private static ConstraintVariable[] getInitialBad(Set setOfAll, Set badVariables, Set badConstraints, ITypeConstraint[] constraints, ITypeBinding interfaceBinding) {
        RawBindingVariable interfaceVariable = new RawBindingVariable(interfaceBinding);
        int i = 0;
        while (i < constraints.length) {
            ITypeConstraint[] subConstraints;
            ITypeConstraint constraint = constraints[i];
            if (constraint.isSimpleTypeConstraint()) {
                SimpleTypeConstraint simple = (SimpleTypeConstraint)constraint;
                if (simple.isSubtypeConstraint() && ExtractInterfaceUtil.canAddLeftSideToInitialBadSet(simple, setOfAll, (ConstraintVariable)interfaceVariable)) {
                    badVariables.add(simple.getLeft());
                    badConstraints.add(simple);
                }
            } else if (constraint instanceof CompositeOrTypeConstraint && ExtractInterfaceUtil.canAddLeftSideToInitialBadSet(subConstraints = ((CompositeOrTypeConstraint)constraint).getConstraints(), setOfAll, (ConstraintVariable)interfaceVariable)) {
                badVariables.add(((SimpleTypeConstraint)subConstraints[0]).getLeft());
                badConstraints.add(subConstraints[0]);
                badConstraints.add(constraint);
            }
            ++i;
        }
        return badVariables.toArray(new ConstraintVariable[badVariables.size()]);
    }

    private static boolean canAddLeftSideToInitialBadSet(SimpleTypeConstraint sc, Set setOfAll, ConstraintVariable interfaceVariable) {
        ConstraintVariable left = sc.getLeft();
        ConstraintVariable right = sc.getRight();
        if (!(left instanceof ExpressionVariable) && !(left instanceof TypeVariable)) {
            return false;
        }
        if (!setOfAll.contains(left)) {
            return false;
        }
        if (interfaceVariable.isSubtypeOf(right)) {
            return false;
        }
        if (setOfAll.contains(right) && !(right instanceof DeclaringTypeVariable)) {
            return false;
        }
        return !(right instanceof DeclaringTypeVariable) || right.getBinding() != null;
    }

    private static boolean canAddLeftSideToInitialBadSet(ITypeConstraint[] subConstraints, Set setOfAll, ConstraintVariable interfaceVariable) {
        if (subConstraints.length == 0) {
            return false;
        }
        if (!ExtractInterfaceUtil.allAreSimpleConstraints(subConstraints)) {
            return false;
        }
        SimpleTypeConstraint[] simpleTypeConstraints = ExtractInterfaceUtil.toSimpleConstraintArray(subConstraints);
        if (!ExtractInterfaceUtil.allHaveSameLeftSide(simpleTypeConstraints)) {
            return false;
        }
        ConstraintVariable left = simpleTypeConstraints[0].getLeft();
        if (!(left instanceof ExpressionVariable)) {
            return false;
        }
        if (!setOfAll.contains(left)) {
            return false;
        }
        return !ExtractInterfaceUtil.rightSideIsSubtypeOf(simpleTypeConstraints, interfaceVariable);
    }

    private static boolean rightSideIsSubtypeOf(SimpleTypeConstraint[] simpleTypeConstraints, ConstraintVariable interfaceVariable) {
        int i = 0;
        while (i < simpleTypeConstraints.length) {
            ConstraintVariable right = simpleTypeConstraints[i].getRight();
            if (right.isSubtypeOf(interfaceVariable)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static SimpleTypeConstraint[] toSimpleConstraintArray(ITypeConstraint[] subConstraints) {
        List<ITypeConstraint> result = Arrays.asList(subConstraints);
        return result.toArray(new SimpleTypeConstraint[result.size()]);
    }

    private static boolean allAreSimpleConstraints(ITypeConstraint[] subConstraints) {
        int i = 0;
        while (i < subConstraints.length) {
            if (!subConstraints[i].isSimpleTypeConstraint()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean allHaveSameLeftSide(SimpleTypeConstraint[] constraints) {
        Assert.isTrue(constraints.length > 0);
        ConstraintVariable first = constraints[0].getLeft();
        int i = 1;
        while (i < constraints.length) {
            if (!first.equals(constraints[i].getLeft())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ITypeConstraint[] getConstraints(ICompilationUnit[] referringCus) {
        HashSet<ITypeConstraint> result = new HashSet<ITypeConstraint>();
        ConstraintCollector collector = new ConstraintCollector(new ExtractInterfaceConstraintCreator(this.fInputType));
        int i = 0;
        while (i < referringCus.length) {
            ICompilationUnit unit = referringCus[i];
            this.getAST(unit).accept((ASTVisitor)collector);
            result.addAll(Arrays.asList(collector.getConstraints()));
            collector.clear();
            ++i;
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    private CompilationUnit getAST(ICompilationUnit unit) {
        return ASTCreator.createAST(unit, this.fWorkingCopyOwner);
    }

    private ICompilationUnit[] getCusToParse(IType theType, IType theSupertype, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray;
        try {
            pm.beginTask("", 2);
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)theType, (int)2);
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)theType);
            ICompilationUnit[] workingCopies = ExtractInterfaceUtil.getWorkingCopies(theType.getCompilationUnit(), theSupertype.getCompilationUnit());
            if (workingCopies.length == 0) {
                workingCopies = null;
            }
            SearchResultGroup[] typeReferences = RefactoringSearchEngine.search(pattern, scope, (IProgressMonitor)new SubProgressMonitor(pm, 1), workingCopies, status);
            ICompilationUnit[] typeReferencingCus = ExtractInterfaceUtil.getCus(typeReferences);
            ICompilationUnit[] fieldAndMethodReferencingCus = this.fieldAndMethodReferringCus(theType, typeReferences, workingCopies, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            iCompilationUnitArray = ExtractInterfaceUtil.merge(fieldAndMethodReferencingCus, typeReferencingCus);
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iCompilationUnitArray;
    }

    private ASTNode[] getAstNodes(SearchResultGroup searchResultGroup) {
        ICompilationUnit cu = searchResultGroup.getCompilationUnit();
        if (cu == null) {
            return new ASTNode[0];
        }
        CompilationUnit cuNode = this.getAST(cu);
        return ASTNodeSearchUtil.getAstNodes(searchResultGroup.getSearchResults(), cuNode);
    }

    private ICompilationUnit[] fieldAndMethodReferringCus(IType theType, SearchResultGroup[] typeReferences, ICompilationUnit[] wcs, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchPattern pattern = this.createPatternForReferencingFieldsAndMethods(typeReferences);
        if (pattern == null) {
            return new ICompilationUnit[0];
        }
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)theType);
        ICompilationUnit[] units = RefactoringSearchEngine.findAffectedCompilationUnits(pattern, scope, pm, status);
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(units.length);
        int i = 0;
        while (i < units.length) {
            result.add(ExtractInterfaceUtil.getUnproceededElement(units[i], wcs));
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private static ICompilationUnit getUnproceededElement(ICompilationUnit unit, ICompilationUnit[] wcs) {
        if (wcs == null) {
            return unit;
        }
        int i = 0;
        while (i < wcs.length) {
            if (ExtractInterfaceUtil.proceeds(wcs[i], unit)) {
                return wcs[i];
            }
            ++i;
        }
        return unit;
    }

    private static boolean proceeds(ICompilationUnit wc, ICompilationUnit unit) {
        return wc.getResource() == null || wc.getResource().equals((Object)unit.getResource());
    }

    private SearchPattern createPatternForReferencingFieldsAndMethods(SearchResultGroup[] typeReferences) throws JavaModelException {
        return RefactoringSearchEngine.createOrPattern((IJavaElement[])this.getReferencingFieldsAndMethods(typeReferences), 3);
    }

    private IMethod[] getReferencingMethods(ASTNode[] typeReferenceNodes) throws JavaModelException {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        int i = 0;
        while (i < typeReferenceNodes.length) {
            ASTNode node = typeReferenceNodes[i];
            IJavaProject scope = ASTCreator.getCu(node).getJavaProject();
            IMethod method = ExtractInterfaceUtil.getMethod(node, scope);
            if (method != null) {
                result.add(method);
            }
            ++i;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    private IField[] getReferencingFields(ASTNode[] typeReferenceNodes) throws JavaModelException {
        ArrayList<IField> result = new ArrayList<IField>();
        int i = 0;
        while (i < typeReferenceNodes.length) {
            ASTNode node = typeReferenceNodes[i];
            IJavaProject scope = ASTCreator.getCu(node).getJavaProject();
            result.addAll(Arrays.asList(ExtractInterfaceUtil.getFields(node, scope)));
            ++i;
        }
        return result.toArray(new IField[result.size()]);
    }

    private IMember[] getReferencingFieldsAndMethods(SearchResultGroup[] typeReferences) throws JavaModelException {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < typeReferences.length) {
            SearchResultGroup group = typeReferences[i];
            ASTNode[] typeReferenceNodes = this.getAstNodes(group);
            result.addAll(Arrays.asList(this.getReferencingMethods(typeReferenceNodes)));
            result.addAll(Arrays.asList(this.getReferencingFields(typeReferenceNodes)));
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private static IMethod getMethod(ASTNode node, IJavaProject scope) throws JavaModelException {
        MethodDeclaration declaration;
        IMethodBinding binding;
        if (node instanceof Type && node.getParent() instanceof MethodDeclaration) {
            MethodDeclaration declaration2 = (MethodDeclaration)node.getParent();
            IMethodBinding binding2 = declaration2.resolveBinding();
            if (binding2 != null) {
                return Bindings.findMethod(binding2, scope);
            }
        } else if (node instanceof Type && ExtractInterfaceUtil.isMethodParameter(node.getParent()) && (binding = (declaration = (MethodDeclaration)node.getParent().getParent()).resolveBinding()) != null) {
            return Bindings.findMethod(binding, scope);
        }
        return null;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof VariableDeclaration && node.getParent() instanceof MethodDeclaration && ((MethodDeclaration)node.getParent()).parameters().contains(node);
    }

    private static IField[] getFields(ASTNode node, IJavaProject scope) throws JavaModelException {
        FieldDeclaration parent;
        if (node instanceof Type && node.getParent() instanceof FieldDeclaration && (parent = (FieldDeclaration)node.getParent()).getType() == node) {
            ArrayList<IField> result = new ArrayList<IField>(parent.fragments().size());
            Iterator iter = parent.fragments().iterator();
            while (iter.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
                IField field = ExtractInterfaceUtil.getField(fragment, scope);
                if (field == null) continue;
                result.add(field);
            }
            return result.toArray(new IField[result.size()]);
        }
        return new IField[0];
    }

    private static IField getField(VariableDeclarationFragment fragment, IJavaProject in) throws JavaModelException {
        IBinding binding = fragment.getName().resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return null;
        }
        return Bindings.findField(variableBinding, in);
    }

    private static ICompilationUnit[] merge(ICompilationUnit[] array1, ICompilationUnit[] array2) {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        result.addAll(Arrays.asList(array1));
        result.addAll(Arrays.asList(array2));
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private static ICompilationUnit[] getCus(SearchResultGroup[] groups) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(groups.length);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.add(WorkingCopyUtil.getWorkingCopyIfExists(cu));
            }
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private static ICompilationUnit[] getWorkingCopies(ICompilationUnit precedingWC1, ICompilationUnit precedingWC2) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(2);
        if (precedingWC1 != null && precedingWC1.isWorkingCopy()) {
            result.add(precedingWC1);
        }
        if (precedingWC2 != null && precedingWC2.isWorkingCopy()) {
            result.add(precedingWC2);
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private static ITypeBinding getTypeBinding(IType theType, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        return ExtractInterfaceUtil.getTypeDeclarationNode(theType, workingCopyOwner).resolveBinding();
    }

    private static TypeDeclaration getTypeDeclarationNode(IType theType, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        return ASTNodeSearchUtil.getTypeDeclarationNode(theType, ASTCreator.createAST(theType.getCompilationUnit(), workingCopyOwner));
    }

    private CompilationUnitRange[] getCompilationUnitRanges(ConstraintVariable[] variables, IType inputType, ITypeBinding inputTypeBinding) throws CoreException {
        HashSet<CompilationUnitRange> ranges = new HashSet<CompilationUnitRange>();
        IJavaProject scope = inputType.getJavaProject();
        int i = 0;
        while (i < variables.length) {
            CompilationUnitRange range = this.getRange(variables[i], scope, inputTypeBinding);
            if (range != null) {
                ranges.add(range);
            }
            ++i;
        }
        return ranges.toArray(new CompilationUnitRange[ranges.size()]);
    }

    private CompilationUnitRange getRange(ConstraintVariable variable, IJavaProject scope, ITypeBinding inputTypeBinding) throws CoreException {
        if (variable instanceof DeclaringTypeVariable) {
            return null;
        }
        if (variable instanceof RawBindingVariable) {
            return null;
        }
        if (variable instanceof ParameterTypeVariable) {
            return this.getRange((ParameterTypeVariable)variable, scope);
        }
        if (variable instanceof ReturnTypeVariable) {
            return this.getRange((ReturnTypeVariable)variable, scope);
        }
        if (variable instanceof TypeVariable) {
            return this.getRange((TypeVariable)variable);
        }
        if (variable instanceof ExpressionVariable) {
            return this.getRange((ExpressionVariable)variable, inputTypeBinding);
        }
        return null;
    }

    private CompilationUnitRange getRange(ExpressionVariable variable, ITypeBinding inputTypeBinding) {
        if (inputTypeBinding == null) {
            return null;
        }
        if ((variable.getExpressionType() == 42 || variable.getExpressionType() == 40) && Bindings.equals((IBinding)inputTypeBinding, variable.getExpressionBinding())) {
            return variable.getCompilationUnitRange();
        }
        return null;
    }

    private CompilationUnitRange getRange(TypeVariable variable) {
        return variable.getCompilationUnitRange();
    }

    private CompilationUnitRange getRange(ReturnTypeVariable variable, IJavaProject scope) throws CoreException {
        IMethodBinding methodBinding = variable.getMethodBinding();
        IMethod method = this.getMethod(methodBinding, scope);
        if (method == null) {
            return null;
        }
        return new CompilationUnitRange(method.getCompilationUnit(), ExtractInterfaceUtil.getReturnTypeRange(method));
    }

    private CompilationUnitRange getRange(ParameterTypeVariable variable, IJavaProject scope) throws CoreException {
        IMethodBinding methodBinding = variable.getMethodBinding();
        int paramIndex = variable.getParameterIndex();
        IMethod method = this.getMethod(methodBinding, scope);
        if (method == null) {
            return null;
        }
        return new CompilationUnitRange(method.getCompilationUnit(), ExtractInterfaceUtil.getParameterTypeRange(method, paramIndex));
    }

    private static ISourceRange getReturnTypeRange(IMethod method) throws CoreException {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(method.getSource().toCharArray());
        TokenScanner tokenScanner = new TokenScanner(scanner);
        ExtractInterfaceUtil.skipModifiers(tokenScanner);
        return new SourceRange(method.getSourceRange().getOffset() + tokenScanner.getCurrentStartOffset(), tokenScanner.getCurrentLength());
    }

    private static void skipModifiers(TokenScanner scanner) throws CoreException {
        int token = scanner.readNext(true);
        while (token != 158) {
            if (!TokenScanner.isModifier(token)) {
                return;
            }
            token = scanner.readNext(true);
        }
    }

    private static ISourceRange getParameterTypeRange(IMethod method, int paramIndex) throws CoreException {
        Assert.isTrue(paramIndex >= 0, "incorrect parameter");
        Assert.isTrue(paramIndex < method.getNumberOfParameters(), "too few method parameters");
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(method.getSource().toCharArray());
        TokenScanner tokenScanner = new TokenScanner(scanner);
        tokenScanner.readToToken(7);
        int i = 0;
        while (i < paramIndex) {
            tokenScanner.readToToken(90);
            ++i;
        }
        tokenScanner.readNext(true);
        return new SourceRange(method.getSourceRange().getOffset() + tokenScanner.getCurrentStartOffset(), tokenScanner.getCurrentLength());
    }

    private IMethod getMethod(IMethodBinding methodBinding, IJavaProject scope) throws JavaModelException {
        IMethod method = Bindings.findMethod(methodBinding, scope);
        IJavaElement e1 = JavaModelUtil.findInCompilationUnit(this.fInputTypeWorkingCopy, (IJavaElement)method);
        if (e1 instanceof IMethod) {
            method = (IMethod)e1;
        } else if (this.fSupertypeWorkingCopy != null && (e1 = JavaModelUtil.findInCompilationUnit(this.fSupertypeWorkingCopy, (IJavaElement)method)) instanceof IMethod) {
            method = (IMethod)e1;
        }
        return method;
    }

    private static class ExtractInterfaceConstraintCreator
    extends FullConstraintCreator {
        public ExtractInterfaceConstraintCreator(IType inputType) {
            super(new ConstraintVariableFactory(), new TypeConstraintFactory(inputType){
                private final /* synthetic */ IType val$inputType;
                {
                    this.val$inputType = iType;
                }

                public boolean filter(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator o) {
                    ITypeBinding v1Binding = v1.getBinding();
                    ITypeBinding v2Binding = v2.getBinding();
                    if (v1Binding != null && v2Binding != null) {
                        String v2Name;
                        String inputTypeName = this.val$inputType.getFullyQualifiedName();
                        String v1Name = !v1Binding.isArray() ? v1Binding.getQualifiedName() : v1Binding.getElementType().getQualifiedName();
                        String string = v2Name = !v2Binding.isArray() ? v2Binding.getQualifiedName() : v2Binding.getElementType().getQualifiedName();
                        if (!v1Name.equals(inputTypeName) && !v2Name.equals(inputTypeName)) {
                            return true;
                        }
                    }
                    return super.filter(v1, v2, o);
                }
            });
        }

        public ITypeConstraint[] create(ArrayCreation node) {
            ConstraintVariable arrayCreationVar = this.getConstraintVariableFactory().makeExpressionOrTypeVariable((Expression)node, this.getContext());
            TypeVariable typeVar = this.getConstraintVariableFactory().makeTypeVariable((Type)node.getType());
            ITypeConstraint[] equals = this.getConstraintFactory().createEqualsConstraint(arrayCreationVar, typeVar);
            return equals;
        }

        public ITypeConstraint[] create(ArrayAccess node) {
            Expression expression = node.getArray();
            ITypeConstraint[] equals = this.getConstraintFactory().createEqualsConstraint(this.getConstraintVariableFactory().makeExpressionOrTypeVariable((Expression)node, this.getContext()), this.getConstraintVariableFactory().makeExpressionOrTypeVariable(expression, this.getContext()));
            return equals;
        }

        public ITypeConstraint[] create(ArrayType node) {
            TypeVariable component = this.getConstraintVariableFactory().makeTypeVariable(node.getComponentType());
            ITypeConstraint[] equals = this.getConstraintFactory().createEqualsConstraint(this.getConstraintVariableFactory().makeTypeVariable((Type)node), component);
            return equals;
        }
    }
}

