/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;

class TopLevelTypeProblemsLabelDecorator
extends ProblemsLabelDecorator {
    public TopLevelTypeProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        super(registry);
    }

    protected boolean isInside(int pos, ISourceReference sourceElement) throws CoreException {
        if (!(sourceElement instanceof IType) || ((IType)sourceElement).getDeclaringType() != null) {
            return false;
        }
        ICompilationUnit cu = ((IType)sourceElement).getCompilationUnit();
        if (cu == null) {
            return false;
        }
        IType[] types = cu.getTypes();
        if (types.length < 1) {
            return false;
        }
        int firstTypeStartOffset = -1;
        ISourceRange range = types[0].getSourceRange();
        if (range != null) {
            firstTypeStartOffset = range.getOffset();
        }
        int lastTypeEndOffset = -1;
        range = types[types.length - 1].getSourceRange();
        if (range != null) {
            lastTypeEndOffset = range.getOffset() + range.getLength() - 1;
        }
        return pos < firstTypeStartOffset || pos > lastTypeEndOffset || this.isInside(pos, sourceElement.getSourceRange());
    }

    private boolean isInside(int pos, ISourceRange range) {
        if (range == null) {
            return false;
        }
        int offset = range.getOffset();
        return offset <= pos && pos < offset + range.getLength();
    }
}

