/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ListDialog
extends SelectionDialog {
    private IStructuredContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private Object fInput;
    private TableViewer fTableViewer;
    private boolean fAddCancelButton = false;
    private final int fShellStyle;

    public ListDialog(Shell parent, int shellStyle) {
        super(parent);
        this.fShellStyle = shellStyle;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setContentProvider(IStructuredContentProvider sp) {
        this.fContentProvider = sp;
    }

    public void setLabelProvider(ILabelProvider lp) {
        this.fLabelProvider = lp;
    }

    public void setAddCancelButton(boolean addCancelButton) {
        this.fAddCancelButton = addCancelButton;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public boolean hasFilters() {
        return this.fTableViewer.getFilters() != null && this.fTableViewer.getFilters().length != 0;
    }

    public void create() {
        this.setShellStyle(this.fShellStyle);
        super.create();
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText(this.getMessage());
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        label.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)label);
        return label;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        this.fTableViewer = new TableViewer(parent, this.getTableStyle());
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        Table table = this.fTableViewer.getTable();
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTableViewer.setInput(this.fInput);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        table.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.fAddCancelButton) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            super.createButtonsForButtonBar(parent);
        }
    }

    protected int getTableStyle() {
        return 2820;
    }
}

