/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocAccess;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.Bundle;

public class JavadocView
extends AbstractInfoView {
    private static final String DO_NOT_WARN_PREFERENCE_KEY = "JavadocView.error.doNotWarn";
    private static final int LABEL_FLAGS = 39136439;
    private static final boolean fgBrowserDoesNotWorkOnPlatform = "gtk".equalsIgnoreCase(SWT.getPlatform());
    private Browser fBrowser;
    private StyledText fText;
    private DefaultInformationControl.IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private SelectAllAction fSelectAllAction;
    private URL fStyleSheetURL;
    private boolean fIsUsingBrowserWidget;

    protected void internalCreatePartControl(Composite parent) {
        try {
            if (fgBrowserDoesNotWorkOnPlatform) {
                this.fIsUsingBrowserWidget = false;
            } else {
                this.fBrowser = new Browser(parent, 0);
                this.fIsUsingBrowserWidget = true;
            }
        }
        catch (SWTError sWTError) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            boolean doNotWarn = store.getBoolean(DO_NOT_WARN_PREFERENCE_KEY);
            if (!doNotWarn) {
                String title = InfoViewMessages.getString("JavadocView.error.noBrowser.title");
                String message = InfoViewMessages.getString("JavadocView.error.noBrowser.message");
                String toggleMessage = InfoViewMessages.getString("JavadocView.error.noBrowser.doNotWarn");
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openError((Shell)parent.getShell(), (String)title, (String)message, (String)toggleMessage, (boolean)false, null, null);
                if (dialog.getReturnCode() == 0) {
                    store.setValue(DO_NOT_WARN_PREFERENCE_KEY, dialog.getToggleState());
                }
            }
            this.fIsUsingBrowserWidget = false;
        }
        if (!this.fIsUsingBrowserWidget) {
            this.fText = new StyledText(parent, 768);
            this.fText.setEditable(false);
            this.fPresenter = new HTMLTextPresenter(false);
            this.fText.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    JavadocView.this.setInput(JavadocView.this.fText.getText());
                }
            });
        }
        this.initStyleSheetURL();
        this.getViewSite().setSelectionProvider((ISelectionProvider)new SelectionProvider(this.getControl()));
    }

    private void initStyleSheetURL() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        this.fStyleSheetURL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (this.fStyleSheetURL == null) {
            return;
        }
        try {
            this.fStyleSheetURL = Platform.asLocalURL((URL)this.fStyleSheetURL);
        }
        catch (IOException ex) {
            JavaPlugin.log(ex);
        }
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction(this.getControl(), (SelectionProvider)this.getSelectionProvider());
    }

    protected IAction getSelectAllAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return this.fSelectAllAction;
    }

    protected IAction getCopyToClipboardAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return super.getCopyToClipboardAction();
    }

    protected void setForeground(Color color) {
        this.getControl().setForeground(color);
    }

    protected void setBackground(Color color) {
        this.getControl().setBackground(color);
    }

    protected void internalDispose() {
        this.fText = null;
        this.fBrowser = null;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    protected Object computeInput(Object input) {
        if (this.getControl() == null || !(input instanceof IJavaElement)) {
            return null;
        }
        IJavaElement je = (IJavaElement)input;
        String javadocHtml = null;
        if (je.getElementType() == 5) {
            try {
                javadocHtml = this.getJavadocHtml((IJavaElement[])((ICompilationUnit)je).getTypes());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        } else {
            javadocHtml = this.getJavadocHtml(new IJavaElement[]{je});
        }
        return javadocHtml;
    }

    protected void setInput(Object input) {
        String javadocHtml = (String)input;
        if (this.fIsUsingBrowserWidget) {
            this.fBrowser.setText(javadocHtml);
        } else {
            this.fPresentation.clear();
            Rectangle size = this.fText.getClientArea();
            try {
                javadocHtml = this.fPresenter.updatePresentation(this.getSite().getShell().getDisplay(), javadocHtml, this.fPresentation, size.width, size.height);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.fText.setText(javadocHtml);
            TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
        }
    }

    private String getJavadocHtml(IJavaElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList(buffer);
                IJavaElement curr = result[i];
                if (curr instanceof IMember) {
                    HTMLPrinter.addBullet(buffer, this.getInfoText((IMember)curr));
                }
                HTMLPrinter.endBulletList(buffer);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember) {
                JavaDocCommentReader reader;
                IMember member = (IMember)curr;
                try {
                    reader = JavaDocAccess.getJavaDoc(member, true);
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph(buffer, new JavaDoc2HTMLTextReader(reader));
                }
            }
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, this.fStyleSheetURL);
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IMember member) {
        return JavaElementLabels.getElementLabel((IJavaElement)member, 39136439);
    }

    protected boolean isIgnoringEqualInput() {
        return false;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        try {
            IJavaElement element = super.findSelectedJavaElement(part, selection);
            if (element == null && part instanceof JavaEditor && selection instanceof ITextSelection) {
                JavaEditor editor = (JavaEditor)part;
                ITextSelection textSelection = (ITextSelection)selection;
                IDocumentProvider documentProvider = editor.getDocumentProvider();
                if (documentProvider == null) {
                    return null;
                }
                IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
                if (document == null) {
                    return null;
                }
                ITypedRegion typedRegion = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)textSelection.getOffset(), (boolean)false);
                if ("__java_javadoc".equals(typedRegion.getType())) {
                    return TextSelectionConverter.getElementAtOffset((JavaEditor)part, textSelection);
                }
                return null;
            }
            return element;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected Control getControl() {
        if (this.fIsUsingBrowserWidget) {
            return this.fBrowser;
        }
        return this.fText;
    }

    private class SelectAllAction
    extends Action {
        private Control fControl;
        private SelectionProvider fSelectionProvider;

        public SelectAllAction(Control control, SelectionProvider selectionProvider) {
            super("selectAll");
            Assert.isNotNull((Object)control);
            Assert.isNotNull((Object)selectionProvider);
            this.fControl = control;
            this.fSelectionProvider = selectionProvider;
            this.setEnabled(!JavadocView.this.fIsUsingBrowserWidget);
            this.setText(InfoViewMessages.getString("SelectAllAction.label"));
            this.setToolTipText(InfoViewMessages.getString("SelectAllAction.tooltip"));
            this.setDescription(InfoViewMessages.getString("SelectAllAction.description"));
            WorkbenchHelp.setHelp((IAction)this, (String)IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).selectAll();
            } else if (this.fSelectionProvider != null) {
                this.fSelectionProvider.fireSelectionChanged();
            }
        }
    }

    private static class SelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList();
        private Control fControl;

        public SelectionProvider(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SelectionProvider this$1;
                    {
                        this.this$1 = selectionProvider;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$1.fireSelectionChanged();
                    }
                });
            }
        }

        public void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] selectionChangedListeners = this.fListeners.getListeners();
            int i = 0;
            while (i < selectionChangedListeners.length) {
                ((ISelectionChangedListener)selectionChangedListeners[i]).selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fControl instanceof StyledText) {
                Document document = new Document(((StyledText)this.fControl).getSelectionText());
                return new TextSelection((IDocument)document, 0, document.getLength());
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }
}

