/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarManifestWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarOptionsPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class JarPackageWizard
extends Wizard
implements IExportWizard {
    private static String DIALOG_SETTINGS_KEY = "JarPackageWizard";
    private IStructuredSelection fSelection;
    private JarPackageData fJarPackage;
    private JarPackageWizardPage fJarPackageWizardPage;
    private boolean fHasNewDialogSettings;
    private boolean fInitializeFromJarPackage;

    public JarPackageWizard() {
        IDialogSettings workbenchSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    public void addPages() {
        super.addPages();
        this.fJarPackageWizardPage = new JarPackageWizardPage(this.fJarPackage, this.fSelection);
        this.addPage(this.fJarPackageWizardPage);
        this.addPage(new JarOptionsPage(this.fJarPackage));
        this.addPage(new JarManifestWizardPage(this.fJarPackage));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = this.getValidSelection();
        this.fJarPackage = new JarPackageData();
        this.setInitializeFromJarPackage(false);
        this.setWindowTitle(JarPackagerMessages.getString("JarPackageWizard.windowTitle"));
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, JarPackageData jarPackage) {
        Assert.isNotNull((Object)workbench);
        Assert.isNotNull((Object)jarPackage);
        this.fJarPackage = jarPackage;
        this.setInitializeFromJarPackage(true);
        this.fSelection = new StructuredSelection(this.fJarPackage.getElements());
        this.setWindowTitle(JarPackagerMessages.getString("JarPackageWizard.windowTitle"));
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.fJarPackage.setElements(this.fJarPackageWizardPage.getSelectedElementsWithoutContainedChildren());
        if (!this.executeExportOperation(this.fJarPackage.createJarExportRunnable(this.getShell()))) {
            return false;
        }
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = JavaPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            IWizardPage page = pages[i];
            if (page instanceof IJarPackageWizardPage) {
                ((IJarPackageWizardPage)page).finish();
            }
            ++i;
        }
        return true;
    }

    protected boolean executeExportOperation(IJarExportRunnable op) {
        block4: {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block4;
                ExceptionHandler.handle(ex, this.getShell(), JarPackagerMessages.getString("JarPackageWizard.jarExportError.title"), JarPackagerMessages.getString("JarPackageWizard.jarExportError.message"));
                return false;
            }
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ProblemDialog.open(this.getShell(), JarPackagerMessages.getString("JarPackageWizard.jarExport.title"), null, status);
            return !status.matches(4);
        }
        return true;
    }

    protected IStructuredSelection getValidSelection() {
        ISelection currentSelection = JavaPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            ArrayList selectedElements = new ArrayList(structuredSelection.size());
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                Object selectedElement = iter.next();
                if (selectedElement instanceof IProject) {
                    this.addProject(selectedElements, (IProject)selectedElement);
                    continue;
                }
                if (selectedElement instanceof IResource) {
                    this.addResource(selectedElements, (IResource)selectedElement);
                    continue;
                }
                if (!(selectedElement instanceof IJavaElement)) continue;
                this.addJavaElement(selectedElements, (IJavaElement)selectedElement);
            }
            return new StructuredSelection(selectedElements);
        }
        return StructuredSelection.EMPTY;
    }

    private void addResource(List selectedElements, IResource resource) {
        IJavaElement je = JavaCore.create((IResource)resource);
        if (je != null && je.exists() && je.getElementType() == 5) {
            selectedElements.add(je);
        } else {
            selectedElements.add(resource);
        }
    }

    private void addProject(List selectedElements, IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                selectedElements.add(JavaCore.create((IProject)project));
            }
        }
        catch (CoreException coreException) {}
    }

    private void addJavaElement(List selectedElements, IJavaElement je) {
        if (je.getElementType() == 5) {
            selectedElements.add(je);
        } else if (je.getElementType() == 6) {
            selectedElements.add(je);
        } else if (je.getElementType() == 2) {
            selectedElements.add(je);
        } else if (je.getElementType() == 4) {
            if (!JavaModelUtil.getPackageFragmentRoot(je).isArchive()) {
                selectedElements.add(je);
            }
        } else if (je.getElementType() == 3) {
            if (!((IPackageFragmentRoot)je).isArchive()) {
                selectedElements.add(je);
            }
        } else {
            IOpenable openable = je.getOpenable();
            if (openable instanceof ICompilationUnit) {
                selectedElements.add(JavaModelUtil.toOriginal((ICompilationUnit)openable));
            } else if (openable instanceof IClassFile && !JavaModelUtil.getPackageFragmentRoot(je).isArchive()) {
                selectedElements.add(openable);
            }
        }
    }

    boolean isInitializingFromJarPackage() {
        return this.fInitializeFromJarPackage;
    }

    void setInitializeFromJarPackage(boolean state) {
        this.fInitializeFromJarPackage = state;
    }
}

