/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.jdt.internal.ui.search.PrettySignature;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchParticipantRecord;
import org.eclipse.jdt.internal.ui.search.SearchParticipantsExtensionPoint;
import org.eclipse.jdt.internal.ui.search.SearchResultUpdater;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class JavaSearchQuery
implements ISearchQuery {
    private ISearchResult fResult;
    private QuerySpecification fPatternData;

    public JavaSearchQuery(QuerySpecification data) {
        this.fPatternData = data;
    }

    public IStatus run(IProgressMonitor monitor) {
        JavaSearchResult textResult = (JavaSearchResult)this.getSearchResult();
        textResult.removeAll();
        SearchEngine engine = new SearchEngine();
        try {
            SearchPattern pattern;
            int totalTicks = 1000;
            IProject[] projects = JavaSearchScopeFactory.getInstance().getProjects(this.fPatternData.getScope());
            final SearchParticipantRecord[] participantDescriptors = SearchParticipantsExtensionPoint.getInstance().getSearchParticipants(projects);
            final int[] ticks = new int[participantDescriptors.length];
            int i = 0;
            while (i < participantDescriptors.length) {
                final int iPrime = i;
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        ticks[iPrime] = 0;
                        String message = SearchMessages.getString("JavaSearchQuery.error.participant.estimate");
                        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        ticks[iPrime] = participantDescriptors[iPrime].getParticipant().estimateTicks(JavaSearchQuery.this.fPatternData);
                    }
                };
                Platform.run((ISafeRunnable)runnable);
                totalTicks += ticks[i];
                ++i;
            }
            monitor.beginTask(SearchMessages.getString("JavaSearchQuery.task.label"), totalTicks);
            SubProgressMonitor mainSearchPM = new SubProgressMonitor(monitor, 1000);
            boolean ignorePotentials = SearchPreferencePage.arePotentialMatchesIgnored();
            NewSearchResultCollector collector = new NewSearchResultCollector(textResult, ignorePotentials);
            String stringPattern = null;
            if (this.fPatternData instanceof ElementQuerySpecification) {
                pattern = SearchPattern.createPattern((IJavaElement)((ElementQuerySpecification)this.fPatternData).getElement(), (int)this.fPatternData.getLimitTo());
                stringPattern = ((ElementQuerySpecification)this.fPatternData).getElement().getElementName();
            } else {
                int matchMode;
                PatternQuerySpecification patternSpec = (PatternQuerySpecification)this.fPatternData;
                stringPattern = patternSpec.getPattern();
                int n = matchMode = stringPattern.indexOf(42) != -1 || stringPattern.indexOf(63) != -1 ? 2 : 0;
                if (patternSpec.isCaseSensitive()) {
                    matchMode |= 8;
                }
                pattern = SearchPattern.createPattern((String)patternSpec.getPattern(), (int)patternSpec.getSearchFor(), (int)patternSpec.getLimitTo(), (int)matchMode);
            }
            if (pattern == null) {
                return new Status(4, JavaPlugin.getPluginId(), 0, SearchMessages.getFormattedString("JavaSearchQuery.error.unsupported_pattern", stringPattern), null);
            }
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.fPatternData.getScope(), (org.eclipse.jdt.core.search.SearchRequestor)collector, (IProgressMonitor)mainSearchPM);
            int i2 = 0;
            while (i2 < participantDescriptors.length) {
                final SearchRequestor requestor = new SearchRequestor(participantDescriptors[i2].getParticipant(), textResult);
                SubProgressMonitor participantPM = new SubProgressMonitor(monitor, ticks[i2]);
                final int iPrime = i2++;
                ISafeRunnable runnable = new ISafeRunnable((IProgressMonitor)participantPM){
                    private final /* synthetic */ IProgressMonitor val$participantPM;
                    {
                        this.val$participantPM = iProgressMonitor;
                    }

                    public void handleException(Throwable exception) {
                        participantDescriptors[iPrime].getDescriptor().disable();
                        String message = SearchMessages.getString("JavaSearchQuery.error.participant.search");
                        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        participantDescriptors[iPrime].getParticipant().search(requestor, JavaSearchQuery.this.fPatternData, this.val$participantPM);
                    }
                };
                Platform.run((ISafeRunnable)runnable);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        String message = SearchMessages.getString("JavaSearchQuery.status.ok.message");
        MessageFormat.format(message, new Integer(textResult.getMatchCount()));
        return new Status(0, JavaPlugin.getPluginId(), 0, message, null);
    }

    public String getLabel() {
        return SearchMessages.getString("JavaSearchQuery.label");
    }

    String getSingularLabel() {
        String desc = null;
        desc = this.getSearchPattern();
        desc = JavaSearchQuery.quote(desc);
        desc = "\"" + desc + "\"";
        Object[] args = new String[]{desc, this.fPatternData.getScopeDescription()};
        switch (this.fPatternData.getLimitTo()) {
            case 1: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularImplementorsPostfix", args);
            }
            case 0: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularDeclarationsPostfix", args);
            }
            case 2: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularReferencesPostfix", args);
            }
            case 3: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularOccurrencesPostfix", args);
            }
            case 4: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularReadReferencesPostfix", args);
            }
            case 5: {
                return SearchMessages.getFormattedString("JavaSearchOperation.singularWriteReferencesPostfix", args);
            }
        }
        return SearchMessages.getFormattedString("JavaSearchOperation.singularOccurrencesPostfix", args);
    }

    private String getSearchPattern() {
        String desc;
        if (this.fPatternData instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)this.fPatternData).getElement();
            desc = this.fPatternData.getLimitTo() == 2 && element.getElementType() == 9 ? PrettySignature.getUnqualifiedMethodSignature((IMethod)element) : element.getElementName();
            if ("".equals(desc) && element.getElementType() == 4) {
                desc = SearchMessages.getString("JavaSearchOperation.default_package");
            }
        } else {
            desc = ((PatternQuerySpecification)this.fPatternData).getPattern();
        }
        return desc;
    }

    public static String quote(String searchString) {
        searchString = searchString.replaceAll("\\{", "'{'");
        return searchString.replaceAll("\\}", "'}'");
    }

    String getPluralLabelPattern() {
        String desc = null;
        if (this.fPatternData instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)this.fPatternData).getElement();
            desc = this.fPatternData.getLimitTo() == 2 && element.getElementType() == 9 ? PrettySignature.getUnqualifiedMethodSignature((IMethod)element) : element.getElementName();
            if ("".equals(desc) && element.getElementType() == 4) {
                desc = SearchMessages.getString("JavaSearchOperation.default_package");
            }
        } else {
            desc = ((PatternQuerySpecification)this.fPatternData).getPattern();
        }
        desc = JavaSearchQuery.quote(desc);
        desc = "\"" + desc + "\"";
        Object[] args = new String[]{desc, "{0}", this.fPatternData.getScopeDescription()};
        switch (this.fPatternData.getLimitTo()) {
            case 1: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralImplementorsPostfix", args);
            }
            case 0: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralDeclarationsPostfix", args);
            }
            case 2: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralReferencesPostfix", args);
            }
            case 3: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralOccurrencesPostfix", args);
            }
            case 4: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralReadReferencesPostfix", args);
            }
            case 5: {
                return SearchMessages.getFormattedString("JavaSearchOperation.pluralWriteReferencesPostfix", args);
            }
        }
        return SearchMessages.getFormattedString("JavaSearchOperation.pluralOccurrencesPostfix", args);
    }

    ImageDescriptor getImageDescriptor() {
        if (this.fPatternData.getLimitTo() == 1 || this.fPatternData.getLimitTo() == 0) {
            return JavaPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new JavaSearchResult(this);
            new SearchResultUpdater((JavaSearchResult)this.fResult);
        }
        return this.fResult;
    }

    QuerySpecification getSpecification() {
        return this.fPatternData;
    }

    private static class SearchRequestor
    implements ISearchRequestor {
        private IQueryParticipant fParticipant;
        private JavaSearchResult fSearchResult;

        public void reportMatch(Match match) {
            IMatchPresentation participant = this.fParticipant.getUIParticipant();
            if (participant == null || match.getElement() instanceof IJavaElement || match.getElement() instanceof IResource) {
                this.fSearchResult.addMatch(match);
            } else {
                this.fSearchResult.addMatch(match, participant);
            }
        }

        protected SearchRequestor(IQueryParticipant participant, JavaSearchResult result) {
            this.fParticipant = participant;
            this.fSearchResult = result;
        }
    }
}

