/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchResult;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class OccurrencesSearchQuery
implements ISearchQuery {
    private OccurrencesSearchResult fResult;
    private IOccurrencesFinder fFinder;
    private IDocument fDocument;
    private IJavaElement fElement;
    private String fSingularLabel;
    private String fPluralLabelPattern;
    private String fJobLabel;

    public OccurrencesSearchQuery(IOccurrencesFinder finder, IDocument document, IJavaElement element) {
        this.fFinder = finder;
        this.fDocument = document;
        this.fElement = element;
        this.fSingularLabel = this.fFinder.getSingularLabel(element.getElementName());
        this.fPluralLabelPattern = this.fFinder.getPluralLabelPattern(element.getElementName());
        this.fJobLabel = this.fFinder.getJobLabel();
    }

    public IStatus run(IProgressMonitor monitor) {
        this.fFinder.perform();
        Match[] matches = this.fFinder.getOccurrenceMatches(this.fElement, this.fDocument);
        this.fResult.addMatches(matches);
        this.fFinder = null;
        this.fDocument = null;
        monitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return this.fJobLabel;
    }

    String getSingularLabel() {
        return this.fSingularLabel;
    }

    String getPluralLabelPattern() {
        return this.fPluralLabelPattern;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new OccurrencesSearchResult(this);
        }
        return this.fResult;
    }
}

