/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.ChangeTypeWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ChangeTypeAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private String fDialogMessageTitle;

    public ChangeTypeAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public ChangeTypeAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("ChangeTypeAction.label"));
        this.setToolTipText(RefactoringMessages.getString("ChangeTypeAction.tooltipText"));
        this.setDescription(RefactoringMessages.getString("ChangeTypeAction.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.change_type_action");
        this.fDialogMessageTitle = RefactoringMessages.getString("ChangeTypeAction.dialog.title");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.getMember(selection) != null);
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            TextSelection textSelection;
            IMember member = this.getMember(selection);
            if (member == null) {
                return;
            }
            ISourceRange range = member.getNameRange();
            ICompilationUnit icu = member.getCompilationUnit();
            ChangeTypeRefactoring refactoring = ChangeTypeAction.createRefactoring(icu, (ITextSelection)(textSelection = new TextSelection(range.getOffset(), range.getLength())));
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), this.fDialogMessageTitle, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.fDialogMessageTitle, RefactoringMessages.getString("ChangeTypeAction.exception"));
        }
    }

    private IMember getMember(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IMember)) {
            return null;
        }
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            String returnType = method.getReturnType();
            if (PrimitiveType.toCode((String)Signature.toString((String)returnType)) != null) {
                return null;
            }
            return method;
        }
        if (element instanceof IField) {
            return (IField)element;
        }
        return null;
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(ITextSelection selection) {
        return this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null;
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return ChangeTypeRefactoring.isAvailable(elements[0]);
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            ChangeTypeRefactoring refactoring = ChangeTypeAction.createRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection);
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), this.fDialogMessageTitle, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.fDialogMessageTitle, RefactoringMessages.getString("ChangeTypeAction.exception"));
        }
    }

    private static ChangeTypeRefactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return ChangeTypeRefactoring.create(cunit, selection.getOffset(), selection.getLength());
    }

    private RefactoringWizard createWizard(ChangeTypeRefactoring refactoring) {
        return new ChangeTypeWizard(refactoring);
    }
}

