/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class GenerateNewConstructorUsingFieldsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.title");
    private static final int UP_INDEX = 0;
    private static final int DOWN_INDEX = 1;
    static /* synthetic */ Class class$0;

    public GenerateNewConstructorUsingFieldsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("GenerateConstructorUsingFieldsAction.label"));
        this.setDescription(ActionMessages.getString("GenerateConstructorUsingFieldsAction.description"));
        this.setToolTipText(ActionMessages.getString("GenerateConstructorUsingFieldsAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.create_new_constructor_action_context");
    }

    public GenerateNewConstructorUsingFieldsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    private static String getDialogTitle() {
        return DIALOG_TITLE;
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && type.isClass() && !type.isLocal();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    public void run(IStructuredSelection selection) {
        try {
            IType selectionType = this.getSelectedType(selection);
            if (selectionType == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)GenerateNewConstructorUsingFieldsAction.getDialogTitle(), (String)ActionMessages.getString("GenerateConstructorUsingFieldsAction.not_applicable"));
                return;
            }
            IField[] selectedFields = this.getSelectedFields(selection);
            if (GenerateNewConstructorUsingFieldsAction.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)firstElement).findPrimaryType();
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)GenerateNewConstructorUsingFieldsAction.getDialogTitle(), (String)ActionMessages.getString("GenerateConstructorUsingFieldsAction.interface_not_applicable"));
                    return;
                }
                this.run(((ICompilationUnit)firstElement).findPrimaryType(), new IField[0], false);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), GenerateNewConstructorUsingFieldsAction.getDialogTitle(), ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.actionfailed"));
        }
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type = (IType)elements[0];
            if (type.getCompilationUnit() != null && type.isClass()) {
                return type;
            }
        } else if (elements[0] instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)elements[0];
            IType type = cu.findPrimaryType();
            if (type != null && !type.isInterface()) {
                return type;
            }
        } else if (elements[0] instanceof IField) {
            return ((IField)elements[0]).getCompilationUnit().findPrimaryType();
        }
        return null;
    }

    private static boolean canRunOn(IField[] fields) {
        return fields != null && fields.length > 0;
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IField[] res = new IField[nElements];
            ICompilationUnit cu = null;
            int i = 0;
            while (i < nElements) {
                IField fld;
                block7: {
                    Object curr = elements.get(i);
                    if (curr instanceof IField) {
                        fld = (IField)curr;
                        if (i == 0 ? (cu = fld.getCompilationUnit()) == null : !cu.equals(fld.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            if (fld.getDeclaringType().isInterface()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            return null;
                        }
                    }
                    return null;
                }
                res[i] = fld;
                ++i;
            }
            return res;
        }
        return null;
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            IType type;
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, false);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)GenerateNewConstructorUsingFieldsAction.getDialogTitle(), (String)ActionMessages.getString("GenerateConstructorUsingFieldsAction.not_applicable"));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), GenerateNewConstructorUsingFieldsAction.getDialogTitle(), ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.actionfailed"));
        }
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    /*
     * Exception decompiling
     */
    private void run(IType type, IField[] preselected, boolean activatedFromEditor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [6 : 749->753)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IMethod[] getSuperConstructors(IType type) throws CoreException {
        ArrayList<IMethod> constructorMethods = new ArrayList<IMethod>();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType supertype = hierarchy.getSuperclass(type);
        if (supertype != null) {
            IMethod curr;
            IMethod[] superMethods = supertype.getMethods();
            boolean constuctorFound = false;
            int i = 0;
            while (i < superMethods.length) {
                curr = superMethods[i];
                if (curr.isConstructor()) {
                    constuctorFound = true;
                    if (JavaModelUtil.isVisibleInHierarchy((IMember)curr, type.getPackageFragment())) {
                        constructorMethods.add(curr);
                    }
                }
                ++i;
            }
            if (!constuctorFound) {
                IType objectType = type.getJavaProject().findType("java.lang.Object");
                curr = objectType.getMethod("Object", new String[0]);
                constructorMethods.add(curr);
            }
        }
        return constructorMethods.toArray(new IMethod[constructorMethods.size()]);
    }

    private static ISelectionStatusValidator createValidator(int entries, GenerateConstructorUsingFieldsSelectionDialog dialog, IType type) {
        GenerateConstructorUsingFieldsValidator validator = new GenerateConstructorUsingFieldsValidator(entries, dialog, type);
        return validator;
    }

    private static class GenerateConstructorUsingFieldsValidator
    implements ISelectionStatusValidator {
        private static int fEntries;
        private IType fType;
        private GenerateConstructorUsingFieldsSelectionDialog fDialog;
        List fExistingSigs;

        GenerateConstructorUsingFieldsValidator(int entries) {
            fEntries = entries;
            this.fType = null;
        }

        GenerateConstructorUsingFieldsValidator(int entries, GenerateConstructorUsingFieldsSelectionDialog dialog, IType type) {
            fEntries = entries;
            this.fDialog = dialog;
            this.fType = type;
            this.fExistingSigs = this.getExistingConstructorSignatures();
        }

        public IStatus validate(Object[] selection) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            IMethod chosenSuper = this.fDialog.getSuperConstructorChoice();
            try {
                String[] superParamTypes = chosenSuper.getParameterTypes();
                int i = 0;
                while (i < superParamTypes.length) {
                    buffer.append(superParamTypes[i]);
                    ++i;
                }
                i = 0;
                while (i < selection.length) {
                    if (selection[i] instanceof IField) {
                        buffer.append(((IField)selection[i]).getTypeSignature());
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            buffer.append(")V");
            if (this.fExistingSigs.contains(buffer.toString())) {
                return new StatusInfo(2, ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.duplicate_constructor"));
            }
            int fieldCount = this.countSelectedFields(selection);
            String message = ActionMessages.getFormattedString("GenerateConstructorUsingFieldsAction.fields_selected", new Object[]{String.valueOf(fieldCount), String.valueOf(fEntries)});
            return new StatusInfo(1, message);
        }

        private int countSelectedFields(Object[] selection) {
            int count = 0;
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IField) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        private List getExistingConstructorSignatures() {
            ArrayList<String> constructorMethods = new ArrayList<String>();
            try {
                IMethod[] methods = this.fType.getMethods();
                int i = 0;
                while (i < methods.length) {
                    IMethod curr = methods[i];
                    if (curr.isConstructor()) {
                        constructorMethods.add(curr.getSignature());
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            return constructorMethods;
        }
    }

    private static class GenerateConstructorUsingFieldsSelectionDialog
    extends SourceActionDialog {
        private GenerateConstructorUsingFieldsContentProvider fContentProvider;
        private int fSuperIndex;
        private int fWidth = 60;
        private int fHeight = 18;
        protected Button[] fButtonControls;
        private boolean[] fButtonsEnabled;
        private boolean fOmitSuper;
        private IMethod[] fSuperConstructors;
        private IDialogSettings fGenConstructorSettings;
        protected CheckboxTreeViewer fTreeViewer;
        private GenerateConstructorUsingFieldsTreeViewerAdapter fTreeViewerAdapter;
        private static final int UP_BUTTON = 1025;
        private static final int DOWN_BUTTON = 1026;
        private final String SETTINGS_SECTION = "GenerateConstructorUsingFieldsSelectionDialog";
        private final String OMIT_SUPER = "OmitCallToSuper";
        private Button fOmitSuperButton;

        public GenerateConstructorUsingFieldsSelectionDialog(Shell parent, ILabelProvider labelProvider, GenerateConstructorUsingFieldsContentProvider contentProvider, CompilationUnitEditor editor, IType type, IMethod[] superConstructors) throws JavaModelException {
            super(parent, labelProvider, contentProvider, editor, type, true);
            this.fContentProvider = contentProvider;
            this.fTreeViewerAdapter = new GenerateConstructorUsingFieldsTreeViewerAdapter();
            this.fSuperConstructors = superConstructors;
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fGenConstructorSettings = dialogSettings.getSection("GenerateConstructorUsingFieldsSelectionDialog");
            if (this.fGenConstructorSettings == null) {
                this.fGenConstructorSettings = dialogSettings.addNewSection("GenerateConstructorUsingFieldsSelectionDialog");
                this.fGenConstructorSettings.put("OmitCallToSuper", false);
            }
            this.fOmitSuper = this.fGenConstructorSettings.getBoolean("OmitCallToSuper");
        }

        protected Composite createVisibilityControlAndModifiers(Composite parent, IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
            Composite visibilityComposite = this.createVisibilityControl(parent, visibilityChangeListener, availableVisibilities, correctVisibility);
            return visibilityComposite;
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData gd = null;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            Composite classConstructorComposite = this.addSuperClassConstructorChoices(composite);
            gd = new GridData(1808);
            classConstructorComposite.setLayoutData((Object)gd);
            Composite inner = new Composite(composite, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 2;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            inner.setLayout((Layout)innerLayout);
            Label messageLabel = this.createMessageArea(inner);
            if (messageLabel != null) {
                gd = new GridData(256);
                gd.horizontalSpan = 2;
                messageLabel.setLayoutData((Object)gd);
            }
            this.fTreeViewer = this.createTreeViewer(inner);
            gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
            gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
            this.fTreeViewer.getControl().setLayoutData((Object)gd);
            this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.fTreeViewerAdapter);
            Composite buttonComposite = this.createSelectionButtons(inner);
            gd = new GridData(272);
            buttonComposite.setLayoutData((Object)gd);
            gd = new GridData(1808);
            inner.setLayoutData((Object)gd);
            Composite entryComposite = this.createEntryPtCombo(composite);
            entryComposite.setLayoutData((Object)new GridData(768));
            Composite commentComposite = this.createCommentSelection(composite);
            commentComposite.setLayoutData((Object)new GridData(768));
            Composite overrideSuperComposite = this.createOmitSuper(composite);
            overrideSuperComposite.setLayoutData((Object)new GridData(768));
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected Composite createOmitSuper(Composite composite) {
            Composite omitSuperComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            omitSuperComposite.setLayout((Layout)layout);
            this.fOmitSuperButton = new Button(omitSuperComposite, 32);
            this.fOmitSuperButton.setText(ActionMessages.getString("GenerateConstructorUsingFieldsSelectionDialog.omit.super"));
            this.fOmitSuperButton.setLayoutData((Object)new GridData(256));
            this.fOmitSuperButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ GenerateConstructorUsingFieldsSelectionDialog this$1;
                {
                    this.this$1 = generateConstructorUsingFieldsSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    this.this$1.setOmitSuper(isSelected);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fOmitSuperButton.setSelection(this.isOmitSuper());
            this.fOmitSuperButton.setEnabled(this.getSuperConstructorChoice().getNumberOfParameters() == 0);
            GridData gd = new GridData(256);
            gd.horizontalSpan = 2;
            this.fOmitSuperButton.setLayoutData((Object)gd);
            return omitSuperComposite;
        }

        protected Composite createSelectionButtons(Composite composite) {
            Composite buttonComposite = super.createSelectionButtons(composite);
            GridLayout layout = new GridLayout();
            buttonComposite.setLayout((Layout)layout);
            this.createUpDownButtons(buttonComposite);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            return buttonComposite;
        }

        private void createUpDownButtons(Composite buttonComposite) {
            int numButtons = 2;
            this.fButtonControls = new Button[numButtons];
            this.fButtonsEnabled = new boolean[numButtons];
            this.fButtonControls[0] = this.createButton(buttonComposite, 1025, ActionMessages.getString("GenerateConstructorUsingFieldsSelectionDialog.up_button"), false);
            this.fButtonControls[1] = this.createButton(buttonComposite, 1026, ActionMessages.getString("GenerateConstructorUsingFieldsSelectionDialog.down_button"), false);
            boolean defaultState = false;
            this.fButtonControls[0].setEnabled(defaultState);
            this.fButtonControls[1].setEnabled(defaultState);
            this.fButtonsEnabled[0] = defaultState;
            this.fButtonsEnabled[1] = defaultState;
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            switch (buttonId) {
                case 1025: {
                    this.fContentProvider.up(this.getElementList(), this.getTreeViewer());
                    this.updateOKStatus();
                    break;
                }
                case 1026: {
                    this.fContentProvider.down(this.getElementList(), this.getTreeViewer());
                    this.updateOKStatus();
                }
            }
        }

        private List getElementList() {
            IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
            List elements = selection.toList();
            ArrayList elementList = new ArrayList();
            int i = 0;
            while (i < elements.size()) {
                elementList.add(elements.get(i));
                ++i;
            }
            return elementList;
        }

        protected Composite createEntryPtCombo(Composite composite) {
            Composite entryComposite = super.createEntryPtCombo(composite);
            this.addVisibilityAndModifiersChoices(entryComposite);
            return entryComposite;
        }

        private Composite addSuperClassConstructorChoices(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(ActionMessages.getString("GenerateConstructorUsingFieldsSelectionDialog.sort_constructor_choices.label"));
            GridData gd = new GridData(768);
            label.setLayoutData((Object)gd);
            Combo combo = new Combo(composite, 8);
            int i = 0;
            while (i < this.fSuperConstructors.length) {
                combo.add(JavaElementLabels.getElementLabel((IJavaElement)this.fSuperConstructors[i], 1));
                ++i;
            }
            combo.setText(combo.getItem(0));
            combo.setLayoutData((Object)new GridData(768));
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, combo){
                final /* synthetic */ GenerateConstructorUsingFieldsSelectionDialog this$1;
                private final /* synthetic */ Combo val$combo;
                {
                    this.this$1 = generateConstructorUsingFieldsSelectionDialog;
                    this.val$combo = combo;
                }

                public void widgetSelected(SelectionEvent e) {
                    GenerateConstructorUsingFieldsSelectionDialog.access$1(this.this$1, this.val$combo.getSelectionIndex());
                    GenerateConstructorUsingFieldsSelectionDialog.access$2(this.this$1).setEnabled(this.this$1.getSuperConstructorChoice().getNumberOfParameters() == 0);
                    GenerateConstructorUsingFieldsSelectionDialog.access$3(this.this$1);
                }
            });
            return composite;
        }

        public CheckboxTreeViewer getTreeViewer() {
            return this.fTreeViewer;
        }

        public IMethod getSuperConstructorChoice() {
            return this.fSuperConstructors[this.fSuperIndex];
        }

        public void setOmitSuper(boolean omitSuper) {
            if (this.fOmitSuper != omitSuper) {
                this.fOmitSuper = omitSuper;
                this.fGenConstructorSettings.put("OmitCallToSuper", omitSuper);
            }
        }

        public boolean isOmitSuper() {
            return this.fOmitSuper;
        }

        static /* synthetic */ void access$1(GenerateConstructorUsingFieldsSelectionDialog generateConstructorUsingFieldsSelectionDialog, int n) {
            generateConstructorUsingFieldsSelectionDialog.fSuperIndex = n;
        }

        static /* synthetic */ Button access$2(GenerateConstructorUsingFieldsSelectionDialog generateConstructorUsingFieldsSelectionDialog) {
            return generateConstructorUsingFieldsSelectionDialog.fOmitSuperButton;
        }

        static /* synthetic */ void access$3(GenerateConstructorUsingFieldsSelectionDialog generateConstructorUsingFieldsSelectionDialog) {
            generateConstructorUsingFieldsSelectionDialog.updateOKStatus();
        }

        private class GenerateConstructorUsingFieldsTreeViewerAdapter
        implements ISelectionChangedListener,
        IDoubleClickListener {
            GenerateConstructorUsingFieldsTreeViewerAdapter() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)GenerateConstructorUsingFieldsSelectionDialog.this.fTreeViewer.getSelection();
                List selectedList = selection.toList();
                GenerateConstructorUsingFieldsContentProvider cp = (GenerateConstructorUsingFieldsContentProvider)GenerateConstructorUsingFieldsSelectionDialog.this.getContentProvider();
                GenerateConstructorUsingFieldsSelectionDialog.this.fButtonControls[0].setEnabled(cp.canMoveUp(selectedList));
                GenerateConstructorUsingFieldsSelectionDialog.this.fButtonControls[1].setEnabled(cp.canMoveDown(selectedList));
            }

            public void doubleClick(DoubleClickEvent event) {
            }
        }
    }

    private static class GenerateConstructorUsingFieldsContentProvider
    implements ITreeContentProvider {
        private List fFieldsList;
        private static final Object[] EMPTY = new Object[0];

        public GenerateConstructorUsingFieldsContentProvider(List fieldList) {
            this.fFieldsList = fieldList;
        }

        public Object[] getChildren(Object parentElement) {
            return EMPTY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fFieldsList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private List moveUp(List elements, List move) {
            int nElements = elements.size();
            ArrayList res = new ArrayList(nElements);
            Object floating = null;
            int i = 0;
            while (i < nElements) {
                Object curr = elements.get(i);
                if (move.contains(curr)) {
                    res.add(curr);
                } else {
                    if (floating != null) {
                        res.add(floating);
                    }
                    floating = curr;
                }
                ++i;
            }
            if (floating != null) {
                res.add(floating);
            }
            return res;
        }

        private List reverse(List p) {
            ArrayList reverse = new ArrayList(p.size());
            int i = p.size() - 1;
            while (i >= 0) {
                reverse.add(p.get(i));
                --i;
            }
            return reverse;
        }

        public void setElements(List elements, CheckboxTreeViewer tree) {
            this.fFieldsList = new ArrayList(elements);
            if (tree != null) {
                tree.refresh();
            }
        }

        public void up(List checkedElements, CheckboxTreeViewer tree) {
            if (checkedElements.size() > 0) {
                this.setElements(this.moveUp(this.fFieldsList, checkedElements), tree);
                tree.reveal(checkedElements.get(0));
            }
            tree.setSelection((ISelection)new StructuredSelection(checkedElements));
        }

        public void down(List checkedElements, CheckboxTreeViewer tree) {
            if (checkedElements.size() > 0) {
                this.setElements(this.reverse(this.moveUp(this.reverse(this.fFieldsList), checkedElements)), tree);
                tree.reveal(checkedElements.get(checkedElements.size() - 1));
            }
            tree.setSelection((ISelection)new StructuredSelection(checkedElements));
        }

        public boolean canMoveUp(List selectedElements) {
            int nSelected = selectedElements.size();
            int nElements = this.fFieldsList.size();
            int i = 0;
            while (i < nElements && nSelected > 0) {
                if (!selectedElements.contains(this.fFieldsList.get(i))) {
                    return true;
                }
                --nSelected;
                ++i;
            }
            return false;
        }

        public boolean canMoveDown(List selectedElements) {
            int nSelected = selectedElements.size();
            int i = this.fFieldsList.size() - 1;
            while (i >= 0 && nSelected > 0) {
                if (!selectedElements.contains(this.fFieldsList.get(i))) {
                    return true;
                }
                --nSelected;
                --i;
            }
            return false;
        }

        public List getFieldsList() {
            return this.fFieldsList;
        }
    }
}

