/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.jarpackager;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;

public class JarWriter {
    private JarOutputStream fJarOutputStream;
    private JarPackageData fJarPackage;

    public JarWriter(JarPackageData jarPackage, Shell parent) throws CoreException {
        Assert.isNotNull((Object)jarPackage, (String)"The JAR specification is null");
        this.fJarPackage = jarPackage;
        Assert.isTrue((boolean)this.fJarPackage.isValid(), (String)"The JAR package specification is invalid");
        if (!this.canCreateJar(parent)) {
            throw new OperationCanceledException();
        }
        try {
            if (this.fJarPackage.usesManifest() && this.fJarPackage.areGeneratedFilesExported()) {
                Manifest manifest = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
                this.fJarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toOSString()), manifest);
            } else {
                this.fJarOutputStream = new JarOutputStream(new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toOSString()));
            }
            String comment = jarPackage.getComment();
            if (comment != null) {
                this.fJarOutputStream.setComment(comment);
            }
        }
        catch (IOException ex) {
            throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    public void close() throws CoreException {
        if (this.fJarOutputStream != null) {
            try {
                this.fJarOutputStream.close();
                this.registerInWorkspaceIfNeeded();
            }
            catch (IOException ex) {
                throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(IFile resource, IPath destinationPath) throws CoreException {
        ByteArrayOutputStream output = null;
        BufferedInputStream contentStream = null;
        try {
            try {
                int count;
                output = new ByteArrayOutputStream();
                if (!resource.isLocal(0)) {
                    String message = JarPackagerMessages.getFormattedString("JarWriter.error.fileNotAccessible", resource.getFullPath());
                    throw JarPackagerUtil.createCoreException(message, null);
                }
                contentStream = new BufferedInputStream(resource.getContents(false));
                int chunkSize = 4096;
                byte[] readBuffer = new byte[chunkSize];
                while ((count = contentStream.read(readBuffer, 0, chunkSize)) != -1) {
                    output.write(readBuffer, 0, count);
                }
            }
            catch (IOException ex) {
                throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            try {
                if (output != null) {
                    output.close();
                }
                if (contentStream == null) throw throwable;
                contentStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
        {
            Object var8_14 = null;
        }
        try {}
        catch (IOException ex) {
            throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
        if (output != null) {
            output.close();
        }
        if (contentStream != null) {
            contentStream.close();
        }
        {
            File file;
            IPath fileLocation = resource.getLocation();
            long lastModified = System.currentTimeMillis();
            if (fileLocation != null && (file = new File(fileLocation.toOSString())).exists()) {
                lastModified = file.lastModified();
            }
            this.write(destinationPath, output.toByteArray(), lastModified);
            return;
        }
    }

    protected void write(IPath path, byte[] contents, long lastModified) throws IOException {
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        if (this.fJarPackage.isCompressed()) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            newEntry.setSize(contents.length);
            CRC32 checksumCalculator = new CRC32();
            checksumCalculator.update(contents);
            newEntry.setCrc(checksumCalculator.getValue());
        }
        newEntry.setTime(lastModified);
        this.fJarOutputStream.putNextEntry(newEntry);
        this.fJarOutputStream.write(contents);
    }

    protected boolean canCreateJar(Shell parent) {
        File file = this.fJarPackage.getAbsoluteJarLocation().toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fJarPackage.allowOverwrite()) {
                return true;
            }
            return parent != null && JarPackagerUtil.askForOverwritePermission(parent, this.fJarPackage.getAbsoluteJarLocation().toOSString());
        }
        String path = file.getAbsolutePath();
        int separatorIndex = path.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        File directory = new File(path.substring(0, separatorIndex));
        if (!directory.exists()) {
            if (JarPackagerUtil.askToCreateDirectory(parent, directory)) {
                return directory.mkdirs();
            }
            return false;
        }
        return true;
    }

    private void registerInWorkspaceIfNeeded() {
        IPath jarPath = this.fJarPackage.getAbsoluteJarLocation();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            boolean isInProject;
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            boolean bl = isInProject = projectLocation != null && projectLocation.isPrefixOf(jarPath);
            if (isInProject) {
                try {
                    jarPath = jarPath.removeFirstSegments(projectLocation.segmentCount());
                    jarPath = jarPath.removeLastSegments(1);
                    IResource containingFolder = project.findMember(jarPath);
                    if (containingFolder != null && containingFolder.isAccessible()) {
                        containingFolder.refreshLocal(1, null);
                    }
                }
                catch (CoreException ex) {
                    JavaPlugin.log(ex);
                }
            }
            ++i;
        }
    }
}

