/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.IInternalPerspectiveListener;

public class PerspectiveListenerList {
    private ListenerList listeners = new ListenerList();

    public void addPerspectiveListener(IInternalPerspectiveListener l) {
        this.listeners.add((Object)l);
    }

    public void firePerspectiveActivated(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IInternalPerspectiveListener l = (IInternalPerspectiveListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.perspectiveActivated(page, perspective);
                }
            });
            ++nX;
        }
    }

    public void firePerspectiveChanged(final IWorkbenchPage page, final IPerspectiveDescriptor perspective, final String changeId) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IInternalPerspectiveListener l = (IInternalPerspectiveListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.perspectiveChanged(page, perspective, changeId);
                }
            });
            ++nX;
        }
    }

    public void firePerspectiveClosed(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IInternalPerspectiveListener l = (IInternalPerspectiveListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.perspectiveClosed(page, perspective);
                }
            });
            ++nX;
        }
    }

    public void firePerspectiveOpened(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] array = this.listeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IInternalPerspectiveListener l = (IInternalPerspectiveListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.perspectiveOpened(page, perspective);
                }
            });
            ++nX;
        }
    }

    public void removePerspectiveListener(IInternalPerspectiveListener l) {
        this.listeners.remove((Object)l);
    }
}

