/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;

public class PlaceholderFolderLayout
implements IPlaceholderFolderLayout {
    private PageLayout pageLayout;
    private ContainerPlaceholder placeholder;

    public PlaceholderFolderLayout(PageLayout pageLayout, ContainerPlaceholder folder) {
        this.placeholder = folder;
        this.pageLayout = pageLayout;
    }

    public void addPlaceholder(String viewId) {
        if (this.pageLayout.checkPartInLayout(viewId)) {
            return;
        }
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewDescriptor desc = reg.find(viewId);
        if (desc == null) {
            WorkbenchPlugin.log("Unable to find view label: " + viewId);
            return;
        }
        PartPlaceholder newPart = new PartPlaceholder(viewId);
        this.linkPartToPageLayout(viewId, newPart);
        this.placeholder.add(newPart);
    }

    private void linkPartToPageLayout(String viewId, LayoutPart newPart) {
        this.pageLayout.setRefPart(viewId, newPart);
        this.pageLayout.getViewLayoutRec(viewId, true);
        this.pageLayout.setFolderPart(viewId, this.placeholder);
        newPart.setContainer(this.placeholder);
    }
}

