/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ShowPartPaneMenuAction
extends PartEventAction
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;
    private int accelerator;

    public ShowPartPaneMenuAction(IWorkbenchWindow window) {
        super("");
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.initText();
        this.workbenchWindow.getPartService().addPartListener(this);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.show_part_pane_menu_action_context");
        this.setActionDefinitionId("org.eclipse.ui.window.showSystemMenu");
    }

    protected void initText() {
        this.setText(WorkbenchMessages.getString("ShowPartPaneMenuAction.text"));
        this.setToolTipText(WorkbenchMessages.getString("ShowPartPaneMenuAction.toolTip"));
    }

    protected void showMenu(PartPane pane) {
        pane.showPaneMenu();
    }

    protected void updateState() {
        this.setEnabled(this.getActivePart() != null);
    }

    public void runWithEvent(Event e) {
        if (this.workbenchWindow == null) {
            return;
        }
        this.accelerator = e.detail;
        IWorkbenchPart part = this.getActivePart();
        if (part != null) {
            this.showMenu(((PartSite)part.getSite()).getPane());
        }
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        this.updateState();
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        this.updateState();
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        this.updateState();
    }

    public void partDeactivated(IWorkbenchPart part) {
        super.partDeactivated(part);
        this.updateState();
    }

    public int getAccelerator() {
        int accelerator = this.accelerator;
        accelerator &= 0xFFFBFFFF;
        accelerator &= 0xFFFDFFFF;
        return accelerator &= 0xFFFEFFFF;
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow.getPartService().removePartListener(this);
        this.workbenchWindow = null;
    }
}

