/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardSelectionPage;

public abstract class WorkbenchWizardNode
implements IWizardNode,
IPluginContribution {
    protected WorkbenchWizardSelectionPage parentWizardPage;
    protected IWizard wizard;
    protected WorkbenchWizardElement wizardElement;

    public WorkbenchWizardNode(WorkbenchWizardSelectionPage aWizardPage, WorkbenchWizardElement element) {
        this.parentWizardPage = aWizardPage;
        this.wizardElement = element;
    }

    public abstract IWorkbenchWizard createWizard() throws CoreException;

    public void dispose() {
    }

    protected IStructuredSelection getCurrentResourceSelection() {
        return this.parentWizardPage.getCurrentResourceSelection();
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public String getLocalId() {
        return this.wizardElement.getLocalId();
    }

    public String getPluginId() {
        return this.wizardElement.getPluginId();
    }

    public IWizard getWizard() {
        if (this.wizard != null) {
            return this.wizard;
        }
        final IWorkbenchWizard[] workbenchWizard = new IWorkbenchWizard[1];
        final IStatus[] statuses = new IStatus[1];
        BusyIndicator.showWhile((Display)this.parentWizardPage.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Platform.run((ISafeRunnable)new SafeRunnable(this, statuses, workbenchWizard){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ IStatus[] val$statuses;
                    private final /* synthetic */ IWorkbenchWizard[] val$workbenchWizard;
                    {
                        this.this$1 = var1_1;
                        this.val$statuses = iStatusArray;
                        this.val$workbenchWizard = iWorkbenchWizardArray;
                    }

                    public void handleException(Throwable e) {
                        this.val$statuses[0] = new Status(4, 1.access$0(this.this$1).wizardElement.getConfigurationElement().getDeclaringExtension().getUniqueIdentifier(), 0, e.getMessage() == null ? "" : e.getMessage(), e);
                    }

                    public void run() {
                        try {
                            this.val$workbenchWizard[0] = 1.access$0(this.this$1).createWizard();
                        }
                        catch (CoreException e) {
                            this.val$statuses[0] = e.getStatus();
                        }
                    }
                });
            }

            static /* synthetic */ WorkbenchWizardNode access$0(1 var0) {
                return var0.WorkbenchWizardNode.this;
            }
        });
        if (statuses[0] != null) {
            this.parentWizardPage.setErrorMessage(WorkbenchMessages.getString("WorkbenchWizard.errorMessage"));
            ErrorDialog.openError((Shell)this.parentWizardPage.getShell(), (String)WorkbenchMessages.getString("WorkbenchWizard.errorTitle"), (String)WorkbenchMessages.getString("WorkbenchWizard.errorMessage"), (IStatus)statuses[0]);
            return null;
        }
        IStructuredSelection currentSelection = this.getCurrentResourceSelection();
        currentSelection = this.wizardElement.adaptedSelection(currentSelection);
        workbenchWizard[0].init(this.getWorkbench(), currentSelection);
        this.wizard = workbenchWizard[0];
        return this.wizard;
    }

    public WorkbenchWizardElement getWizardElement() {
        return this.wizardElement;
    }

    protected IWorkbench getWorkbench() {
        return this.parentWizardPage.getWorkbench();
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

