/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CheckboxDoubleListGroup
extends Composite
implements ICheckStateListener,
ISelectionChangedListener {
    private Object root;
    private Object currentList1Selection;
    private Map checkedStateStore = new HashMap(9);
    private ListenerList listeners = new ListenerList();
    private boolean singleList1Check = false;
    private boolean singleList2Check = false;
    private IStructuredContentProvider list1ContentProvider;
    private IStructuredContentProvider list2ContentProvider;
    private ILabelProvider list1LabelProvider;
    private ILabelProvider list2LabelProvider;
    private CheckboxTableViewer list1Viewer;
    private CheckboxTableViewer list2Viewer;

    public CheckboxDoubleListGroup(Composite parent, Object rootObject, IStructuredContentProvider list1ContentProvider, ILabelProvider list1LabelProvider, IStructuredContentProvider list2ContentProvider, ILabelProvider list2LabelProvider, int style) {
        this(parent, rootObject, list1ContentProvider, list1LabelProvider, list2ContentProvider, list2LabelProvider, style, -1, -1);
    }

    public CheckboxDoubleListGroup(Composite parent, Object rootObject, IStructuredContentProvider list1ContentProvider, ILabelProvider list1LabelProvider, IStructuredContentProvider list2ContentProvider, ILabelProvider list2LabelProvider, int style, int width, int height) {
        super(parent, style);
        this.root = rootObject;
        this.list1ContentProvider = list1ContentProvider;
        this.list2ContentProvider = list2ContentProvider;
        this.list1LabelProvider = list1LabelProvider;
        this.list2LabelProvider = list2LabelProvider;
        this.createContents(parent, width, height);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.listeners.add((Object)listener);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getCheckable().equals(this.list1Viewer)) {
            this.list1ItemChecked(event.getElement(), event.getChecked());
        } else {
            this.list2ItemChecked(event.getElement(), event.getChecked());
        }
        this.notifyCheckStateChangeListeners(event);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(-1, -1);
    }

    protected void createContents(Composite parent, int width, int height) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.createList1Viewer(this.createViewPane(composite, width / 2, height / 2));
        this.createList2Viewer(this.createViewPane(composite, width / 2, height / 2));
        this.list1Viewer.setInput(this.root);
    }

    protected void createList1Viewer(Composite parent) {
        this.list1Viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
        this.list1Viewer.setContentProvider((IContentProvider)this.list1ContentProvider);
        this.list1Viewer.setLabelProvider((IBaseLabelProvider)this.list1LabelProvider);
        this.list1Viewer.addCheckStateListener((ICheckStateListener)this);
        this.list1Viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.list1Viewer.getTable().setFont(parent.getFont());
    }

    protected void createList2Viewer(Composite parent) {
        this.list2Viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
        this.list2Viewer.setContentProvider((IContentProvider)this.list2ContentProvider);
        this.list2Viewer.setLabelProvider((IBaseLabelProvider)this.list2LabelProvider);
        this.list2Viewer.addCheckStateListener((ICheckStateListener)this);
        this.list2Viewer.getTable().setFont(parent.getFont());
    }

    protected Composite createViewPane(Composite parent, int width, int height) {
        Composite pane = new Composite(parent, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = width;
        spec.heightHint = height;
        pane.setLayoutData((Object)spec);
        pane.setLayout((Layout)new FillLayout());
        pane.setFont(parent.getFont());
        return pane;
    }

    public Set getAllCheckedList1Items() {
        return this.checkedStateStore.keySet();
    }

    public List getAllCheckedList2Items() {
        ArrayList result = new ArrayList();
        Iterator listCollectionsEnum = this.checkedStateStore.values().iterator();
        while (listCollectionsEnum.hasNext()) {
            Iterator currentCollection = ((List)listCollectionsEnum.next()).iterator();
            while (currentCollection.hasNext()) {
                result.add(currentCollection.next());
            }
        }
        return result;
    }

    public int getCheckedElementCount() {
        return this.checkedStateStore.size();
    }

    public void initialCheckList1Item(Object element) {
        this.checkedStateStore.put(element, new ArrayList());
        this.list1Viewer.setChecked(element, true);
    }

    protected void list1ItemChecked(Object listElement, boolean state) {
        if (state) {
            if (this.singleList1Check) {
                this.checkedStateStore.clear();
                this.list1Viewer.setAllChecked(false);
            }
            this.checkedStateStore.put(listElement, new ArrayList());
        } else {
            this.checkedStateStore.remove(listElement);
            this.list2Viewer.setAllChecked(false);
        }
        this.list1Viewer.setChecked(listElement, state);
    }

    protected void list2ItemChecked(Object listElement, boolean state) {
        List checkedListItems = (List)this.checkedStateStore.get(this.currentList1Selection);
        if (state) {
            if (this.singleList2Check) {
                checkedListItems = null;
                this.list2Viewer.setAllChecked(false);
                this.list2Viewer.setChecked(listElement, true);
            }
            if (checkedListItems == null) {
                this.list1ItemChecked(this.currentList1Selection, true);
                checkedListItems = (List)this.checkedStateStore.get(this.currentList1Selection);
            }
            checkedListItems.add(listElement);
        } else {
            checkedListItems.remove(listElement);
            if (checkedListItems.isEmpty()) {
                this.list1ItemChecked(this.currentList1Selection, false);
            }
        }
    }

    protected void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++i;
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            this.currentList1Selection = null;
            this.list2Viewer.setInput(this.currentList1Selection);
            return;
        }
        if (selectedElement != this.currentList1Selection) {
            this.list2Viewer.setInput(selectedElement);
            List listItemsToCheck = (List)this.checkedStateStore.get(selectedElement);
            if (listItemsToCheck != null) {
                Iterator listItemsEnum = listItemsToCheck.iterator();
                while (listItemsEnum.hasNext()) {
                    this.list2Viewer.setChecked(listItemsEnum.next(), true);
                }
            }
        }
        this.currentList1Selection = selectedElement;
    }

    public void setList1Providers(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.list1Viewer.setContentProvider((IContentProvider)contentProvider);
        this.list1Viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setList1Sorter(ViewerSorter sorter) {
        this.list1Viewer.setSorter(sorter);
    }

    public void setList2Providers(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.list2Viewer.setContentProvider((IContentProvider)contentProvider);
        this.list2Viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setList2Sorter(ViewerSorter sorter) {
        this.list2Viewer.setSorter(sorter);
    }

    public void setRoot(Object rootElement) {
        this.root = rootElement;
        this.checkedStateStore.clear();
        this.list1Viewer.setInput(rootElement);
    }

    public void setSingleList1Check(boolean value) {
        this.singleList1Check = value;
    }

    public void setSingleList2Check(boolean value) {
        this.singleList2Check = value;
    }
}

