/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetCategory;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.ActionSetPartAssociationsReader;
import org.eclipse.ui.internal.registry.ActionSetRegistryReader;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ActionSetRegistry {
    public static final String OTHER_CATEGORY = "org.eclipse.ui.actionSetCategory";
    private ArrayList children = new ArrayList();
    private ArrayList categories = new ArrayList(1);
    private Map mapPartToActionSets = new HashMap();
    private Map mapCacheToActionSets = new HashMap();

    public ActionSetRegistry() {
        this.readFromRegistry();
    }

    public void addActionSet(ActionSetDescriptor desc) {
        this.children.add(desc);
    }

    public void addAssociation(String actionSetId, String partId) {
        IActionSetDescriptor desc;
        ArrayList<IActionSetDescriptor> actionSets = (ArrayList<IActionSetDescriptor>)this.mapPartToActionSets.get(partId);
        if (actionSets == null) {
            actionSets = new ArrayList<IActionSetDescriptor>();
            this.mapPartToActionSets.put(partId, actionSets);
        }
        if ((desc = this.findActionSet(actionSetId)) == null) {
            WorkbenchPlugin.log("Unable to associate action set with part: " + partId + ". Action set " + actionSetId + " not found.");
            return;
        }
        if (!actionSets.contains(desc)) {
            actionSets.add(desc);
        }
    }

    public IActionSetDescriptor findActionSet(String id) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)iterator.next();
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public ActionSetCategory findCategory(String id) {
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            ActionSetCategory cat = (ActionSetCategory)iterator.next();
            if (!id.equals(cat.getId())) continue;
            return cat;
        }
        return null;
    }

    public IActionSetDescriptor[] getActionSets() {
        int count = this.children.size();
        IActionSetDescriptor[] array = new IActionSetDescriptor[count];
        int nX = 0;
        while (nX < count) {
            array[nX] = (IActionSetDescriptor)this.children.get(nX);
            ++nX;
        }
        return array;
    }

    public IActionSetDescriptor[] getActionSetsFor(String partId) {
        ArrayList actionSets = (ArrayList)this.mapPartToActionSets.get(partId);
        if (actionSets == null) {
            return new IActionSetDescriptor[0];
        }
        return actionSets.toArray(new IActionSetDescriptor[actionSets.size()]);
    }

    public ActionSetCategory[] getCategories() {
        int count = this.categories.size();
        ActionSetCategory[] array = new ActionSetCategory[count];
        int i = 0;
        while (i < count) {
            array[i] = (ActionSetCategory)this.categories.get(i);
            ++i;
        }
        return array;
    }

    public void mapActionSetsToCategories() {
        ActionSetCategory cat = new ActionSetCategory(OTHER_CATEGORY, WorkbenchMessages.getString("ActionSetRegistry.otherCategory"));
        this.categories.add(cat);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)iterator.next();
            cat.addActionSet(desc);
        }
    }

    public void readFromRegistry() {
        ActionSetRegistryReader reader = new ActionSetRegistryReader();
        reader.readRegistry(Platform.getExtensionRegistry(), this);
        ActionSetPartAssociationsReader assocReader = new ActionSetPartAssociationsReader();
        assocReader.readRegistry(Platform.getExtensionRegistry(), this);
    }

    public Object removeCache(String actionSetId) {
        return this.mapCacheToActionSets.remove(actionSetId);
    }

    public void remove(String id) {
        IActionSetDescriptor desc = this.findActionSet(id);
        if (id != null) {
            this.children.remove(desc);
            this.categories.remove(desc);
        }
    }

    public void removeAssociation(String actionSetId, String partId) {
        IActionSetDescriptor desc = this.findActionSet(actionSetId);
        if (desc == null) {
            return;
        }
        ArrayList actionSets = (ArrayList)this.mapPartToActionSets.get(partId);
        if (actionSets == null) {
            return;
        }
        if (actionSets.contains(desc)) {
            actionSets.remove(desc);
        }
        if (actionSets.size() == 0) {
            this.mapPartToActionSets.remove(partId);
        }
    }
}

