/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class IntroPart
implements IIntroPart,
IExecutableExtension {
    private IConfigurationElement configElement;
    private ImageDescriptor imageDescriptor;
    private IIntroSite partSite;
    private ListenerList propChangeListeners = new ListenerList(2);
    private Image titleImage;

    protected IntroPart() {
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public abstract void createPartControl(Composite var1);

    public void dispose() {
        int count;
        ReferenceCounter imageCache = WorkbenchImages.getImageCache();
        Image image = (Image)imageCache.get(this.imageDescriptor);
        if (image != null && (count = imageCache.removeRef(this.imageDescriptor)) <= 0) {
            image.dispose();
        }
        if (!this.propChangeListeners.isEmpty()) {
            this.propChangeListeners = new ListenerList(1);
        }
    }

    protected void firePropertyChange(final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPropertyListener l = (IPropertyListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged((Object)this, propertyId);
                }
            });
            ++nX;
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    protected Image getDefaultImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    public final IIntroSite getIntroSite() {
        return this.partSite;
    }

    public Image getTitleImage() {
        if (this.titleImage != null) {
            return this.titleImage;
        }
        return this.getDefaultImage();
    }

    public void init(IIntroSite site, IMemento memento) throws PartInitException {
        this.setSite(site);
    }

    protected void setSite(IIntroSite site) {
        this.partSite = site;
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    public void saveState(IMemento memento) {
    }

    public abstract void setFocus();

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
        String strIcon = cfig.getAttribute("icon");
        if (strIcon == null) {
            return;
        }
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configElement.getDeclaringExtension().getNamespace(), strIcon);
        if (this.imageDescriptor == null) {
            return;
        }
        ReferenceCounter imageCache = WorkbenchImages.getImageCache();
        Image image = (Image)imageCache.get(this.imageDescriptor);
        if (image != null) {
            imageCache.addRef(this.imageDescriptor);
        } else {
            image = this.imageDescriptor.createImage();
            imageCache.put(this.imageDescriptor, image);
        }
        this.titleImage = image;
    }

    protected void setTitleImage(Image titleImage) {
        Assert.isTrue((titleImage == null || !titleImage.isDisposed() ? 1 : 0) != 0);
        if (this.titleImage == titleImage) {
            return;
        }
        this.titleImage = titleImage;
        this.firePropertyChange(1);
    }
}

