/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

class InputPatchPage
extends WizardPage {
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    protected static final int COMBO_HISTORY_LENGTH = 5;
    private static final String PAGE_NAME = "PatchWizardPage1";
    private static final String STORE_PATCH_FILES_ID = "PatchWizardPage1.PATCH_FILES";
    private static final String STORE_USE_CLIPBOARD_ID = "PatchWizardPage1.USE_CLIPBOARD";
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    private boolean fShowError = false;
    private Button fUseClipboardButton;
    private Combo fPatchFileNameField;
    private Button fPatchFileBrowseButton;
    private Button fUsePatchFileButton;
    private Group fPatchFileGroup;
    private CheckboxTreeViewer fPatchTargets;
    private PatchWizard fPatchWizard;

    InputPatchPage(PatchWizard pw) {
        super("InputPatchPage", PatchMessages.getString("InputPatchPage.title"), null);
        this.fPatchWizard = pw;
        this.setMessage(PatchMessages.getString("InputPatchPage.message"));
    }

    protected IPath getPathFromText(Text textField) {
        return new Path(textField.getText()).makeAbsolute();
    }

    String getPatchName() {
        if (this.getUseClipboard()) {
            return PatchMessages.getString("InputPatchPage.Clipboard");
        }
        return this.getPatchFilePath();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        Label l = new Label(composite, 0);
        l.setText(PatchMessages.getString("InputPatchPage.SelectInput"));
        this.buildInputGroup(composite);
        new Label(composite, 0);
        this.buildPatchFileGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.compare.patch_input_wizard_page_context");
    }

    public IWizardPage getNextPage() {
        Diff[] diffs;
        String source;
        Patcher patcher = ((PatchWizard)this.getWizard()).getPatcher();
        Reader reader = null;
        if (this.getUseClipboard()) {
            Control c = this.getControl();
            if (c != null) {
                Clipboard clipboard = new Clipboard(c.getDisplay());
                Object o = clipboard.getContents((Transfer)TextTransfer.getInstance());
                clipboard.dispose();
                if (o instanceof String) {
                    reader = new StringReader((String)o);
                }
            }
            source = PatchMessages.getString("InputPatchPage.Clipboard.title");
        } else {
            String patchFilePath = this.getPatchFilePath();
            if (patchFilePath != null) {
                try {
                    reader = new FileReader(patchFilePath);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MessageDialog.openError(null, (String)PatchMessages.getString("InputPatchPage.PatchErrorDialog.title"), (String)PatchMessages.getString("InputPatchPage.PatchFileNotFound.message"));
                }
            }
            source = PatchMessages.getString("InputPatchPage.PatchFile.title");
        }
        if (reader != null) {
            try {
                patcher.parse(new BufferedReader(reader));
            }
            catch (IOException iOException) {
                MessageDialog.openError(null, (String)PatchMessages.getString("InputPatchPage.PatchErrorDialog.title"), (String)PatchMessages.getString("InputPatchPage.ParseError.message"));
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        if ((diffs = patcher.getDiffs()) == null || diffs.length == 0) {
            String format = PatchMessages.getString("InputPatchPage.NoDiffsFound.format");
            String message = MessageFormat.format(format, source);
            MessageDialog.openInformation(null, (String)PatchMessages.getString("InputPatchPage.PatchErrorDialog.title"), (String)message);
            return this;
        }
        IResource target = this.fPatchWizard.getTarget();
        if (target instanceof IFile && diffs.length > 1) {
            String format = PatchMessages.getString("InputPatchPage.SingleFileError.format");
            String message = MessageFormat.format(format, source);
            MessageDialog.openInformation(null, (String)PatchMessages.getString("InputPatchPage.PatchErrorDialog.title"), (String)message);
            return this;
        }
        int guess = 0;
        patcher.setStripPrefixSegments(guess);
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void setEnablePatchFile(boolean enable) {
        this.fPatchFileNameField.setEnabled(enable);
        this.fPatchFileBrowseButton.setEnabled(enable);
    }

    private void buildPatchFileGroup(Composite parent) {
        this.fPatchFileGroup = new Group(parent, 0);
        this.fPatchFileGroup.setText(PatchMessages.getString("InputPatchPage.SelectPatch.title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.fPatchFileGroup.setLayout((Layout)layout);
        this.fPatchFileGroup.setLayoutData((Object)new GridData(768));
        this.fUsePatchFileButton = new Button((Composite)this.fPatchFileGroup, 16);
        this.fUsePatchFileButton.setText(PatchMessages.getString("InputPatchPage.FileButton.text"));
        this.fPatchFileNameField = new Combo((Composite)this.fPatchFileGroup, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        this.fPatchFileNameField.setLayoutData((Object)gd);
        this.fPatchFileBrowseButton = new Button((Composite)this.fPatchFileGroup, 8);
        this.fPatchFileBrowseButton.setText(PatchMessages.getString("InputPatchPage.ChooseFileButton.text"));
        this.fPatchFileBrowseButton.setLayoutData((Object)new GridData());
        this.fUseClipboardButton = new Button((Composite)this.fPatchFileGroup, 16);
        this.fUseClipboardButton.setText(PatchMessages.getString("InputPatchPage.UseClipboardButton.text"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fUseClipboardButton.setLayoutData((Object)gd);
        this.fUsePatchFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputPatchPage.this.fShowError = true;
                InputPatchPage.this.setEnablePatchFile(!InputPatchPage.this.getUseClipboard());
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fPatchFileNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputPatchPage.this.setSourceName(InputPatchPage.this.fPatchFileNameField.getText());
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fPatchFileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputPatchPage.this.fShowError = true;
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fPatchFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputPatchPage.this.handlePatchFileBrowseButtonPressed();
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
    }

    private void buildInputGroup(Composite parent) {
        PatchWizard pw = (PatchWizard)this.getWizard();
        IResource target = pw.getTarget();
        IWorkspace workspace = target.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Tree tree = new Tree(parent, 2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        tree.setLayoutData((Object)gd);
        this.fPatchTargets = new CheckboxTreeViewer(tree);
        this.fPatchTargets.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fPatchTargets.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fPatchTargets.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.fPatchTargets.setInput((Object)root);
        if (target != null) {
            this.fPatchTargets.expandToLevel((Object)target, 0);
            this.fPatchTargets.setSelection((ISelection)new StructuredSelection((Object)target));
        }
        this.fPatchTargets.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InputPatchPage.this.fPatchWizard.setTargets(Utilities.getResources(event.getSelection()));
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
    }

    private void updateWidgetEnablements() {
        boolean anySelected;
        String error = null;
        ISelection selection = this.fPatchTargets.getSelection();
        boolean bl = anySelected = selection != null && !selection.isEmpty();
        if (!anySelected) {
            error = PatchMessages.getString("InputPatchPage.NothingSelected.message");
        }
        boolean gotPatch = false;
        if (this.getUseClipboard()) {
            Control c = this.getControl();
            if (c != null) {
                Clipboard clipboard = new Clipboard(c.getDisplay());
                Object o = clipboard.getContents((Transfer)TextTransfer.getInstance());
                clipboard.dispose();
                if (o instanceof String) {
                    String s = ((String)o).trim();
                    if (s.length() > 0) {
                        gotPatch = true;
                    } else {
                        error = PatchMessages.getString("InputPatchPage.ClipboardIsEmpty.message");
                    }
                } else {
                    error = PatchMessages.getString("InputPatchPage.NoTextInClipboard.message");
                }
            } else {
                error = PatchMessages.getString("InputPatchPage.CouldNotReadClipboard.message");
            }
        } else {
            String path = this.fPatchFileNameField.getText();
            if (path != null && path.length() > 0) {
                File file = new File(path);
                boolean bl2 = gotPatch = file.exists() && file.isFile() && file.length() > 0L;
                if (!gotPatch) {
                    error = String.valueOf(PatchMessages.getString("InputPatchPage.CannotLocatePatch.message")) + path;
                }
            } else {
                error = PatchMessages.getString("InputPatchPage.NoFileName.message");
            }
        }
        this.setPageComplete(anySelected && gotPatch);
        if (this.fShowError) {
            this.setErrorMessage(error);
        }
    }

    protected void handlePatchFileBrowseButtonPressed() {
        int lastSegment;
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(PatchMessages.getString("InputPatchPage.SelectPatchFileDialog.title"));
        String patchFilePath = this.getPatchFilePath();
        if (patchFilePath != null && (lastSegment = patchFilePath.lastIndexOf(SEPARATOR)) > 0) {
            patchFilePath = patchFilePath.substring(0, lastSegment);
        }
        dialog.setFilterPath(patchFilePath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        patchFilePath = dialog.getFileName();
        Path filterPath = new Path(dialog.getFilterPath());
        IPath path = filterPath.append(patchFilePath).makeAbsolute();
        patchFilePath = path.toOSString();
        this.fPatchFileNameField.setText(patchFilePath);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.fPatchFileNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.fPatchFileNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.fPatchFileNameField.select(selectionIndex);
        }
    }

    public boolean finish() {
        this.saveWidgetValues();
        return true;
    }

    private void restoreWidgetValues() {
        boolean useClipboard = false;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String patchFilePath;
            useClipboard = settings.getBoolean(STORE_USE_CLIPBOARD_ID);
            String[] sourceNames = settings.getArray(STORE_PATCH_FILES_ID);
            if (sourceNames != null) {
                int i = 0;
                while (i < sourceNames.length) {
                    if (sourceNames[i] != null && sourceNames[i].length() > 0) {
                        this.fPatchFileNameField.add(sourceNames[i]);
                    }
                    ++i;
                }
            }
            if ((patchFilePath = settings.get(STORE_PATCH_FILES_ID)) != null) {
                this.setSourceName(patchFilePath);
            }
        }
        this.setUseClipboard(useClipboard);
    }

    void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_USE_CLIPBOARD_ID, this.getUseClipboard());
            settings.put(STORE_PATCH_FILES_ID, this.getPatchFilePath());
            String[] sourceNames = settings.getArray(STORE_PATCH_FILES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = InputPatchPage.addToHistory(sourceNames, this.getPatchFilePath());
            settings.put(STORE_PATCH_FILES_ID, sourceNames);
        }
    }

    private void setUseClipboard(boolean useClipboard) {
        if (useClipboard) {
            this.fUseClipboardButton.setSelection(true);
        } else {
            this.fUsePatchFileButton.setSelection(true);
        }
        this.setEnablePatchFile(!useClipboard);
    }

    private boolean getUseClipboard() {
        if (this.fUseClipboardButton != null) {
            return this.fUseClipboardButton.getSelection();
        }
        return false;
    }

    private String getPatchFilePath() {
        if (this.fPatchFileNameField != null) {
            return this.fPatchFileNameField.getText();
        }
        return "";
    }

    protected static String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        l.remove(newEntry);
        l.add(0, newEntry);
        if (l.size() > 5) {
            l.remove(5);
        }
        return l.toArray(new String[l.size()]);
    }
}

