/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;

public class IDEApplication
implements IPlatformRunnable,
IExecutableExtension {
    private static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "1";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final Integer EXIT_RELAUNCH = new Integer(24);
    private static final int MIN_JVM_VERSION_MAJOR = 1;
    private static final int MIN_JVM_VERSION_MINOR = 4;
    private static final int MIN_JVM_VERSION_SERVICE = 1;

    /*
     * Exception decompiling
     */
    public Object run(Object args) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [2 : 87->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private boolean checkJavaRuntimeVersion(Shell shell) {
        try {
            if (IDEApplication.isCompatibleVersion(System.getProperty("java.version"))) {
                return true;
            }
            String reqVersion = String.valueOf(Integer.toString(1)) + '.' + 4 + '.' + 1;
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.incompatibleJVMTitle"), (String)IDEWorkbenchMessages.format("IDEApplication.incompatibleJVMMessage", new Object[]{reqVersion}));
            return false;
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private boolean checkInstanceLocation(Shell shell) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceMandatoryTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceMandatoryMessage"));
            return false;
        }
        if (instanceLoc.isSet()) {
            if (!this.checkValidWorkspace(shell, instanceLoc.getURL())) {
                return false;
            }
            try {
                if (instanceLoc.lock()) {
                    IDEApplication.writeWorkspaceVersion();
                    return true;
                }
            }
            catch (IOException iOException) {}
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceCannotLockTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceCannotLockMessage"));
            return false;
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        boolean force = false;
        URL workspaceUrl;
        while ((workspaceUrl = this.promptForWorkspace(shell, launchData, force)) != null) {
            force = true;
            try {
                if (instanceLoc.setURL(workspaceUrl, true)) {
                    launchData.writePersistedData();
                    IDEApplication.writeWorkspaceVersion();
                    return true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceCannotBeSetTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceCannotBeSetMessage"));
                return false;
            }
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceInUseTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceInUseMessage"));
        }
        return false;
    }

    private static boolean isCompatibleVersion(String vmVersion) {
        if (vmVersion == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(vmVersion, " ._");
        try {
            if (!tokenizer.hasMoreTokens()) {
                return true;
            }
            int major = Integer.parseInt(tokenizer.nextToken());
            if (major != 1) {
                return major > 4;
            }
            if (!tokenizer.hasMoreTokens()) {
                return true;
            }
            int minor = Integer.parseInt(tokenizer.nextToken());
            if (minor != 4) {
                return minor > 4;
            }
            if (!tokenizer.hasMoreTokens()) {
                return true;
            }
            int service = Integer.parseInt(tokenizer.nextToken());
            return service >= 1;
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean force) {
        URL url = null;
        do {
            new ChooseWorkspaceDialog(shell, launchData, false).prompt(force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceInvalidTitle"), (String)IDEWorkbenchMessages.getString("IDEApplication.workspaceInvalidMessage"));
            }
        } while (!this.checkValidWorkspace(shell, url));
        return url;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        String version = IDEApplication.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        String title = IDEWorkbenchMessages.getString("IDEApplication.versionTitle");
        String message = IDEWorkbenchMessages.format("IDEApplication.versionMessage", new Object[]{url.getFile()});
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = IDEApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                is.close();
                throw throwable;
            }
            {
                Object var4_7 = null;
            }
            is.close();
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log("Could not read version file", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeWorkspaceVersion() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) return;
        if (instanceLoc.isReadOnly()) {
            return;
        }
        File versionFile = IDEApplication.getVersionFile(instanceLoc.getURL(), true);
        if (versionFile == null) {
            return;
        }
        FileOutputStream output = null;
        try {
            try {
                String versionLine = "org.eclipse.core.runtime=1";
                output = new FileOutputStream(versionFile);
                ((OutputStream)output).write(versionLine.getBytes("UTF-8"));
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log("Could not write version file", StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (output == null) throw throwable;
                ((OutputStream)output).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (output == null) return;
        ((OutputStream)output).close();
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        if (workspaceUrl == null) {
            return null;
        }
        try {
            File metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
            if (!(metaDir.exists() || create && metaDir.mkdir())) {
                return null;
            }
            File versionFile = new File(metaDir, VERSION_FILENAME);
            if (!(versionFile.exists() || create && versionFile.createNewFile())) {
                return null;
            }
            return versionFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

