/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class ClasspathUtilCore {
    public static void setClasspath(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        Vector<IClasspathEntry> result = new Vector<IClasspathEntry>();
        monitor.beginTask("", 3);
        ClasspathUtilCore.addSourceAndLibraries(model, result);
        monitor.worked(1);
        result.add(ClasspathUtilCore.createContainerEntry());
        monitor.worked(1);
        result.add(ClasspathUtilCore.createJREEntry());
        monitor.worked(1);
        IClasspathEntry[] entries = result.toArray(new IClasspathEntry[result.size()]);
        IJavaProject javaProject = JavaCore.create((IProject)model.getUnderlyingResource().getProject());
        IJavaModelStatus validation = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])entries, (IPath)javaProject.getOutputLocation());
        if (!validation.isOK()) {
            PDECore.logErrorMessage(validation.getMessage());
            throw new CoreException((IStatus)validation);
        }
        javaProject.setRawClasspath(entries, monitor);
        monitor.done();
    }

    private static void computePluginEntries(IPluginModelBase model, Vector result, IProgressMonitor monitor) {
        try {
            HashSet alreadyAdded = new HashSet();
            if (model.isFragmentModel()) {
                ClasspathUtilCore.addParentPlugin((IFragment)model.getPluginBase(), result, alreadyAdded);
            }
            IPluginImport[] dependencies = model.getPluginBase().getImports();
            int i = 0;
            while (i < dependencies.length) {
                IPluginImport dependency = dependencies[i];
                IPlugin plugin = PDECore.getDefault().findPlugin(dependency.getId(), dependency.getVersion(), dependency.getMatch());
                if (plugin != null) {
                    ClasspathUtilCore.addDependency(plugin, dependency.isReexported(), result, alreadyAdded);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++i;
            }
            ClasspathUtilCore.addExtraClasspathEntries(model, result);
            ClasspathUtilCore.addImplicitDependencies(model.getPluginBase().getId(), model.getPluginBase().getSchemaVersion(), result, alreadyAdded);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (CoreException coreException) {}
    }

    private static void addExtraClasspathEntries(IPluginModelBase model, Vector result) throws CoreException {
        IBuildEntry entry;
        IBuild build = ClasspathUtilCore.getBuild(model);
        IBuildEntry iBuildEntry = entry = build == null ? null : build.getEntry("jars.extra.classpath");
        if (entry == null) {
            return;
        }
        String[] tokens = entry.getTokens();
        int i = 0;
        while (i < tokens.length) {
            IResource resource;
            String device = new Path(tokens[i]).getDevice();
            Path path = null;
            if (device == null) {
                path = new Path(model.getUnderlyingResource().getProject().getName());
                path = path.append(tokens[i]);
            } else if (device.equals("platform:") && (path = new Path(tokens[i])).segmentCount() > 1 && path.segment(0).equals("plugin")) {
                path = path.setDevice(null);
                path = path.removeFirstSegments(1);
            }
            if (path != null && (resource = PDECore.getWorkspace().getRoot().findMember((IPath)path)) != null && resource instanceof IFile) {
                IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)resource.getFullPath(), null, null);
                IProject project = resource.getProject();
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject jProject = JavaCore.create((IProject)project);
                    IClasspathEntry[] entries = jProject.getRawClasspath();
                    int j = 0;
                    while (j < entries.length) {
                        if (entries[j].getEntryKind() == 1 && entries[j].getContentKind() == 2 && entries[j].getPath().equals((Object)resource.getFullPath())) {
                            newEntry = JavaCore.newLibraryEntry((IPath)entries[j].getPath(), (IPath)entries[j].getSourceAttachmentPath(), (IPath)entries[j].getSourceAttachmentRootPath());
                            break;
                        }
                        ++j;
                    }
                }
                if (!result.contains(newEntry)) {
                    result.add(newEntry);
                }
            }
            ++i;
        }
    }

    public static IClasspathEntry[] computePluginEntries(IPluginModelBase model) {
        Vector result = new Vector();
        ClasspathUtilCore.computePluginEntries(model, result, null);
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    private static void addDependency(IPlugin plugin, boolean isExported, Vector result, HashSet alreadyAdded) throws CoreException {
        if (!alreadyAdded.add(plugin)) {
            return;
        }
        IResource resource = plugin.getModel().getUnderlyingResource();
        if (resource != null) {
            IClasspathEntry entry;
            IProject project = resource.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature") && !result.contains(entry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)isExported))) {
                result.add(entry);
            }
            return;
        }
        IPluginLibrary[] libraries = plugin.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IClasspathEntry entry;
            if (!"resource".equals(libraries[i].getType()) && libraries[i].isExported() && (entry = ClasspathUtilCore.createLibraryEntry(libraries[i], isExported)) != null && !result.contains(entry)) {
                result.add(entry);
            }
            ++i;
        }
        IPluginImport[] imports = plugin.getImports();
        int i2 = 0;
        while (i2 < imports.length) {
            IPlugin importedPlugin;
            IPluginImport dependency = imports[i2];
            if (dependency.isReexported() && (importedPlugin = PDECore.getDefault().findPlugin(dependency.getId(), dependency.getVersion(), dependency.getMatch())) != null) {
                ClasspathUtilCore.addDependency(importedPlugin, isExported, result, alreadyAdded);
            }
            ++i2;
        }
    }

    private static boolean isOSGiRuntime() {
        return PDECore.getDefault().getModelManager().isOSGiRuntime();
    }

    protected static void addImplicitDependencies(String id, String schemaVersion, Vector result, HashSet alreadyAdded) throws CoreException {
        if (ClasspathUtilCore.isOSGiRuntime() && schemaVersion != null || id.equals("org.eclipse.core.boot") || id.equals("org.apache.xerces") || id.startsWith("org.eclipse.swt")) {
            return;
        }
        if (schemaVersion == null && ClasspathUtilCore.isOSGiRuntime()) {
            IPlugin plugin;
            if (!id.equals("org.eclipse.core.runtime") && (plugin = PDECore.getDefault().findPlugin("org.eclipse.core.runtime.compatibility")) != null) {
                ClasspathUtilCore.addDependency(plugin, false, result, alreadyAdded);
            }
        } else {
            IPlugin plugin = PDECore.getDefault().findPlugin("org.eclipse.core.boot");
            if (plugin != null) {
                ClasspathUtilCore.addDependency(plugin, false, result, alreadyAdded);
            }
            if (!id.equals("org.eclipse.core.runtime") && (plugin = PDECore.getDefault().findPlugin("org.eclipse.core.runtime")) != null) {
                ClasspathUtilCore.addDependency(plugin, false, result, alreadyAdded);
            }
        }
    }

    public static IClasspathEntry createJREEntry() {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
    }

    public static void addLibraries(IPluginModelBase model, boolean unconditionallyExport, Vector result) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IClasspathEntry entry = ClasspathUtilCore.createLibraryEntry(libraries[i], unconditionallyExport);
            if (entry != null && !result.contains(entry)) {
                result.add(entry);
            }
            ++i;
        }
    }

    private static void addParentPlugin(IFragment fragment, Vector result, HashSet alreadyAdded) throws CoreException {
        IPlugin parent = PDECore.getDefault().findPlugin(fragment.getPluginId(), fragment.getPluginVersion(), fragment.getRule());
        if (parent != null) {
            ClasspathUtilCore.addDependency(parent, false, result, alreadyAdded);
            IPluginImport[] imports = parent.getImports();
            int i = 0;
            while (i < imports.length) {
                IPlugin plugin;
                if (!imports[i].isReexported() && (plugin = PDECore.getDefault().findPlugin(imports[i].getId(), imports[i].getVersion(), imports[i].getMatch())) != null) {
                    ClasspathUtilCore.addDependency(plugin, false, result, alreadyAdded);
                }
                ++i;
            }
        }
    }

    private static void addSourceAndLibraries(IPluginModelBase model, Vector result) throws CoreException {
        IPath path;
        IProject project = model.getUnderlyingResource().getProject();
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        IBuild build = ClasspathUtilCore.getBuild(model);
        int i = 0;
        while (i < libraries.length) {
            IPluginLibrary library = libraries[i];
            if (!"resource".equals(library.getType())) {
                IBuildEntry buildEntry;
                IBuildEntry iBuildEntry = buildEntry = build == null ? null : build.getEntry("source." + library.getName());
                if (buildEntry != null) {
                    String[] folders = buildEntry.getTokens();
                    int k = 0;
                    while (k < folders.length) {
                        path = project.getFullPath().append(folders[k]);
                        if (project.findMember(folders[k]) != null) {
                            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path);
                            if (!result.contains(entry)) {
                                result.add(entry);
                            }
                        } else {
                            ClasspathUtilCore.addSourceFolder(folders[k], project, result);
                        }
                        ++k;
                    }
                } else {
                    IClasspathEntry entry = ClasspathUtilCore.createLibraryEntry(library, library.isExported());
                    if (entry != null && !result.contains(entry)) {
                        result.add(entry);
                    }
                }
            }
            ++i;
        }
        IClasspathEntry[] entries = JavaCore.create((IProject)project).getRawClasspath();
        int i2 = 0;
        while (i2 < entries.length) {
            IClasspathEntry entry = entries[i2];
            if (entry.getEntryKind() == 3 && !result.contains(entry)) {
                boolean doAdd = true;
                int j = 0;
                while (j < result.size()) {
                    path = ((IClasspathEntry)result.get(j)).getPath();
                    if (path.isPrefixOf(entry.getPath()) || entry.getPath().isPrefixOf(path)) {
                        doAdd = false;
                        break;
                    }
                    ++j;
                }
                if (doAdd) {
                    result.add(entry);
                }
            }
            ++i2;
        }
    }

    protected static void addSourceFolder(String name, IProject project, Vector result) throws CoreException {
        CoreUtility.createFolder(project.getFolder(name), true, true, null);
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)project.getFullPath().append(name));
        if (!result.contains(entry)) {
            result.add(entry);
        }
    }

    public static IClasspathEntry createContainerEntry() {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
    }

    private static IClasspathEntry createLibraryEntry(IPluginLibrary library, boolean exported) {
        try {
            String name = library.getName();
            String expandedName = ClasspathUtilCore.expandLibraryName(name);
            IPluginModelBase model = library.getPluginModel();
            IPath path = ClasspathUtilCore.getPath(model, expandedName);
            if (path == null) {
                if (model.isFragmentModel() || !ClasspathUtilCore.containsVariables(name)) {
                    return null;
                }
                model = ClasspathUtilCore.resolveLibraryInFragments(library, expandedName);
                if (model == null) {
                    return null;
                }
                path = ClasspathUtilCore.getPath(model, expandedName);
            }
            return JavaCore.newLibraryEntry((IPath)path, (IPath)ClasspathUtilCore.getSourceAnnotation(model, expandedName), null, (boolean)exported);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static boolean containsVariables(String name) {
        return name.indexOf("$os$") != -1 || name.indexOf("$ws$") != -1 || name.indexOf("$nl$") != -1 || name.indexOf("$arch$") != -1;
    }

    public static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.indexOf("$ws$") != -1) {
            source = source.replaceAll("\\$ws\\$", "ws/" + TargetPlatform.getWS());
        }
        if (source.indexOf("$os$") != -1) {
            source = source.replaceAll("\\$os\\$", "os/" + TargetPlatform.getOS());
        }
        if (source.indexOf("$nl$") != -1) {
            source = source.replaceAll("\\$nl\\$", "nl/" + TargetPlatform.getNL());
        }
        if (source.indexOf("$arch$") != -1) {
            source = source.replaceAll("\\$arch\\$", "arch/" + TargetPlatform.getOSArch());
        }
        return source;
    }

    protected static IBuild getBuild(IPluginModelBase model) throws CoreException {
        IProject project;
        IFile buildFile;
        IBuildModel buildModel = model.getBuildModel();
        if (buildModel == null && (buildFile = (project = model.getUnderlyingResource().getProject()).getFile("build.properties")).exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel != null ? buildModel.getBuild() : null;
    }

    private static IPath getSourceAnnotation(IPluginModelBase model, String libraryName) throws CoreException {
        String zipName;
        IPath path = null;
        int dot = libraryName.lastIndexOf(46);
        if (dot != -1 && (path = ClasspathUtilCore.getPath(model, zipName = String.valueOf(libraryName.substring(0, dot)) + "src.zip")) == null) {
            SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
            path = manager.findPath(model.getPluginBase(), (IPath)new Path(zipName));
        }
        return path;
    }

    private static IPluginModelBase resolveLibraryInFragments(IPluginLibrary library, String libraryName) {
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(library.getPluginBase().getId(), library.getPluginBase().getVersion());
        int i = 0;
        while (i < fragments.length) {
            ModelEntry entry;
            IPluginModelBase model;
            IPath path = ClasspathUtilCore.getPath(fragments[i].getPluginModel(), libraryName);
            if (path != null) {
                return fragments[i].getPluginModel();
            }
            if (fragments[i].getModel().getUnderlyingResource() != null && (model = (entry = PDECore.getDefault().getModelManager().findEntry(fragments[i].getId())).getExternalModel()) != null && model instanceof IFragmentModel && (path = ClasspathUtilCore.getPath(model, libraryName)) != null) {
                return model;
            }
            ++i;
        }
        return null;
    }

    private static IPath getPath(IPluginModelBase model, String libraryName) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IResource jarFile = resource.getProject().findMember(libraryName);
            if (jarFile != null) {
                return jarFile.getFullPath();
            }
        } else {
            File file = new File(model.getInstallLocation(), libraryName);
            if (file.exists()) {
                return new Path(file.getAbsolutePath());
            }
        }
        return null;
    }
}

