/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;

public class TargetPlatformRegistryLoader {
    private static final String KEY_SCANNING_PROBLEMS = "ExternalModelManager.scanningProblems";

    private static String getMode(URL[] urls) {
        String targetMode = "2.1";
        int i = 0;
        while (i < urls.length) {
            if (urls[i].getFile().indexOf("org.eclipse.osgi") != -1) {
                targetMode = null;
            }
            ++i;
        }
        return targetMode;
    }

    public static void load(URL[] urls, PDEState state, IProgressMonitor monitor) {
        String targetMode = TargetPlatformRegistryLoader.getMode(urls);
        state.setTargetMode(targetMode);
        monitor.beginTask("", urls.length);
        int i = 0;
        while (i < urls.length) {
            state.addBundle(new File(urls[i].getFile()));
            monitor.worked(1);
            ++i;
        }
    }

    public static IPluginModelBase[] loadModels(URL[] urls, boolean resolve, PDEState state, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(PDECore.getResourceString("TargetPlatformRegistryLoader.parsing"), 10);
        TargetPlatformRegistryLoader.load(urls, state, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
        state.resolveState();
        monitor.worked(1);
        if (resolve) {
            TargetPlatformRegistryLoader.logResolutionErrors(state.getState());
        }
        BundleDescription[] bundleDescriptions = resolve ? state.getState().getResolvedBundles() : state.getState().getBundles();
        IPluginModelBase[] models = new IPluginModelBase[bundleDescriptions.length];
        int i = 0;
        while (i < bundleDescriptions.length) {
            monitor.subTask(bundleDescriptions[i].getSymbolicName());
            models[i] = TargetPlatformRegistryLoader.createModelFromDescription(bundleDescriptions[i], state);
            ++i;
        }
        monitor.done();
        return models;
    }

    private static void logResolutionErrors(State state) {
        MultiStatus errors = new MultiStatus(PDECore.getPluginId(), 1, PDECore.getResourceString(KEY_SCANNING_PROBLEMS), null);
        StateHelper helper = TargetPlatformRegistryLoader.acquireStateHelper();
        BundleDescription[] all = state.getBundles();
        int i = 0;
        while (i < all.length) {
            if (!all[i].isResolved()) {
                String message;
                VersionConstraint[] unsatisfiedConstraints = helper.getUnsatisfiedConstraints(all[i]);
                if (unsatisfiedConstraints.length == 0) {
                    BundleDescription activeBundle = TargetPlatformRegistryLoader.findActiveBundle(state, all[i].getSymbolicName());
                    if (activeBundle == null) {
                        message = PDECore.getFormattedMessage("ECLIPSE_IGNORE", all[i].getLocation());
                        errors.add((IStatus)new Status(4, all[i].getSymbolicName(), 2, message, null));
                    } else {
                        message = PDECore.getFormattedMessage("ECLIPSE_OTHER_VERSION", new String[]{all[i].getLocation(), activeBundle.getLocation()});
                        errors.add((IStatus)new Status(1, all[i].getSymbolicName(), 1, message, null));
                    }
                } else {
                    int j = 0;
                    while (j < unsatisfiedConstraints.length) {
                        message = TargetPlatformRegistryLoader.getResolutionFailureMessage(unsatisfiedConstraints[j]);
                        errors.add((IStatus)new Status(2, all[i].getSymbolicName(), 2, message, null));
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (errors.getChildren().length > 0) {
            PDECore.log((IStatus)errors);
        }
    }

    private static BundleDescription findActiveBundle(State state, String symbolicName) {
        BundleDescription[] bundles = state.getBundles(symbolicName);
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].isResolved()) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public static String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof PackageSpecification) {
            return PDECore.getFormattedMessage("ECLIPSE_MISSING_IMPORTED_PACKAGE", TargetPlatformRegistryLoader.toString(unsatisfied));
        }
        if (unsatisfied instanceof BundleSpecification) {
            if (((BundleSpecification)unsatisfied).isOptional()) {
                return PDECore.getFormattedMessage("ECLIPSE_MISSING_OPTIONAL_REQUIRED_BUNDLE", TargetPlatformRegistryLoader.toString(unsatisfied));
            }
            return PDECore.getFormattedMessage("ECLIPSE_MISSING_REQUIRED_BUNDLE", TargetPlatformRegistryLoader.toString(unsatisfied));
        }
        return PDECore.getFormattedMessage("ECLIPSE_MISSING_HOST", TargetPlatformRegistryLoader.toString(unsatisfied));
    }

    private static String toString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null || versionRange.getMinimum() != null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionRange;
    }

    public static IPluginModelBase[] loadModels(URL[] urls, boolean resolve, IProgressMonitor monitor) {
        PDEState state = new PDEState();
        return TargetPlatformRegistryLoader.loadModels(urls, resolve, state, monitor);
    }

    private static IPluginModelBase createModelFromDescription(BundleDescription description, PDEState state) {
        ExternalPluginModelBase model = null;
        model = description.getHost() == null ? new ExternalPluginModel() : new ExternalFragmentModel();
        model.load(description, state);
        return model;
    }

    private static StateHelper acquireStateHelper() {
        return PDECore.getDefault().acquirePlatform().getStateHelper();
    }
}

