/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;

public class StubUtility {
    private static final String[] EMPTY = new String[0];
    private static final List BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");

    public static String genStub(ICompilationUnit cu, String destTypeName, IMethod method, IType definingType, GenStubSettings settings, IImportsStructure imports) throws CoreException {
        int flags;
        String methName = method.getElementName();
        String[] paramNames = StubUtility.suggestArgumentNames(method.getJavaProject(), method.getParameterNames());
        String returnType = method.isConstructor() ? null : method.getReturnType();
        String lineDelimiter = String.valueOf('\n');
        StringBuffer buf = new StringBuffer();
        if (settings.createComments && cu != null) {
            String comment;
            IMethod overridden = null;
            if (settings.methodOverwrites && returnType != null) {
                overridden = JavaModelUtil.findMethod(methName, method.getParameterTypes(), false, definingType.getMethods());
            }
            if ((comment = StubUtility.getMethodComment(cu, destTypeName, methName, paramNames, method.getExceptionTypes(), returnType, overridden, lineDelimiter)) != null) {
                buf.append(comment);
            } else {
                buf.append("/**").append(lineDelimiter);
                buf.append(" *").append(lineDelimiter);
                buf.append(" */").append(lineDelimiter);
            }
            buf.append(lineDelimiter);
        }
        String bodyContent = null;
        if (!settings.noBody) {
            String bodyStatement = StubUtility.getDefaultMethodBodyStatement(methName, paramNames, returnType, settings.callSuper);
            bodyContent = StubUtility.getMethodBodyContent(returnType == null, method.getJavaProject(), destTypeName, methName, bodyStatement, lineDelimiter);
            if (bodyContent == null) {
                bodyContent = "";
            }
        }
        if ((flags = settings.methodModifiers) == -1) {
            flags = method.getFlags();
        }
        StubUtility.genMethodDeclaration(destTypeName, method, flags, bodyContent, imports, buf);
        return buf.toString();
    }

    public static void genMethodDeclaration(String destTypeName, IMethod method, String bodyContent, IImportsStructure imports, StringBuffer buf) throws CoreException {
        StubUtility.genMethodDeclaration(destTypeName, method, method.getFlags(), bodyContent, imports, buf);
    }

    public static void genMethodDeclaration(String destTypeName, IMethod method, int flags, String bodyContent, IImportsStructure imports, StringBuffer buf) throws CoreException {
        IType parentType = method.getDeclaringType();
        String methodName = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        String[] paramNames = StubUtility.suggestArgumentNames(parentType.getJavaProject(), method.getParameterNames());
        String[] excTypes = method.getExceptionTypes();
        boolean isConstructor = method.isConstructor();
        String retTypeSig = isConstructor ? null : method.getReturnType();
        int lastParam = paramTypes.length - 1;
        if (Flags.isPublic((int)flags) || parentType.isInterface() && bodyContent != null) {
            buf.append("public ");
        } else if (Flags.isProtected((int)flags)) {
            buf.append("protected ");
        } else if (Flags.isPrivate((int)flags)) {
            buf.append("private ");
        }
        if (Flags.isSynchronized((int)flags)) {
            buf.append("synchronized ");
        }
        if (Flags.isVolatile((int)flags)) {
            buf.append("volatile ");
        }
        if (Flags.isStrictfp((int)flags)) {
            buf.append("strictfp ");
        }
        if (Flags.isStatic((int)flags)) {
            buf.append("static ");
        }
        if (isConstructor) {
            buf.append(destTypeName);
        } else {
            String retTypeFrm = !StubUtility.isPrimitiveType(retTypeSig) ? StubUtility.resolveAndAdd(retTypeSig, parentType, imports) : Signature.toString((String)retTypeSig);
            buf.append(retTypeFrm);
            buf.append(' ');
            buf.append(methodName);
        }
        buf.append('(');
        int i = 0;
        while (i <= lastParam) {
            String paramTypeSig = paramTypes[i];
            String paramTypeFrm = !StubUtility.isPrimitiveType(paramTypeSig) ? StubUtility.resolveAndAdd(paramTypeSig, parentType, imports) : Signature.toString((String)paramTypeSig);
            buf.append(paramTypeFrm);
            buf.append(' ');
            buf.append(paramNames[i]);
            if (i < lastParam) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(')');
        int lastExc = excTypes.length - 1;
        if (lastExc >= 0) {
            buf.append(" throws ");
            int i2 = 0;
            while (i2 <= lastExc) {
                String excTypeSig = excTypes[i2];
                String excTypeFrm = StubUtility.resolveAndAdd(excTypeSig, parentType, imports);
                buf.append(excTypeFrm);
                if (i2 < lastExc) {
                    buf.append(", ");
                }
                ++i2;
            }
        }
        if (bodyContent == null) {
            buf.append(";\n\n");
        } else {
            buf.append(" {\n\t");
            if (bodyContent != null && bodyContent.length() > 0) {
                buf.append(bodyContent);
                buf.append('\n');
            }
            buf.append("}\n");
        }
    }

    public static String getDefaultMethodBodyStatement(String methodName, String[] paramNames, String retTypeSig, boolean callSuper) {
        StringBuffer buf = new StringBuffer();
        if (callSuper) {
            if (retTypeSig != null) {
                if (!"V".equals(retTypeSig)) {
                    buf.append("return ");
                }
                buf.append("super.");
                buf.append(methodName);
            } else {
                buf.append("super");
            }
            buf.append('(');
            int i = 0;
            while (i < paramNames.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(paramNames[i]);
                ++i;
            }
            buf.append(");");
        } else if (retTypeSig != null && !retTypeSig.equals("V")) {
            if (!StubUtility.isPrimitiveType(retTypeSig) || Signature.getArrayCount((String)retTypeSig) > 0) {
                buf.append("return null;");
            } else if (retTypeSig.equals("Z")) {
                buf.append("return false;");
            } else {
                buf.append("return 0;");
            }
        }
        return buf.toString();
    }

    public static String getMethodBodyContent(boolean isConstructor, IJavaProject project, String destTypeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateName = isConstructor ? "constructorbody" : "methodbody";
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("body_statement", bodyStatement);
        String str = StubUtility.evaluateTemplate(context, template);
        if (str == null && !Strings.containsOnlyWhitespaces(bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getGetterMethodBodyContent(IJavaProject project, String destTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        String templateName = "getterbody";
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterMethodBodyContent(IJavaProject project, String destTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        String templateName = "setterbody";
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCatchBodyContent(ICompilationUnit cu, String exceptionType, String variableName, String lineDelimiter) throws CoreException {
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate("catchblock");
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setVariable("exception_type", exceptionType);
        context.setVariable("exception_var", variableName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCompilationUnitContent(ICompilationUnit cu, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String packDecl = pack.isDefaultPackage() ? "" : "package " + pack.getElementName() + ';';
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate("newtype");
        if (template == null) {
            return null;
        }
        IJavaProject project = cu.getJavaProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("package_declaration", packDecl);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", Signature.getQualifier((String)cu.getElementName()));
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getTypeComment(ICompilationUnit cu, String typeQualifiedName, String lineDelim) throws CoreException {
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate("typecomment");
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelim);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", Signature.getQualifier((String)typeQualifiedName));
        context.setVariable("type_name", Signature.getSimpleName((String)typeQualifiedName));
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String[] getParameterTypesQualifiedNames(IMethodBinding binding) {
        ITypeBinding[] typeBindings = binding.getParameterTypes();
        String[] result = new String[typeBindings.length];
        int i = 0;
        while (i < result.length) {
            result[i] = typeBindings[i].getQualifiedName();
            ++i;
        }
        return result;
    }

    private static String getSeeTag(String declaringClassQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringClassQualifiedName);
        buf.append('#');
        buf.append(methodName);
        buf.append('(');
        int i = 0;
        while (i < parameterTypesQualifiedNames.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameterTypesQualifiedNames[i]);
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    private static String getSeeTag(IMethod overridden) throws JavaModelException {
        IType declaringType = overridden.getDeclaringType();
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringType.getFullyQualifiedName('.'));
        buf.append('#');
        buf.append(overridden.getElementName());
        buf.append('(');
        String[] paramTypes = overridden.getParameterTypes();
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                buf.append(", ");
            }
            String curr = paramTypes[i];
            buf.append(JavaModelUtil.getResolvedTypeName(curr, declaringType));
            int arrayCount = Signature.getArrayCount((String)curr);
            while (arrayCount > 0) {
                buf.append("[]");
                --arrayCount;
            }
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public static String getMethodComment(IMethod method, IMethod overridden, String lineDelimiter) throws CoreException {
        String retType = method.isConstructor() ? null : method.getReturnType();
        String[] paramNames = method.getParameterNames();
        return StubUtility.getMethodComment(method.getCompilationUnit(), method.getDeclaringType().getElementName(), method.getElementName(), paramNames, method.getExceptionTypes(), retType, overridden, lineDelimiter);
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, IMethod overridden, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "methodcomment";
        if (retTypeSig == null) {
            templateName = "constructorcomment";
        } else if (overridden != null) {
            templateName = "overridecomment";
        }
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", Signature.toString((String)retTypeSig));
        }
        if (overridden != null) {
            context.setVariable("see_to_overridden", StubUtility.getSeeTag(overridden));
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findTagVariable(buffer);
        if (position == null) {
            return str;
        }
        Document textBuffer = new Document(str);
        String[] exceptionNames = new String[excTypeSig.length];
        int i = 0;
        while (i < excTypeSig.length) {
            exceptionNames[i] = Signature.toString((String)excTypeSig[i]);
            ++i;
        }
        String returnType = retTypeSig != null ? Signature.toString((String)retTypeSig) : null;
        int[] tagOffsets = position.getOffsets();
        int i2 = tagOffsets.length - 1;
        while (i2 >= 0) {
            try {
                StubUtility.insertTag((IDocument)textBuffer, tagOffsets[i2], position.getLength(), paramNames, exceptionNames, returnType, false, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
            --i2;
        }
        return textBuffer.get();
    }

    public static String getFieldComment(ICompilationUnit cu, String typeName, String fieldName, String lineDelimiter) throws CoreException {
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate("fieldcomment");
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("field_type", typeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "settercomment";
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getGetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "gettercomment";
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, MethodDeclaration decl, IMethodBinding overridden, String lineDelimiter) throws CoreException {
        if (overridden != null) {
            String declaringClassQualifiedName = overridden.getDeclaringClass().getQualifiedName();
            String[] parameterTypesQualifiedNames = StubUtility.getParameterTypesQualifiedNames(overridden);
            return StubUtility.getMethodComment(cu, typeName, decl, true, overridden.isDeprecated(), declaringClassQualifiedName, parameterTypesQualifiedNames, lineDelimiter);
        }
        return StubUtility.getMethodComment(cu, typeName, decl, false, false, null, null, lineDelimiter);
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, MethodDeclaration decl, boolean isOverridden, boolean isDeprecated, String declaringClassQualifiedName, String[] parameterTypesQualifiedNames, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "methodcomment";
        if (decl.isConstructor()) {
            templateName = "constructorcomment";
        } else if (isOverridden) {
            templateName = "overridecomment";
        }
        Template template = JavaPlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", decl.getName().getIdentifier());
        if (!decl.isConstructor()) {
            context.setVariable("return_type", ASTNodes.asString((ASTNode)decl.getReturnType()));
        }
        if (isOverridden) {
            String methodName = decl.getName().getIdentifier();
            context.setVariable("see_to_overridden", StubUtility.getSeeTag(declaringClassQualifiedName, methodName, parameterTypesQualifiedNames));
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findTagVariable(buffer);
        if (position == null) {
            return str;
        }
        Document textBuffer = new Document(str);
        List params = decl.parameters();
        String[] paramNames = new String[params.size()];
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration elem = (SingleVariableDeclaration)params.get(i);
            paramNames[i] = elem.getName().getIdentifier();
            ++i;
        }
        List exceptions = decl.thrownExceptions();
        String[] exceptionNames = new String[exceptions.size()];
        int i2 = 0;
        while (i2 < exceptions.size()) {
            exceptionNames[i2] = ASTNodes.getSimpleNameIdentifier((Name)exceptions.get(i2));
            ++i2;
        }
        String returnType = !decl.isConstructor() ? ASTNodes.asString((ASTNode)decl.getReturnType()) : null;
        int[] tagOffsets = position.getOffsets();
        int i3 = tagOffsets.length - 1;
        while (i3 >= 0) {
            try {
                StubUtility.insertTag((IDocument)textBuffer, tagOffsets[i3], position.getLength(), paramNames, exceptionNames, returnType, isDeprecated, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
            --i3;
        }
        return textBuffer.get();
    }

    private static TemplateVariable findTagVariable(TemplateBuffer buffer) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if ("tags".equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, String[] paramNames, String[] exceptionNames, String returnType, boolean isDeprecated, String lineDelimiter) throws BadLocationException {
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paramNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@param ");
            buf.append(paramNames[i]);
            ++i;
        }
        if (returnType != null && !returnType.equals("void")) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@return");
        }
        if (exceptionNames != null) {
            i = 0;
            while (i < exceptionNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter);
                    buf.append(lineStart);
                }
                buf.append("@throws ");
                buf.append(exceptionNames[i]);
                ++i;
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@deprecated");
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isPrimitiveType(String typeName) {
        char first = Signature.getElementType((String)typeName).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static String resolveAndAdd(String refTypeSig, IType declaringType, IImportsStructure imports) throws JavaModelException {
        String resolvedTypeName = JavaModelUtil.getResolvedTypeName(refTypeSig, declaringType);
        if (resolvedTypeName != null) {
            StringBuffer buf = new StringBuffer();
            if (imports != null) {
                buf.append(imports.addImport(resolvedTypeName));
            } else {
                buf.append(resolvedTypeName);
            }
            int arrayCount = Signature.getArrayCount((String)refTypeSig);
            int i = 0;
            while (i < arrayCount) {
                buf.append("[]");
                ++i;
            }
            return buf.toString();
        }
        return Signature.toString((String)refTypeSig);
    }

    private static IMethod findMethod(IMethod method, List allMethods) throws JavaModelException {
        String name = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        boolean isConstructor = method.isConstructor();
        int i = allMethods.size() - 1;
        while (i >= 0) {
            IMethod curr = (IMethod)allMethods.get(i);
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, curr)) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static String[] evalConstructors(IType type, IType supertype, CodeGenerationSettings settings, IImportsStructure imports) throws CoreException {
        IMethod[] superMethods = supertype.getMethods();
        String typeName = type.getElementName();
        ICompilationUnit cu = type.getCompilationUnit();
        IMethod[] methods = type.getMethods();
        GenStubSettings genStubSettings = new GenStubSettings(settings);
        genStubSettings.callSuper = true;
        ArrayList<String> newMethods = new ArrayList<String>(superMethods.length);
        int i = 0;
        while (i < superMethods.length) {
            IMethod curr = superMethods[i];
            if (curr.isConstructor() && JavaModelUtil.isVisibleInHierarchy((IMember)curr, type.getPackageFragment()) && JavaModelUtil.findMethod(typeName, curr.getParameterTypes(), true, methods) == null) {
                genStubSettings.methodModifiers = 1 | JdtFlags.clearAccessModifiers(curr.getFlags());
                String newStub = StubUtility.genStub(cu, typeName, curr, curr.getDeclaringType(), genStubSettings, imports);
                newMethods.add(newStub);
            }
            ++i;
        }
        return newMethods.toArray(new String[newMethods.size()]);
    }

    public static IMethod[] getOverridableConstructors(IType type) throws CoreException {
        IType objectType;
        IMethod curr;
        ArrayList<IMethod> constructorMethods = new ArrayList<IMethod>();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType supertype = hierarchy.getSuperclass(type);
        if (supertype == null) {
            return new IMethod[0];
        }
        IMethod[] superMethods = supertype.getMethods();
        boolean constuctorFound = false;
        String typeName = type.getElementName();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < superMethods.length) {
            curr = superMethods[i];
            if (curr.isConstructor()) {
                constuctorFound = true;
                if (JavaModelUtil.isVisibleInHierarchy((IMember)curr, type.getPackageFragment()) && JavaModelUtil.findMethod(typeName, curr.getParameterTypes(), true, methods) == null) {
                    constructorMethods.add(curr);
                }
            }
            ++i;
        }
        if (!constuctorFound && JavaModelUtil.findMethod(typeName, (curr = (objectType = type.getJavaProject().findType("java.lang.Object")).getMethod("Object", EMPTY)).getParameterTypes(), true, methods) == null) {
            constructorMethods.add(curr);
        }
        return constructorMethods.toArray(new IMethod[constructorMethods.size()]);
    }

    public static IMethod[] getOverridableMethods(IType type, ITypeHierarchy hierarchy, boolean isSubType) throws JavaModelException {
        ArrayList<IMethod> allMethods = new ArrayList<IMethod>();
        IMethod[] typeMethods = type.getMethods();
        int i = 0;
        while (i < typeMethods.length) {
            IMethod curr = typeMethods[i];
            if (!(curr.isConstructor() || Flags.isStatic((int)curr.getFlags()) || Flags.isPrivate((int)curr.getFlags()))) {
                allMethods.add(curr);
            }
            ++i;
        }
        IType[] superTypes = hierarchy.getAllSuperclasses(type);
        int i2 = 0;
        while (i2 < superTypes.length) {
            IMethod[] methods = superTypes[i2].getMethods();
            int k = 0;
            while (k < methods.length) {
                IMethod curr = methods[k];
                if (!(curr.isConstructor() || Flags.isStatic((int)curr.getFlags()) || Flags.isPrivate((int)curr.getFlags()) || StubUtility.findMethod(curr, allMethods) != null)) {
                    allMethods.add(curr);
                }
                ++k;
            }
            ++i2;
        }
        IType[] superInterfaces = hierarchy.getAllSuperInterfaces(type);
        int i3 = 0;
        while (i3 < superInterfaces.length) {
            IMethod[] methods = superInterfaces[i3].getMethods();
            int k = 0;
            while (k < methods.length) {
                IMethod impl;
                IMethod curr = methods[k];
                if (!(Flags.isStatic((int)curr.getFlags()) || (impl = StubUtility.findMethod(curr, allMethods)) != null && JavaModelUtil.isVisibleInHierarchy((IMember)impl, type.getPackageFragment()) && !StubUtility.prefereInterfaceMethod(hierarchy, curr, impl))) {
                    if (impl != null) {
                        allMethods.remove(impl);
                    }
                    allMethods.add(curr);
                }
                ++k;
            }
            ++i3;
        }
        if (!isSubType) {
            allMethods.removeAll(Arrays.asList(typeMethods));
        }
        i3 = allMethods.size() - 1;
        while (i3 >= 0) {
            IMethod curr = (IMethod)allMethods.get(i3);
            if (Flags.isFinal((int)curr.getFlags())) {
                allMethods.remove(i3);
            }
            --i3;
        }
        return allMethods.toArray(new IMethod[allMethods.size()]);
    }

    private static boolean prefereInterfaceMethod(ITypeHierarchy hierarchy, IMethod interfaceMethod, IMethod curr) throws JavaModelException {
        if (Flags.isFinal((int)curr.getFlags())) {
            return false;
        }
        IType interfaceType = interfaceMethod.getDeclaringType();
        IType[] interfaces = hierarchy.getAllSuperInterfaces(curr.getDeclaringType());
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i] == interfaceType) {
                return false;
            }
            ++i;
        }
        return curr.getExceptionTypes().length > interfaceMethod.getExceptionTypes().length;
    }

    public static String[] genOverrideStubs(IMethod[] methodsToImplement, IType type, ITypeHierarchy hierarchy, CodeGenerationSettings settings, IImportsStructure imports) throws CoreException {
        GenStubSettings genStubSettings = new GenStubSettings(settings);
        genStubSettings.methodOverwrites = true;
        ICompilationUnit cu = type.getCompilationUnit();
        String[] result = new String[methodsToImplement.length];
        int i = 0;
        while (i < methodsToImplement.length) {
            IMethod curr = methodsToImplement[i];
            IMethod overrides = JavaModelUtil.findMethodImplementationInHierarchy(hierarchy, type, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
            if (overrides != null) {
                genStubSettings.callSuper = true;
                curr = overrides;
            }
            genStubSettings.methodModifiers = curr.getFlags();
            IMethod desc = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, type, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
            if (desc == null) {
                desc = curr;
            }
            result[i] = StubUtility.genStub(cu, type.getElementName(), curr, desc.getDeclaringType(), genStubSettings, imports);
            ++i;
        }
        return result;
    }

    public static String[] evalUnimplementedMethods(IType type, ITypeHierarchy hierarchy, boolean isSubType, CodeGenerationSettings settings, IImportsStructure imports) throws CoreException {
        IMethod[] inheritedMethods = StubUtility.getOverridableMethods(type, hierarchy, isSubType);
        ArrayList<IMethod> toImplement = new ArrayList<IMethod>();
        int i = 0;
        while (i < inheritedMethods.length) {
            IMethod curr = inheritedMethods[i];
            if (JdtFlags.isAbstract((IMember)curr)) {
                toImplement.add(curr);
            }
            ++i;
        }
        IMethod[] toImplementArray = toImplement.toArray(new IMethod[toImplement.size()]);
        return StubUtility.genOverrideStubs(toImplementArray, type, hierarchy, settings, imports);
    }

    public static String getLineDelimiterUsed(IJavaElement elem) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)elem.getAncestor(5);
        if (cu != null && cu.exists()) {
            IBuffer buf = cu.getBuffer();
            int length = buf.getLength();
            int i = 0;
            while (i < length) {
                char ch = buf.getChar(i);
                if (ch == '\r') {
                    if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                if (ch == '\n') {
                    return "\n";
                }
                ++i;
            }
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterFor(IDocument doc) {
        String lineDelim = null;
        try {
            lineDelim = doc.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelim == null) {
            String systemDelimiter = System.getProperty("line.separator", "\n");
            String[] lineDelims = doc.getLegalLineDelimiters();
            int i = 0;
            while (i < lineDelims.length) {
                if (lineDelims[i].equals(systemDelimiter)) {
                    lineDelim = systemDelimiter;
                    break;
                }
                ++i;
            }
            if (lineDelim == null) {
                lineDelim = lineDelims.length > 0 ? lineDelims[0] : systemDelimiter;
            }
        }
        return lineDelim;
    }

    public static int getIndentUsed(IJavaElement elem) throws JavaModelException {
        ICompilationUnit cu;
        if (elem instanceof ISourceReference && (cu = (ICompilationUnit)elem.getAncestor(5)) != null) {
            int offset;
            IBuffer buf = cu.getBuffer();
            int i = offset = ((ISourceReference)elem).getSourceRange().getOffset();
            while (i > 0 && !Strings.isLineDelimiterChar(buf.getChar(i - 1))) {
                --i;
            }
            return Strings.computeIndent(buf.getText(i, offset - i), CodeFormatterUtil.getTabWidth());
        }
        return 0;
    }

    public static IJavaElement findNextSibling(IJavaElement member) throws JavaModelException {
        IJavaElement parent = member.getParent();
        if (parent instanceof IParent) {
            IJavaElement[] elements = ((IParent)parent).getChildren();
            int i = elements.length - 2;
            while (i >= 0) {
                if (member.equals(elements[i])) {
                    return elements[i + 1];
                }
                --i;
            }
        }
        return null;
    }

    public static String getTodoTaskTag(IJavaProject project) {
        String markers = null;
        markers = project == null ? JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.taskTags") : project.getOption("org.eclipse.jdt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    public static String[] getArgumentNameSuggestions(IJavaProject project, String baseName, int dimensions, String[] excluded) {
        String name = StubUtility.workaround38111(baseName);
        String[] res = NamingConventions.suggestArgumentNames((IJavaProject)project, (String)"", (String)name, (int)dimensions, (String[])excluded);
        return StubUtility.sortByLength(res);
    }

    public static String[] getFieldNameSuggestions(IJavaProject project, String baseName, int dimensions, int modifiers, String[] excluded) {
        String name = StubUtility.workaround38111(baseName);
        String[] res = NamingConventions.suggestFieldNames((IJavaProject)project, (String)"", (String)name, (int)dimensions, (int)modifiers, (String[])excluded);
        return StubUtility.sortByLength(res);
    }

    public static String[] getLocalNameSuggestions(IJavaProject project, String baseName, int dimensions, String[] excluded) {
        String name = StubUtility.workaround38111(baseName);
        String[] res = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)"", (String)name, (int)dimensions, (String[])excluded);
        return StubUtility.sortByLength(res);
    }

    private static String[] sortByLength(String[] proposals) {
        Arrays.sort(proposals, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o2).length() - ((String)o1).length();
            }
        });
        return proposals;
    }

    private static String workaround38111(String baseName) {
        if (BASE_TYPES.contains(baseName)) {
            return baseName;
        }
        return String.valueOf(Character.toUpperCase(baseName.charAt(0))) + baseName.substring(1);
    }

    public static String suggestArgumentName(IJavaProject project, String baseName, String[] excluded) {
        String[] argnames = StubUtility.getArgumentNameSuggestions(project, baseName, 0, excluded);
        if (argnames.length > 0) {
            return argnames[0];
        }
        return baseName;
    }

    public static String[] suggestArgumentNames(IJavaProject project, String[] paramNames) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentSuffixes", true);
        if (prefixes.length() + suffixes.length() == 0) {
            return paramNames;
        }
        String[] newNames = new String[paramNames.length];
        int i = 0;
        while (i < paramNames.length) {
            String curr = paramNames[i];
            newNames[i] = !StubUtility.hasPrefixOrSuffix(prefixes, suffixes, curr) ? StubUtility.suggestArgumentName(project, paramNames[i], null) : curr;
            ++i;
        }
        return newNames;
    }

    public static boolean hasFieldName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.fieldSuffixes", true);
        String staticPrefixes = project.getOption("org.eclipse.jdt.core.codeComplete.staticFieldPrefixes", true);
        String staticSuffixes = project.getOption("org.eclipse.jdt.core.codeComplete.staticFieldSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name) || StubUtility.hasPrefixOrSuffix(staticPrefixes, staticSuffixes, name);
    }

    public static boolean hasParameterName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasLocalVariableName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.localPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.localSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasConstantName(String name) {
        return Character.isUpperCase(name.charAt(0));
    }

    private static boolean hasPrefixOrSuffix(String prefixes, String suffixes, String name) {
        String curr;
        StringTokenizer tok = new StringTokenizer(prefixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.startsWith(curr)) continue;
            return true;
        }
        tok = new StringTokenizer(suffixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.endsWith(curr)) continue;
            return true;
        }
        return false;
    }

    public static class GenStubSettings
    extends CodeGenerationSettings {
        public boolean callSuper;
        public boolean methodOverwrites;
        public boolean noBody;
        public int methodModifiers;

        public GenStubSettings(CodeGenerationSettings settings) {
            settings.setSettings(this);
            this.methodModifiers = -1;
        }
    }
}

