/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.ltk.core.refactoring.Change;

abstract class CompilationUnitReorgChange
extends JDTChange {
    private String fCuHandle;
    private String fOldPackageHandle;
    private String fNewPackageHandle;
    private INewNameQuery fNewNameQuery;

    CompilationUnitReorgChange(ICompilationUnit cu, IPackageFragment dest, INewNameQuery newNameQuery) {
        this.fCuHandle = cu.getHandleIdentifier();
        this.fNewPackageHandle = dest.getHandleIdentifier();
        this.fNewNameQuery = newNameQuery;
        this.fOldPackageHandle = cu.getParent().getHandleIdentifier();
    }

    CompilationUnitReorgChange(ICompilationUnit cu, IPackageFragment dest) {
        this(cu, dest, null);
    }

    CompilationUnitReorgChange(String oldPackageHandle, String newPackageHandle, String cuHandle) {
        this.fOldPackageHandle = oldPackageHandle;
        this.fNewPackageHandle = newPackageHandle;
        this.fCuHandle = cuHandle;
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        pm.beginTask(this.getName(), 1);
        try {
            change = this.doPerformReorg((IProgressMonitor)new SubProgressMonitor(pm, 1));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws JavaModelException;

    public Object getModifiedElement() {
        return this.getCu();
    }

    ICompilationUnit getCu() {
        return (ICompilationUnit)JavaCore.create((String)this.fCuHandle);
    }

    IPackageFragment getOldPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fOldPackageHandle);
    }

    IPackageFragment getDestinationPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fNewPackageHandle);
    }

    String getNewName() {
        if (this.fNewNameQuery == null) {
            return null;
        }
        return this.fNewNameQuery.getNewName();
    }

    static String getPackageName(IPackageFragment pack) {
        if (pack.isDefaultPackage()) {
            return RefactoringCoreMessages.getString("MoveCompilationUnitChange.default_package");
        }
        return pack.getElementName();
    }
}

