/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class RenameVirtualMethodProcessor
extends RenameMethodProcessor {
    private IMethod fOriginalMethod = this.getMethod();
    private boolean fActivationChecked;

    public RenameVirtualMethodProcessor(IMethod method) {
        super(method);
    }

    public IMethod getOriginalMethod() {
        return this.fOriginalMethod;
    }

    public boolean isApplicable() throws CoreException {
        return super.isApplicable() && MethodChecks.isVirtual(this.getMethod());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = super.checkInitialConditions(pm);
        if (result.hasFatalError()) {
            return result;
        }
        if (!this.fActivationChecked) {
            IMethod inInterface;
            IMethod method;
            this.fActivationChecked = true;
            this.fOriginalMethod = method = this.getMethod();
            if (!method.getDeclaringType().isInterface() && (inInterface = MethodChecks.isDeclaredInInterface(method, (IProgressMonitor)new NullProgressMonitor())) != null && !inInterface.equals(method)) {
                this.initialize(inInterface);
                return result;
            }
            IMethod overrides = MethodChecks.overridesAnotherMethod(method, (IProgressMonitor)new NullProgressMonitor());
            if (overrides != null && !overrides.equals(method)) {
                this.initialize(overrides);
                return result;
            }
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus result;
        block11: {
            pm.beginTask("", 12);
            result = new RefactoringStatus();
            result.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), checkContext));
            if (!result.hasFatalError()) break block11;
            RefactoringStatus refactoringStatus2 = result;
            Object var8_6 = null;
            pm.done();
            return refactoringStatus2;
        }
        try {
            if (this.getMethod().getDeclaringType().isInterface()) {
                if (this.isSpecialCase()) {
                    result.addError(RefactoringCoreMessages.getString("RenameMethodInInterfaceRefactoring.special_case"));
                }
                pm.worked(1);
                IMethod[] relatedMethods = this.relatedTypeDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 4), this.getMethod(), this.getNewElementName());
                int i = 0;
                while (i < relatedMethods.length) {
                    IMethod relatedMethod = relatedMethods[i];
                    RefactoringStatusContext context = JavaStatusContext.create((IMember)relatedMethod);
                    result.addError(RefactoringCoreMessages.getString("RenameMethodInInterfaceRefactoring.already_defined"), context);
                    ++i;
                }
            } else {
                if (this.hierarchyDeclaresSimilarNativeMethod((IProgressMonitor)new SubProgressMonitor(pm, 2))) {
                    result.addError(RefactoringCoreMessages.getFormattedString("RenameVirtualMethodRefactoring.requieres_renaming_native", new String[]{this.getMethod().getElementName(), "UnsatisfiedLinkError"}));
                }
                IMethod[] hierarchyMethods = RenameMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 2), this.getMethod(), this.getNewElementName());
                int i = 0;
                while (i < hierarchyMethods.length) {
                    IMethod hierarchyMethod = hierarchyMethods[i];
                    RefactoringStatusContext context = JavaStatusContext.create((IMember)hierarchyMethod);
                    if (Checks.compareParamTypes(this.getMethod().getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                        result.addError(RefactoringCoreMessages.getFormattedString("RenameVirtualMethodRefactoring.hierarchy_declares2", this.getNewElementName()), context);
                    } else {
                        result.addWarning(RefactoringCoreMessages.getFormattedString("RenameVirtualMethodRefactoring.hierarchy_declares1", this.getNewElementName()), context);
                    }
                    ++i;
                }
            }
            refactoringStatus = result;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private IMethod[] relatedTypeDeclaresMethodName(IProgressMonitor pm, IMethod method, String newName) throws CoreException {
        IMethod[] iMethodArray;
        try {
            HashSet<IMethod> result = new HashSet<IMethod>();
            Set types = this.getRelatedTypes();
            pm.beginTask("", types.size());
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                IMethod m = Checks.findMethod(method, (IType)iter.next());
                IMethod[] hierarchyMethod = RenameMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), m, newName);
                result.addAll(Arrays.asList(hierarchyMethod));
            }
            iMethodArray = result.toArray(new IMethod[result.size()]);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iMethodArray;
    }

    private boolean isSpecialCase() throws CoreException {
        String[] noParams = new String[]{};
        String[] specialNames = new String[]{"toString", "toString", "toString", "toString", "equals", "equals", "getClass", "getClass", "hashCode", "notify", "notifyAll", "wait", "wait", "wait"};
        String[][] specialParamTypes = new String[][]{noParams, noParams, noParams, noParams, {"QObject;"}, {"Qjava.lang.Object;"}, noParams, noParams, noParams, noParams, noParams, {"J", "I"}, {"J"}, noParams};
        String[] specialReturnTypes = new String[]{"QString;", "QString;", "Qjava.lang.String;", "Qjava.lang.String;", "Z", "Z", "QClass;", "Qjava.lang.Class;", "I", "V", "V", "V", "V", "V"};
        Assert.isTrue(specialNames.length == specialParamTypes.length && specialParamTypes.length == specialReturnTypes.length);
        int i = 0;
        while (i < specialNames.length) {
            if (specialNames[i].equals(this.getNewElementName()) && Checks.compareParamTypes(this.getMethod().getParameterTypes(), specialParamTypes[i]) && !specialReturnTypes[i].equals(this.getMethod().getReturnType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Set getRelatedTypes() {
        Set methods = this.getMethodsToRename();
        HashSet<IType> result = new HashSet<IType>(methods.size());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            result.add(((IMethod)iter.next()).getDeclaringType());
        }
        return result;
    }

    private boolean hierarchyDeclaresSimilarNativeMethod(IProgressMonitor pm) throws CoreException {
        IType[] classes = this.getMethod().getDeclaringType().newTypeHierarchy(pm).getAllSubtypes(this.getMethod().getDeclaringType());
        return this.classesDeclareOverridingNativeMethod(classes);
    }

    private boolean classesDeclareOverridingNativeMethod(IType[] classes) throws CoreException {
        int i = 0;
        while (i < classes.length) {
            IMethod[] methods = classes[i].getMethods();
            int j = 0;
            while (j < methods.length) {
                if (!methods[j].equals(this.getMethod()) && JdtFlags.isNative((IMember)methods[j]) && Checks.findSimilarMethod(this.getMethod(), new IMethod[]{methods[j]}) != null) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

