/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.util.ViewerPane;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.ContainerCheckedTreeViewer;

public class OverrideMethodDialog
extends SourceActionDialog {
    public OverrideMethodDialog(Shell parent, CompilationUnitEditor editor, IType type, boolean isSubType) throws JavaModelException {
        super(parent, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), new OverrideMethodContentProvider(), editor, type, false);
        this.init(type, isSubType);
    }

    public boolean hasMethodsToOverride() {
        return this.getContentProvider().getElements(null).length > 0;
    }

    private void init(IType type, boolean isSubType) throws JavaModelException {
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
        IMethod[] inheritedMethods = StubUtility.getOverridableMethods(type, typeHierarchy, isSubType);
        ArrayList<IMethod> toImplement = new ArrayList<IMethod>();
        int i = 0;
        while (i < inheritedMethods.length) {
            IMethod curr = inheritedMethods[i];
            if (JdtFlags.isAbstract((IMember)curr)) {
                toImplement.add(curr);
            }
            ++i;
        }
        Object[] toImplementArray = toImplement.toArray(new IMethod[toImplement.size()]);
        this.setInitialSelections(toImplementArray);
        HashSet<Object> expanded = new HashSet<Object>(toImplementArray.length);
        int i2 = 0;
        while (i2 < toImplementArray.length) {
            expanded.add(toImplementArray[i2].getDeclaringType());
            ++i2;
        }
        HashSet<IType> types = new HashSet<IType>(inheritedMethods.length);
        int i3 = 0;
        while (i3 < inheritedMethods.length) {
            types.add(inheritedMethods[i3].getDeclaringType());
            ++i3;
        }
        Object[] typesArrays = types.toArray(new IType[types.size()]);
        OverrideMethodSorter sorter = new OverrideMethodSorter(typeHierarchy);
        if (expanded.isEmpty() && typesArrays.length > 0) {
            sorter.sort(null, typesArrays);
            expanded.add(typesArrays[0]);
        }
        this.setExpandedElements(expanded.toArray());
        ITreeContentProvider contentProvider = this.getContentProvider();
        ((OverrideMethodContentProvider)contentProvider).init(inheritedMethods, (IType[])typesArrays);
        this.setTitle(JavaUIMessages.getString("OverrideMethodDialog.dialog.title"));
        this.setMessage(null);
        this.setValidator(new OverrideMethodValidator(inheritedMethods.length));
        this.setSorter(sorter);
        this.setContainerMode(true);
        this.setSize(60, 18);
        this.setInput(new Object());
    }

    protected CheckboxTreeViewer createTreeViewer(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        ViewerPane pane = new ViewerPane(composite, 0x800800);
        pane.setText(JavaUIMessages.getString("OverrideMethodDialog.dialog.description"));
        CheckboxTreeViewer treeViewer = super.createTreeViewer((Composite)pane);
        pane.setContent(treeViewer.getControl());
        GridLayout paneLayout = new GridLayout();
        paneLayout.marginHeight = 0;
        paneLayout.marginWidth = 0;
        paneLayout.numColumns = 1;
        pane.setLayout((Layout)paneLayout);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        pane.setLayoutData(gd);
        ToolBarManager tbm = pane.getToolBarManager();
        tbm.add((IAction)new OverrideFlatTreeAction());
        tbm.update(true);
        treeViewer.getTree().setFocus();
        return treeViewer;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.override_tree_selection_dialog_context");
    }

    private class OverrideFlatTreeAction
    extends Action {
        private boolean fToggle;

        public OverrideFlatTreeAction() {
            this.setToolTipText(JavaUIMessages.getString("OverrideMethodDialog.groupMethodsByTypes"));
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "impl_co.gif");
            this.fToggle = this.getOverrideContentProvider().isShowTypes();
            this.setChecked(this.fToggle);
        }

        public void run() {
            Object[] elementList = this.getOverrideContentProvider().getViewer().getCheckedElements();
            this.fToggle = !this.fToggle;
            this.setChecked(this.fToggle);
            this.getOverrideContentProvider().setShowTypes(this.fToggle);
            this.getOverrideContentProvider().getViewer().setCheckedElements(elementList);
        }

        private OverrideMethodContentProvider getOverrideContentProvider() {
            return (OverrideMethodContentProvider)OverrideMethodDialog.this.getContentProvider();
        }
    }

    private static class OverrideMethodContentProvider
    implements ITreeContentProvider {
        private final String SETTINGS_SECTION = "OverrideMethodDialog";
        private final String SETTINGS_SHOWTYPES = "showtypes";
        private Object[] fTypes;
        private IMethod[] fMethods;
        private final Object[] fEmpty = new Object[0];
        private boolean fShowTypes;
        private ContainerCheckedTreeViewer fViewer;
        private IDialogSettings fSettings;

        public ContainerCheckedTreeViewer getViewer() {
            return this.fViewer;
        }

        public OverrideMethodContentProvider() {
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fSettings = dialogSettings.getSection("OverrideMethodDialog");
            if (this.fSettings == null) {
                this.fSettings = dialogSettings.addNewSection("OverrideMethodDialog");
                this.fSettings.put("showtypes", true);
            }
            this.fShowTypes = this.fSettings.getBoolean("showtypes");
        }

        public void init(IMethod[] methods, IType[] types) {
            this.fMethods = methods;
            this.fTypes = types;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IType) {
                ArrayList<IMethod> result = new ArrayList<IMethod>(this.fMethods.length);
                int i = 0;
                while (i < this.fMethods.length) {
                    if (this.fMethods[i].getDeclaringType().equals(parentElement)) {
                        result.add(this.fMethods[i]);
                    }
                    ++i;
                }
                return result.toArray();
            }
            return this.fEmpty;
        }

        public Object getParent(Object element) {
            if (element instanceof IMethod) {
                return ((IMethod)element).getDeclaringType();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fShowTypes ? this.fTypes : this.fMethods;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = (ContainerCheckedTreeViewer)viewer;
        }

        public boolean isShowTypes() {
            return this.fShowTypes;
        }

        public void setShowTypes(boolean showTypes) {
            if (this.fShowTypes != showTypes) {
                this.fShowTypes = showTypes;
                this.fSettings.put("showtypes", showTypes);
                if (this.fViewer != null) {
                    this.fViewer.refresh();
                }
            }
        }
    }

    private static class OverrideMethodSorter
    extends ViewerSorter {
        private IType[] fAllTypes;

        public OverrideMethodSorter(ITypeHierarchy typeHierarchy) {
            IType curr = typeHierarchy.getType();
            IType[] superTypes = typeHierarchy.getAllSupertypes(curr);
            this.fAllTypes = new IType[superTypes.length + 1];
            this.fAllTypes[0] = curr;
            System.arraycopy(superTypes, 0, this.fAllTypes, 1, superTypes.length);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IType && e2 instanceof IType) {
                if (e1.equals(e2)) {
                    return 0;
                }
                int i = 0;
                while (i < this.fAllTypes.length) {
                    IType curr = this.fAllTypes[i];
                    if (curr.equals(e1)) {
                        return -1;
                    }
                    if (curr.equals(e2)) {
                        return 1;
                    }
                    ++i;
                }
                return 0;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private static class OverrideMethodValidator
    implements ISelectionStatusValidator {
        private static int fNumMethods;

        public OverrideMethodValidator(int entries) {
            fNumMethods = entries;
        }

        public IStatus validate(Object[] selection) {
            int count = 0;
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IMethod) {
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                return new StatusInfo(4, "");
            }
            String[] args = new String[]{String.valueOf(count), String.valueOf(fNumMethods)};
            String message = JavaUIMessages.getFormattedString("OverrideMethodDialog.selectioninfo.more", args);
            return new StatusInfo(1, message);
        }
    }
}

