/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.JARFileSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.VariablePathDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SourceAttachmentBlock {
    private IStatusChangeListener fContext;
    private StringButtonDialogField fFileNameField;
    private SelectionButtonDialogField fWorkspaceButton;
    private SelectionButtonDialogField fExternalFolderButton;
    private IStatus fNameStatus;
    private IPath fFileVariablePath;
    private IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTWidget;
    private CLabel fFullPathResolvedLabel;
    private IJavaProject fProject;
    private IClasspathEntry fEntry;
    private IPath fContainerPath;

    public SourceAttachmentBlock(IStatusChangeListener context, IClasspathEntry entry) {
        Assert.isNotNull(entry);
        this.fContext = context;
        this.fEntry = entry;
        int kind = entry.getEntryKind();
        Assert.isTrue(kind == 1 || kind == 4);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fNameStatus = new StatusInfo();
        SourceAttachmentAdapter adapter = new SourceAttachmentAdapter();
        if (this.isVariableEntry()) {
            this.fFileNameField = new VariablePathDialogField(adapter);
            this.fFileNameField.setDialogFieldListener(adapter);
            this.fFileNameField.setLabelText(NewWizardMessages.getString("SourceAttachmentBlock.filename.varlabel"));
            this.fFileNameField.setButtonLabel(NewWizardMessages.getString("SourceAttachmentBlock.filename.external.varbutton"));
            ((VariablePathDialogField)this.fFileNameField).setVariableButtonLabel(NewWizardMessages.getString("SourceAttachmentBlock.filename.variable.button"));
        } else {
            this.fFileNameField = new StringButtonDialogField(adapter);
            this.fFileNameField.setDialogFieldListener(adapter);
            this.fFileNameField.setLabelText(NewWizardMessages.getString("SourceAttachmentBlock.filename.label"));
            this.fFileNameField.setButtonLabel(NewWizardMessages.getString("SourceAttachmentBlock.filename.externalfile.button"));
            this.fWorkspaceButton = new SelectionButtonDialogField(8);
            this.fWorkspaceButton.setDialogFieldListener(adapter);
            this.fWorkspaceButton.setLabelText(NewWizardMessages.getString("SourceAttachmentBlock.filename.internal.button"));
            this.fExternalFolderButton = new SelectionButtonDialogField(8);
            this.fExternalFolderButton.setDialogFieldListener(adapter);
            this.fExternalFolderButton.setLabelText(NewWizardMessages.getString("SourceAttachmentBlock.filename.externalfolder.button"));
        }
        this.setDefaults();
    }

    public SourceAttachmentBlock(IStatusChangeListener context, IClasspathEntry entry, IPath containerPath, IJavaProject project) {
        this(context, entry);
        this.fContainerPath = containerPath;
        this.fProject = project;
    }

    public void setDefaults() {
        if (this.fEntry.getSourceAttachmentPath() != null) {
            this.fFileNameField.setText(this.fEntry.getSourceAttachmentPath().toString());
        } else {
            this.fFileNameField.setText("");
        }
    }

    private boolean isVariableEntry() {
        return this.fEntry.getEntryKind() == 4;
    }

    public IPath getSourceAttachmentPath() {
        if (this.fFileNameField.getText().length() == 0) {
            return null;
        }
        return new Path(this.fFileNameField.getText());
    }

    public IPath getSourceAttachmentRootPath() {
        return null;
    }

    public IClasspathEntry getNewEntry() {
        boolean isExported = this.fEntry.isExported();
        IClasspathEntry newEntry = this.fEntry.getEntryKind() == 4 ? JavaCore.newVariableEntry((IPath)this.fEntry.getPath(), (IPath)this.getSourceAttachmentPath(), (IPath)this.getSourceAttachmentRootPath(), (boolean)isExported) : JavaCore.newLibraryEntry((IPath)this.fEntry.getPath(), (IPath)this.getSourceAttachmentPath(), (IPath)this.getSourceAttachmentRootPath(), (boolean)isExported);
        return newEntry;
    }

    public Control createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        if (this.isVariableEntry()) {
            int widthHint = converter.convertWidthInCharsToPixels(50);
            GridData gd = new GridData(256);
            gd.horizontalSpan = 4;
            Label message = new Label(composite, 16384);
            message.setLayoutData((Object)gd);
            message.setText(NewWizardMessages.getFormattedString("SourceAttachmentBlock.message", this.fEntry.getPath().lastSegment()));
            DialogField.createEmptySpace(composite, 1);
            gd = new GridData(256);
            gd.widthHint = widthHint;
            gd.horizontalSpan = 2;
            Label desc = new Label(composite, 16448);
            desc.setText(NewWizardMessages.getString("SourceAttachmentBlock.filename.description"));
            desc.setLayoutData((Object)gd);
            DialogField.createEmptySpace(composite, 1);
            this.fFileNameField.doFillIntoGrid(composite, 4);
            LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), widthHint);
            DialogField.createEmptySpace(composite, 1);
            this.fFullPathResolvedLabel = new CLabel(composite, 16384);
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString(this.fFileNameField.getText(), true));
            this.fFullPathResolvedLabel.setLayoutData((Object)new GridData(256));
            DialogField.createEmptySpace(composite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        } else {
            int widthHint = converter.convertWidthInCharsToPixels(60);
            GridData gd = new GridData(256);
            gd.horizontalSpan = 3;
            Label message = new Label(composite, 16384);
            message.setLayoutData((Object)gd);
            message.setText(NewWizardMessages.getFormattedString("SourceAttachmentBlock.message", this.fEntry.getPath().lastSegment()));
            this.fWorkspaceButton.doFillIntoGrid(composite, 1);
            this.fFileNameField.doFillIntoGrid(composite, 4);
            LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), widthHint);
            LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
            DialogField.createEmptySpace(composite, 3);
            this.fExternalFolderButton.doFillIntoGrid(composite, 1);
        }
        this.fFileNameField.postSetFocusOnDialogField(parent.getDisplay());
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.source_attachment_context");
        return composite;
    }

    private void attachmentChangeControlPressed(DialogField field) {
        if (field == this.fFileNameField) {
            IPath jarFilePath;
            IPath iPath = jarFilePath = this.isVariableEntry() ? this.chooseExtension() : this.chooseExtJarFile();
            if (jarFilePath != null) {
                this.fFileNameField.setText(jarFilePath.toString());
            }
        }
    }

    private void attachmentDialogFieldChanged(DialogField field) {
        if (field == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        } else {
            if (field == this.fWorkspaceButton) {
                IPath jarFilePath = this.chooseInternal();
                if (jarFilePath != null) {
                    this.fFileNameField.setText(jarFilePath.toString());
                }
                return;
            }
            if (field == this.fExternalFolderButton) {
                IPath folderPath = this.chooseExtFolder();
                if (folderPath != null) {
                    this.fFileNameField.setText(folderPath.toString());
                }
                return;
            }
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString(this.fFileNameField.getText(), true));
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fNameStatus});
        this.fContext.statusChanged(status);
    }

    private boolean canBrowseFileName() {
        if (!this.isVariableEntry()) {
            return true;
        }
        if (this.fFileVariablePath != null) {
            return this.fFileVariablePath.toFile().isDirectory();
        }
        return false;
    }

    private String getResolvedLabelString(String path, boolean osPath) {
        IPath resolvedPath = this.getResolvedPath((IPath)new Path(path));
        if (resolvedPath != null) {
            if (osPath) {
                return resolvedPath.toOSString();
            }
            return resolvedPath.toString();
        }
        return "";
    }

    private IPath getResolvedPath(IPath path) {
        IPath varPath;
        String varName;
        if (path != null && (varName = path.segment(0)) != null && (varPath = JavaCore.getClasspathVariable((String)varName)) != null) {
            return varPath.append(path.removeFirstSegments(1));
        }
        return null;
    }

    private IStatus updateFileNameStatus() {
        StatusInfo status = new StatusInfo();
        this.fFileVariablePath = null;
        String fileName = this.fFileNameField.getText();
        if (fileName.length() == 0) {
            return status;
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            status.setError(NewWizardMessages.getString("SourceAttachmentBlock.filename.error.notvalid"));
            return status;
        }
        Path filePath = new Path(fileName);
        if (this.isVariableEntry()) {
            if (filePath.getDevice() != null) {
                status.setError(NewWizardMessages.getString("SourceAttachmentBlock.filename.error.deviceinpath"));
                return status;
            }
            String varName = filePath.segment(0);
            if (varName == null) {
                status.setError(NewWizardMessages.getString("SourceAttachmentBlock.filename.error.notvalid"));
                return status;
            }
            this.fFileVariablePath = JavaCore.getClasspathVariable((String)varName);
            if (this.fFileVariablePath == null) {
                status.setError(NewWizardMessages.getString("SourceAttachmentBlock.filename.error.varnotexists"));
                return status;
            }
            IPath resolvedPath = this.fFileVariablePath.append(filePath.removeFirstSegments(1));
            if (resolvedPath.isEmpty()) {
                status.setWarning(NewWizardMessages.getString("SourceAttachmentBlock.filename.warning.varempty"));
                return status;
            }
            File file = resolvedPath.toFile();
            if (!file.exists()) {
                String message = NewWizardMessages.getFormattedString("SourceAttachmentBlock.filename.error.filenotexists", resolvedPath.toOSString());
                status.setWarning(message);
                return status;
            }
            if (!resolvedPath.isAbsolute()) {
                String message = NewWizardMessages.getFormattedString("SourceAttachmentBlock.filename.error.notabsolute", filePath.toString());
                status.setError(message);
                return status;
            }
        } else {
            File file = filePath.toFile();
            IResource res = this.fWorkspaceRoot.findMember((IPath)filePath);
            if (res != null && res.getLocation() != null) {
                file = res.getLocation().toFile();
            }
            if (!file.exists()) {
                String message = NewWizardMessages.getFormattedString("SourceAttachmentBlock.filename.error.filenotexists", filePath.toString());
                status.setError(message);
                return status;
            }
            if (res == null && !filePath.isAbsolute()) {
                String message = NewWizardMessages.getFormattedString("SourceAttachmentBlock.filename.error.notabsolute", filePath.toString());
                status.setError(message);
                return status;
            }
        }
        return status;
    }

    private IPath chooseExtension() {
        IPath resolvedPath;
        Path currPath = new Path(this.fFileNameField.getText());
        if (currPath.isEmpty()) {
            currPath = this.fEntry.getPath();
        }
        File initialSelection = (resolvedPath = this.getResolvedPath((IPath)currPath)) != null ? resolvedPath.toFile() : null;
        String currVariable = currPath.segment(0);
        JARFileSelectionDialog dialog = new JARFileSelectionDialog(this.getShell(), false, true);
        dialog.setTitle(NewWizardMessages.getString("SourceAttachmentBlock.extvardialog.title"));
        dialog.setMessage(NewWizardMessages.getString("SourceAttachmentBlock.extvardialog.description"));
        dialog.setInput(this.fFileVariablePath.toFile());
        dialog.setInitialSelection(initialSelection);
        if (dialog.open() == 0) {
            File result = (File)dialog.getResult()[0];
            IPath returnPath = new Path(result.getPath()).makeAbsolute();
            return this.modifyPath(returnPath, currVariable);
        }
        return null;
    }

    private IPath chooseExtJarFile() {
        Path currPath = new Path(this.fFileNameField.getText());
        if (currPath.isEmpty()) {
            currPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath((IPath)currPath)) {
            currPath = currPath.removeLastSegments(1);
        }
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(NewWizardMessages.getString("SourceAttachmentBlock.extjardialog.text"));
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return new Path(res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseExtFolder() {
        Path currPath = new Path(this.fFileNameField.getText());
        if (currPath.isEmpty()) {
            currPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath((IPath)currPath)) {
            currPath = currPath.removeLastSegments(1);
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(NewWizardMessages.getString("SourceAttachmentBlock.extfolderdialog.text"));
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return new Path(res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseInternal() {
        String initSelection = this.fFileNameField.getText();
        ArchiveFileFilter filter = new ArchiveFileFilter(null, false);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSel = null;
        if (initSelection.length() > 0) {
            initSel = this.fWorkspaceRoot.findMember((IPath)new Path(initSelection));
        }
        if (initSel == null) {
            initSel = this.fWorkspaceRoot.findMember(this.fEntry.getPath());
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setAllowMultiple(false);
        dialog.addFilter(filter);
        dialog.setTitle(NewWizardMessages.getString("SourceAttachmentBlock.intjardialog.title"));
        dialog.setMessage(NewWizardMessages.getString("SourceAttachmentBlock.intjardialog.message"));
        dialog.setInput(this.fWorkspaceRoot);
        dialog.setInitialSelection(initSel);
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            return res.getFullPath();
        }
        return null;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private IPath modifyPath(IPath path, String varName) {
        if (varName == null || path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return new Path(varName);
        }
        IPath varPath = JavaCore.getClasspathVariable((String)varName);
        path = varPath != null ? (varPath.isPrefixOf(path) ? path.removeFirstSegments(varPath.segmentCount()) : new Path(path.lastSegment())) : new Path(path.lastSegment());
        return new Path(varName).append(path);
    }

    public static IRunnableWithProgress getRunnable(final Shell shell, final IClasspathEntry newEntry, final IJavaProject jproject, final IPath containerPath) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    SourceAttachmentBlock.attachSource(shell, newEntry, jproject, containerPath, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public IRunnableWithProgress getRunnable(Shell shell) {
        return SourceAttachmentBlock.getRunnable(shell, this.getNewEntry(), this.fProject, this.fContainerPath);
    }

    protected static void attachSource(Shell shell, IClasspathEntry newEntry, IJavaProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        if (containerPath != null) {
            SourceAttachmentBlock.updateContainerClasspath(jproject, containerPath, newEntry, monitor);
        } else {
            SourceAttachmentBlock.updateProjectClasspath(shell, jproject, newEntry, monitor);
        }
    }

    private static void updateContainerClasspath(IJavaProject jproject, IPath containerPath, IClasspathEntry newEntry, IProgressMonitor monitor) throws CoreException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
        IClasspathEntry[] entries = container.getClasspathEntries();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry curr = entries[i];
            newEntries[i] = curr.getEntryKind() == newEntry.getEntryKind() && curr.getPath().equals((Object)newEntry.getPath()) ? newEntry : curr;
            ++i;
        }
        UpdatedClasspathContainer updatedContainer = new UpdatedClasspathContainer(container, newEntries);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        initializer.requestClasspathContainerUpdate(containerPath, jproject, (IClasspathContainer)updatedContainer);
        monitor.worked(1);
    }

    private static void updateProjectClasspath(Shell shell, IJavaProject jproject, IClasspathEntry newEntry, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] oldClasspath = jproject.getRawClasspath();
        int nEntries = oldClasspath.length;
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(nEntries + 1);
        int entryKind = newEntry.getEntryKind();
        IPath jarPath = newEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            IClasspathEntry curr = oldClasspath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals((Object)jarPath)) {
                newEntries.add(newEntry);
                found = true;
            } else {
                newEntries.add(curr);
            }
            ++i;
        }
        if (!found) {
            if (newEntry.getSourceAttachmentPath() == null || !SourceAttachmentBlock.putJarOnClasspathDialog(shell)) {
                return;
            }
            newEntries.add(newEntry);
        }
        IClasspathEntry[] newClasspath = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
        jproject.setRawClasspath(newClasspath, monitor);
    }

    private static boolean putJarOnClasspathDialog(Shell shell) {
        final boolean[] result = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = NewWizardMessages.getString("SourceAttachmentBlock.putoncpdialog.title");
                String message = NewWizardMessages.getString("SourceAttachmentBlock.putoncpdialog.message");
                result[0] = MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
            }
        });
        return result[0];
    }

    private static class UpdatedClasspathContainer
    implements IClasspathContainer {
        private IClasspathEntry[] fNewEntries;
        private IClasspathContainer fOriginal;

        public UpdatedClasspathContainer(IClasspathContainer original, IClasspathEntry[] newEntries) {
            this.fNewEntries = newEntries;
            this.fOriginal = original;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fNewEntries;
        }

        public String getDescription() {
            return this.fOriginal.getDescription();
        }

        public int getKind() {
            return this.fOriginal.getKind();
        }

        public IPath getPath() {
            return this.fOriginal.getPath();
        }
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            SourceAttachmentBlock.this.attachmentChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            SourceAttachmentBlock.this.attachmentDialogFieldChanged(field);
        }
    }
}

