/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.CompoundContentAssistProcessor;
import org.eclipse.jdt.internal.ui.text.ContentAssistPreference;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.JavaAnnotationHover;
import org.eclipse.jdt.internal.ui.text.JavaCommentScanner;
import org.eclipse.jdt.internal.ui.text.JavaCompositeReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.JavaElementProvider;
import org.eclipse.jdt.internal.ui.text.JavaOutlineInformationControl;
import org.eclipse.jdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.jdt.internal.ui.text.JavaReconciler;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.comment.DefaultTextMeasurement;
import org.eclipse.jdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaCodeScanner;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jdt.internal.ui.text.java.JavaDoubleClickSelector;
import org.eclipse.jdt.internal.ui.text.java.JavaFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaStringAutoIndentStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaStringDoubleClickSelector;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverProxy;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaInformationProvider;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocAutoIndentStrategy;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocCompletionProcessor;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocScanner;
import org.eclipse.jdt.internal.ui.text.spelling.WordCompletionProcessor;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyInformationControl;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final String PREFERENCE_TAB_WIDTH = "org.eclipse.jdt.ui.editor.tab.width";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    private JavaTextTools fJavaTextTools;
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private AbstractJavaScanner fCodeScanner;
    private AbstractJavaScanner fMultilineCommentScanner;
    private AbstractJavaScanner fSinglelineCommentScanner;
    private AbstractJavaScanner fStringScanner;
    private AbstractJavaScanner fJavaDocScanner;
    private IPreferenceStore fPreferenceStore;
    private IColorManager fColorManager;

    public JavaSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    public JavaSourceViewerConfiguration(JavaTextTools tools, ITextEditor editor) {
        this.fJavaTextTools = tools;
        this.fColorManager = tools.getColorManager();
        this.fPreferenceStore = this.createPreferenceStore();
        this.fCodeScanner = (AbstractJavaScanner)this.fJavaTextTools.getCodeScanner();
        this.fMultilineCommentScanner = (AbstractJavaScanner)this.fJavaTextTools.getMultilineCommentScanner();
        this.fSinglelineCommentScanner = (AbstractJavaScanner)this.fJavaTextTools.getSinglelineCommentScanner();
        this.fStringScanner = (AbstractJavaScanner)this.fJavaTextTools.getStringScanner();
        this.fJavaDocScanner = (AbstractJavaScanner)this.fJavaTextTools.getJavaDocScanner();
        this.fTextEditor = editor;
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getJavaDocScanner() {
        return this.fJavaDocScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    protected IPreferenceStore getPreferenceStore() {
        Assert.isTrue((!this.isNewSetup() ? 1 : 0) != 0);
        return this.fJavaTextTools.getPreferenceStore();
    }

    private boolean isNewSetup() {
        return this.fJavaTextTools == null;
    }

    private IPreferenceStore createPreferenceStore() {
        Assert.isTrue((!this.isNewSetup() ? 1 : 0) != 0);
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        if (this.fJavaTextTools.getCorePreferenceStore() == null) {
            return new ChainedPreferenceStore(new IPreferenceStore[]{this.fJavaTextTools.getPreferenceStore(), generalTextStore});
        }
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.fJavaTextTools.getPreferenceStore(), new PreferencesAdapter(this.fJavaTextTools.getCorePreferenceStore()), generalTextStore});
    }

    private void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new JavaCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fMultilineCommentScanner = new JavaCommentScanner(this.getColorManager(), this.fPreferenceStore, "java_multi_line_comment");
        this.fSinglelineCommentScanner = new JavaCommentScanner(this.getColorManager(), this.fPreferenceStore, "java_single_line_comment");
        this.fStringScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "java_string");
        this.fJavaDocScanner = new JavaDocScanner(this.getColorManager(), this.fPreferenceStore);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        JavaPresentationReconciler reconciler = new JavaPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJavaDocScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_javadoc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_javadoc");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_character");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() != null) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            assistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
            JavaCompletionProcessor javaProcessor = new JavaCompletionProcessor((IEditorPart)this.getEditor());
            assistant.setContentAssistProcessor((IContentAssistProcessor)javaProcessor, "__dftl_partition_content_type");
            WordCompletionProcessor wordProcessor = new WordCompletionProcessor();
            CompoundContentAssistProcessor compoundProcessor = new CompoundContentAssistProcessor();
            compoundProcessor.add(javaProcessor);
            compoundProcessor.add(wordProcessor);
            assistant.setContentAssistProcessor((IContentAssistProcessor)compoundProcessor, "__java_singleline_comment");
            assistant.setContentAssistProcessor((IContentAssistProcessor)wordProcessor, "__java_string");
            assistant.setContentAssistProcessor((IContentAssistProcessor)wordProcessor, "__java_multiline_comment");
            assistant.setContentAssistProcessor((IContentAssistProcessor)new JavaDocCompletionProcessor((IEditorPart)this.getEditor()), "__java_javadoc");
            ContentAssistPreference.configure(assistant, this.fPreferenceStore);
            assistant.setContextInformationPopupOrientation(20);
            assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            return assistant;
        }
        return null;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ITextEditor editor = this.getEditor();
        if (editor != null && editor.isEditable()) {
            JavaCompositeReconcilingStrategy strategy = new JavaCompositeReconcilingStrategy(editor, this.getConfiguredDocumentPartitioning(sourceViewer));
            JavaReconciler reconciler = new JavaReconciler(editor, strategy, false);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__java_javadoc".equals(contentType) || "__java_multiline_comment".equals(contentType)) {
            return new JavaDocAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        if ("__java_string".equals(contentType)) {
            return new JavaStringAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return new JavaAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer));
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__java_javadoc".equals(contentType) || "__java_multiline_comment".equals(contentType) || "__java_singleline_comment".equals(contentType)) {
            return new DefaultTextDoubleClickStrategy();
        }
        if ("__java_string".equals(contentType) || "__java_character".equals(contentType)) {
            return new JavaStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return new JavaDoubleClickSelector();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        int tabWidth = CodeFormatterUtil.getTabWidth();
        boolean useSpaces = this.fPreferenceStore.getBoolean(SPACES_FOR_TABS);
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore.contains("tabWidth")) {
            return this.fPreferenceStore.getInt("tabWidth");
        }
        return this.fPreferenceStore.getInt(PREFERENCE_TAB_WIDTH);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new JavaAnnotationHover(JavaAnnotationHover.VERTICAL_RULER_HOVER);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new JavaAnnotationHover(JavaAnnotationHover.OVERVIEW_RULER_HOVER);
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new JavaEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor());
            }
            ++i;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new JavaFormattingStrategy());
        DefaultTextMeasurement textMeasurement = new DefaultTextMeasurement((Control)sourceViewer.getTextWidget());
        formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(textMeasurement), "__java_javadoc");
        formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(textMeasurement), "__java_singleline_comment");
        formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(textMeasurement), "__java_multiline_comment");
        return formatter;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new JavaOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new HierarchyInformationControl(parent, shellStyle, treeStyle);
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        JavaInformationProvider provider = new JavaInformationProvider((IEditorPart)this.getEditor());
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = doCodeResolve ? new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.jdt.ui.navigate.java.open.structure")) : new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.jdt.ui.edit.text.java.show.outline"));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(20, 20, true, false);
        presenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
        return presenter;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = JavaPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public IInformationPresenter getHierarchyPresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(50, 20, true, false);
        presenter.setRestoreInformationControlBounds(this.getSettings("hierarchy_presenter_bounds"), true, true);
        return presenter;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fJavaDocScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fJavaDocScanner.affectsBehavior(event)) {
            this.fJavaDocScanner.adaptToPreferenceChange(event);
        }
    }
}

