/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.MarkerUtil;

class BookmarkPropertiesDialog
extends Dialog {
    private IMarker marker = null;
    private IResource resource = null;
    private Map initialAttributes = null;
    private Text descriptionText;
    private Label creationTime;
    private Text resourceText;
    private Text folderText;
    private Text locationText;
    private boolean dirty;
    private String title;

    public BookmarkPropertiesDialog(Shell parentShell) {
        super(parentShell);
    }

    public BookmarkPropertiesDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
    }

    public void create() {
        super.create();
    }

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setInitialAttributes(Map initialAttributes) {
        this.initialAttributes = initialAttributes;
    }

    public Map getInitialAttributes() {
        return this.initialAttributes;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title == null) {
            newShell.setText(BookmarkMessages.getString("PropertiesDialogTitle.text"));
        } else {
            newShell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        if (this.marker != null) {
            this.resource = this.marker.getResource();
            try {
                this.initialAttributes = this.marker.getAttributes();
            }
            catch (CoreException coreException) {}
        } else if (this.initialAttributes == null && this.resource == null) {
            this.resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createDescriptionArea(composite);
        if (this.marker != null) {
            this.createCreationTimeArea(composite);
        }
        if (this.resource != null && this.resource.getType() != 8) {
            this.createResourceArea(composite);
        }
        this.updateDialogFromMarker();
        return composite;
    }

    private void createCreationTimeArea(Composite parent) {
        String creation = BookmarkMessages.getString("MarkerCreationTime.text");
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(creation);
        label.setFont(font);
        this.creationTime = new Label(composite, 0);
        this.creationTime.setFont(font);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createDescriptionArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(BookmarkMessages.getString("ColumnDescription.dialogText"));
        label.setFont(font);
        int style = 2052;
        this.descriptionText = new Text(composite, style);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.setFont(font);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BookmarkPropertiesDialog.this.markDirty();
            }
        });
    }

    private void createResourceArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label resourceLabel = new Label(composite, 0);
        resourceLabel.setText(BookmarkMessages.getString("ColumnResource.dialogText"));
        resourceLabel.setFont(font);
        this.resourceText = new Text(composite, 2124);
        gridData = new GridData(768);
        this.resourceText.setLayoutData((Object)gridData);
        this.resourceText.setFont(font);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText(BookmarkMessages.getString("ColumnFolder.dialogText"));
        folderLabel.setFont(font);
        this.folderText = new Text(composite, 2124);
        gridData = new GridData(768);
        this.folderText.setLayoutData((Object)gridData);
        this.folderText.setFont(font);
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText(BookmarkMessages.getString("ColumnLocation.dialogText"));
        locationLabel.setFont(font);
        this.locationText = new Text(composite, 2124);
        gridData = new GridData(768);
        this.locationText.setLayoutData((Object)gridData);
        this.locationText.setFont(font);
    }

    private void updateDialogFromMarker() {
        if (this.marker == null) {
            this.updateDialogForNewMarker();
            return;
        }
        this.descriptionText.setText(MarkerUtil.getMessage(this.marker));
        if (this.creationTime != null) {
            this.creationTime.setText(MarkerUtil.getCreationTime(this.marker));
        }
        if (this.resourceText != null) {
            this.resourceText.setText(MarkerUtil.getResourceName(this.marker));
        }
        if (this.folderText != null) {
            this.folderText.setText(MarkerUtil.getContainerName(this.marker));
        }
        if (this.locationText != null) {
            int line = MarkerUtil.getLineNumber(this.marker);
            if (line < 0) {
                this.locationText.setText("");
            } else {
                this.locationText.setText(BookmarkMessages.format("LineIndicator.text", new String[]{String.valueOf(line)}));
            }
        }
        this.descriptionText.selectAll();
    }

    void updateDialogForNewMarker() {
        if (this.resource != null) {
            this.resourceText.setText(this.resource.getName());
            IPath path = this.resource.getFullPath();
            int n = path.segmentCount() - 1;
            if (n > 0) {
                int len = 0;
                int i = 0;
                while (i < n) {
                    len += path.segment(i).length();
                    ++i;
                }
                if (n > 1) {
                    len += n - 1;
                }
                StringBuffer sb = new StringBuffer(len);
                int i2 = 0;
                while (i2 < n) {
                    if (i2 != 0) {
                        sb.append('/');
                    }
                    sb.append(path.segment(i2));
                    ++i2;
                }
                this.folderText.setText(sb.toString());
            }
        }
        if (this.initialAttributes != null) {
            Object description = this.initialAttributes.get("message");
            if (description != null && description instanceof String) {
                this.descriptionText.setText((String)description);
            }
            this.descriptionText.selectAll();
            Object line = this.initialAttributes.get("lineNumber");
            if (line != null && line instanceof Integer) {
                this.locationText.setText(BookmarkMessages.format("LineIndicator.text", new String[]{line.toString()}));
            }
        }
    }

    protected void okPressed() {
        this.saveChanges();
        super.okPressed();
    }

    private void markDirty() {
        this.dirty = true;
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void saveChanges() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (BookmarkPropertiesDialog.this.marker == null) {
                        BookmarkPropertiesDialog.this.createMarker();
                    } else if (BookmarkPropertiesDialog.this.isDirty()) {
                        BookmarkPropertiesDialog.this.updateMarker();
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)BookmarkMessages.getString("Error"), null, (IStatus)e.getStatus());
            return;
        }
    }

    private void updateMarker() throws CoreException {
        Map attrs = this.getMarkerAttributesFromDialog();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object val = attrs.get(key);
            this.marker.setAttribute(key, val);
        }
    }

    private Map getMarkerAttributesFromDialog() {
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put("message", this.descriptionText.getText());
        return attribs;
    }

    private void createMarker() {
        if (this.resource == null || !(this.resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)this.resource;
        try {
            IMarker newMarker = file.createMarker("org.eclipse.core.resources.bookmark");
            if (this.initialAttributes != null) {
                newMarker.setAttributes(this.initialAttributes);
            }
            String message = this.descriptionText.getText();
            newMarker.setAttribute("message", (Object)message);
        }
        catch (CoreException coreException) {}
    }
}

