/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.OpenTypeAction;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaStackTraceHyperlink
implements IConsoleHyperlink {
    private IConsole fConsole;

    public JavaStackTraceHyperlink(IConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        try {
            String editorId;
            IDebugModelPresentation presentation;
            IEditorInput editorInput;
            Object sourceElement;
            String typeName = this.getTypeName();
            int lineNumber = this.getLineNumber();
            if (lineNumber > 0) {
                --lineNumber;
            }
            if ((sourceElement = this.getSourceElement(typeName)) != null && (editorInput = (presentation = JDIDebugUIPlugin.getDefault().getModelPresentation()).getEditorInput(sourceElement)) != null && (editorId = presentation.getEditorId(editorInput, sourceElement)) != null) {
                IEditorPart editorPart = JDIDebugUIPlugin.getActivePage().openEditor(editorInput, editorId);
                if (editorPart instanceof ITextEditor && lineNumber >= 0) {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    provider.connect((Object)editorInput);
                    IDocument document = provider.getDocument((Object)editorInput);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {}
                    provider.disconnect((Object)editorInput);
                }
                return;
            }
            MessageDialog.openInformation((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.getString("JavaStackTraceHyperlink.Information_1"), (String)MessageFormat.format(ConsoleMessages.getString("JavaStackTraceHyperlink.Source_not_found_for_{0}_2"), typeName));
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(ConsoleMessages.getString("JavaStackTraceHyperlink.An_exception_occurred_while_following_link._3"), e);
            return;
        }
    }

    protected Object getSourceElement(String typeName) {
        ISourceLocator locator = this.getSourceLocator();
        if (locator == null) {
            try {
                return OpenTypeAction.findTypeInWorkspace(typeName);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return OpenTypeAction.findSourceElement(typeName, locator);
    }

    private ISourceLocator getSourceLocator() {
        ISourceLocator sourceLocator = null;
        ILaunch launch = this.getConsole().getProcess().getLaunch();
        if (launch != null) {
            sourceLocator = launch.getSourceLocator();
        }
        return sourceLocator;
    }

    protected String getTypeName() throws CoreException {
        String linkText = this.getLinkText();
        int index = linkText.indexOf(40);
        if (index >= 0) {
            String typeName = linkText.substring(0, index);
            int innerClassIndex = typeName.lastIndexOf(36, index = typeName.lastIndexOf(46));
            if (innerClassIndex != -1) {
                index = innerClassIndex;
            }
            if (index >= 0) {
                typeName = typeName.substring(0, index);
            }
            return typeName;
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.getString("JavaStackTraceHyperlink.Unable_to_parse_type_name_from_hyperlink._5"), null);
        throw new CoreException((IStatus)status);
    }

    protected int getLineNumber() throws CoreException {
        String linkText = this.getLinkText();
        int index = linkText.lastIndexOf(58);
        if (index >= 0) {
            String numText = linkText.substring(index + 1, linkText.length() - 1);
            try {
                return Integer.parseInt(numText);
            }
            catch (NumberFormatException e) {
                Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.getString("JavaStackTraceHyperlink.Unable_to_parse_line_number_from_hyperlink._6"), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.getString("JavaStackTraceHyperlink.Unable_to_parse_line_number_from_hyperlink._7"), null);
        throw new CoreException((IStatus)status);
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws CoreException {
        try {
            IRegion region = this.getConsole().getRegion((IConsoleHyperlink)this);
            return this.getConsole().getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.getString("JavaStackTraceHyperlink.Unable_to_retrieve_hyperlink_text._8"), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

