/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.build.ExternalBuildModel;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.PluginBase;

public abstract class ExternalPluginModelBase
extends AbstractPluginModelBase {
    private String installLocation;
    private transient IBuildModel buildModel;

    protected NLResourceHelper createNLResourceHelper() {
        String name = this.isFragmentModel() ? "fragment" : "plugin";
        return new NLResourceHelper(name, this.getNLLookupLocations());
    }

    public URL getNLLookupLocation() {
        String installLocation = this.getInstallLocation();
        if (!installLocation.startsWith("file:")) {
            installLocation = "file:" + installLocation;
        }
        try {
            URL url = new URL(String.valueOf(installLocation) + "/");
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public IBuildModel getBuildModel() {
        if (this.buildModel == null) {
            this.buildModel = new ExternalBuildModel(this.getInstallLocation());
            ((ExternalBuildModel)this.buildModel).load();
        }
        return this.buildModel;
    }

    protected abstract File getFile();

    public String getInstallLocation() {
        return this.installLocation;
    }

    public boolean isEditable() {
        return false;
    }

    public void load() {
        File file = this.getFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            try {
                FileInputStream stream = new FileInputStream(file);
                this.load(stream, false);
                ((InputStream)stream).close();
            }
            catch (CoreException coreException) {
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        } else {
            this.pluginBase = (PluginBase)this.createPluginBase();
            this.pluginBase.setModel(this);
            this.loaded = true;
        }
    }

    public void load(BundleDescription description, PDEState state) {
        PluginBase pluginBase = (PluginBase)this.getPluginBase();
        if (pluginBase == null) {
            this.pluginBase = pluginBase = (PluginBase)this.createPluginBase();
        } else {
            pluginBase.reset();
        }
        Path path = new Path(description.getLocation());
        String device = path.getDevice();
        if (device != null) {
            path = path.setDevice(device.toUpperCase());
        }
        this.setInstallLocation(path.toOSString());
        this.setBundleDescription(description);
        pluginBase.load(description, state);
        this.updateTimeStamp();
        this.loaded = true;
    }

    public boolean isInSync() {
        return this.isInSync(this.getLocalFile());
    }

    private File getLocalFile() {
        File file = new File(this.getInstallLocation(), "META-INF/MANIFEST.MF");
        if (!file.exists()) {
            String manifest = this.isFragmentModel() ? "fragment.xml" : "plugin.xml";
            file = new File(this.getInstallLocation(), manifest);
        }
        return file;
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.getLocalFile());
    }

    public void setInstallLocation(String newInstallLocation) {
        this.installLocation = newInstallLocation;
    }
}

