/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.core.ischema.IPluginLocationProvider;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.AbstractSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.FileSchemaDescriptor;

public class IncludedSchemaDescriptor
extends AbstractSchemaDescriptor {
    private URL url;
    private String schemaLocation;
    private ISchemaDescriptor parent;

    public IncludedSchemaDescriptor(ISchemaDescriptor parent, String schemaLocation) {
        this.parent = parent;
        this.schemaLocation = schemaLocation;
        try {
            this.url = IncludedSchemaDescriptor.computeURL(parent, parent.getSchemaURL(), schemaLocation);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public IFile getFile() {
        if (this.parent instanceof FileSchemaDescriptor) {
            FileSchemaDescriptor fparent = (FileSchemaDescriptor)this.parent;
            IFile parentFile = fparent.getFile();
            if (parentFile == null) {
                return null;
            }
            IPath parentPath = parentFile.getProjectRelativePath();
            IPath childPath = parentPath.removeLastSegments(1).append(this.schemaLocation);
            return parentFile.getProject().getFile(childPath);
        }
        return null;
    }

    public static URL computeURL(IPluginLocationProvider locationProvider, URL parentURL, String schemaLocation) throws MalformedURLException {
        if (schemaLocation.startsWith("schema://")) {
            String rem = schemaLocation.substring(9);
            Path path = new Path(rem);
            String pluginId = path.segment(0);
            path = path.removeFirstSegments(1);
            if (locationProvider != null) {
                IPath includedLocation = locationProvider.getPluginRelativePath(pluginId, (IPath)path);
                if (includedLocation == null) {
                    return null;
                }
                return new URL(parentURL.getProtocol(), parentURL.getHost(), includedLocation.toString());
            }
            return null;
        }
        Path path = new Path(parentURL.getPath());
        path = path.removeLastSegments(1).append(schemaLocation);
        return new URL(parentURL.getProtocol(), parentURL.getHost(), path.toString());
    }

    public boolean isEnabled() {
        return true;
    }

    public String getPointId() {
        int dotLoc = this.schemaLocation.lastIndexOf(46);
        if (dotLoc != -1) {
            return this.schemaLocation.substring(0, dotLoc);
        }
        return null;
    }

    public URL getSchemaURL() {
        return this.url;
    }
}

