/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFile;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFolder;
import org.eclipse.team.internal.ccvs.core.resources.FileContentCachingService;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteModule;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class CVSWorkspaceRoot {
    private ICVSFolder localRoot;

    public CVSWorkspaceRoot(IContainer resource) {
        this.localRoot = CVSWorkspaceRoot.getCVSFolderFor(resource);
    }

    public static void setSharing(IProject project, FolderSyncInfo info, IProgressMonitor monitor) throws TeamException {
        ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)project);
        FolderSyncInfo folderInfo = folder.getFolderSyncInfo();
        if (!info.equals(folderInfo)) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSProvider.infoMismatch", project.getName())));
        }
        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getExpansions(ICVSRemoteFolder[] resources, IProgressMonitor monitor) throws CVSException {
        IStatus status;
        if (resources.length == 0) {
            return new String[0];
        }
        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        String[] arguments = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            arguments[i] = resources[i] instanceof RemoteModule ? ((RemoteModule)resources[i]).getName() : resources[i].getRepositoryRelativePath();
            ++i;
        }
        Session s = new Session(resources[0].getRepository(), root);
        s.open(monitor, false);
        try {
            status = Request.EXPAND_MODULES.execute(s, arguments, monitor);
            Object var6_9 = null;
            s.close();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            s.close();
            throw throwable;
        }
        if (status.getCode() == -10) {
            throw new CVSServerException(status);
        }
        return s.getModuleExpansions();
    }

    public static ICVSFolder getCVSFolderFor(IContainer resource) {
        return new EclipseFolder(resource);
    }

    public static ICVSFile getCVSFileFor(IFile resource) {
        return new EclipseFile(resource);
    }

    public static ICVSResource getCVSResourceFor(IResource resource) {
        if (resource.getType() == 1) {
            return CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
        }
        return CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource);
    }

    public static ICVSRemoteResource getRemoteResourceFor(IResource resource) throws CVSException {
        ICVSResource managed = CVSWorkspaceRoot.getCVSResourceFor(resource);
        return CVSWorkspaceRoot.getRemoteResourceFor(managed);
    }

    public static ICVSRemoteResource getRemoteResourceFor(ICVSResource resource) throws CVSException {
        if (resource.isFolder()) {
            ICVSFolder folder = (ICVSFolder)resource;
            FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
            if (syncInfo != null) {
                return new RemoteFolder(null, KnownRepositories.getInstance().getRepository(syncInfo.getRoot()), syncInfo.getRepository(), syncInfo.getTag());
            }
        } else if (resource.isManaged()) {
            RemoteFolder parent = (RemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor(resource.getParent());
            if (parent == null) {
                if (resource.isManaged()) {
                    CVSProviderPlugin.log((CoreException)((Object)new CVSException(Policy.bind("CVSWorkspaceRoot.11", Util.getFullestPath(resource)))));
                }
            } else {
                return RemoteFile.getBase(parent, (ICVSFile)resource);
            }
        }
        return null;
    }

    private static ICVSRemoteResource getRemoteTreeFromParent(IResource resource, ICVSResource managed, CVSTag tag, IProgressMonitor progress) throws TeamException {
        ICVSFolder parent = managed.getParent();
        FolderSyncInfo syncInfo = parent.getFolderSyncInfo();
        if (syncInfo == null) {
            return null;
        }
        ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(parent.getFolderSyncInfo().getRoot());
        RemoteFolderTree remoteParent = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, parent, tag, progress);
        ICVSRemoteResource remote = null;
        if (remoteParent != null) {
            try {
                remote = (ICVSRemoteResource)remoteParent.getChild(resource.getName());
            }
            catch (CVSException cVSException) {
                remote = null;
            }
            if (remote != null && remote.isContainer() != managed.isFolder()) {
                throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.typesDiffer", resource.getFullPath().toString()), null));
            }
        }
        return remote;
    }

    public static ICVSRemoteResource getRemoteTree(IResource resource, CVSTag tag, IProgressMonitor progress) throws TeamException {
        return CVSWorkspaceRoot.getRemoteTree(resource, tag, false, progress);
    }

    public static ICVSRemoteResource getRemoteTree(IResource resource, CVSTag tag, boolean cacheFileContentsHint, IProgressMonitor progress) throws TeamException {
        ICVSResource managed = CVSWorkspaceRoot.getCVSResourceFor(resource);
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor(resource);
        if (remote == null) {
            progress.beginTask(null, 100);
            remote = CVSWorkspaceRoot.getRemoteTreeFromParent(resource, managed, tag, Policy.subMonitorFor(progress, 50));
            if (cacheFileContentsHint && remote != null && remote instanceof RemoteFile) {
                RemoteFile file = (RemoteFile)remote;
                file.getStorage(Policy.subMonitorFor(progress, 50));
            }
            progress.done();
        } else if (resource.getType() == 1) {
            ICVSRepositoryLocation location = remote.getRepository();
            remote = cacheFileContentsHint ? FileContentCachingService.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFile)managed, tag, progress) : RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFile)managed, tag, progress);
        } else {
            ICVSRepositoryLocation location = remote.getRepository();
            remote = cacheFileContentsHint ? FileContentCachingService.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFolder)managed, tag, progress) : RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFolder)managed, tag, progress);
        }
        return remote;
    }

    public static boolean hasRemote(IResource resource) {
        try {
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
            int type = resource.getType();
            if (type != 1) {
                if (type == 4) {
                    return ((ICVSFolder)cvsResource).isCVSFolder();
                }
                return cvsResource.isManaged();
            }
            byte[] syncBytes = ((ICVSFile)cvsResource).getSyncBytes();
            if (syncBytes != null) {
                return !ResourceSyncInfo.isAddition(syncBytes);
            }
            return false;
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    public ICVSRepositoryLocation getRemoteLocation() throws CVSException {
        FolderSyncInfo info = this.localRoot.getFolderSyncInfo();
        if (info == null) {
            throw new CVSException(Policy.bind("CVSWorkspaceRoot.notCVSFolder", this.localRoot.getName()));
        }
        return KnownRepositories.getInstance().getRepository(info.getRoot());
    }

    public ICVSFolder getLocalRoot() {
        return this.localRoot;
    }

    public static boolean isLinkedResource(IResource resource) {
        if (resource.isLinked()) {
            return true;
        }
        if (resource.getType() == 4 || resource.getType() == 8) {
            return false;
        }
        String linkedParentName = resource.getProjectRelativePath().segment(0);
        IFolder linkedParent = resource.getProject().getFolder(linkedParentName);
        return linkedParent.isLinked();
    }

    public static boolean isSharedWithCVS(IResource resource) throws CVSException {
        if (!resource.isAccessible()) {
            return false;
        }
        if (CVSWorkspaceRoot.isLinkedResource(resource)) {
            return false;
        }
        if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId()) == null) {
            return false;
        }
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
        if (cvsResource.isManaged()) {
            return true;
        }
        if (!cvsResource.exists()) {
            return false;
        }
        if (cvsResource.isFolder() && ((ICVSFolder)cvsResource).isCVSFolder()) {
            return true;
        }
        if (cvsResource.isIgnored()) {
            return false;
        }
        return cvsResource.getParent().isCVSFolder();
    }

    public static boolean isOrphanedSubtree(IContainer container) throws CVSException {
        ICVSFolder mFolder = CVSWorkspaceRoot.getCVSFolderFor(container);
        return mFolder.isCVSFolder() && !mFolder.isManaged() && mFolder.getIResource().getType() == 2 && !CVSWorkspaceRoot.isLinkedResource((IResource)container);
    }
}

