/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpApplication;
import org.eclipse.help.internal.base.HelpDisplay;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.osgi.framework.Bundle;

public class ControlServlet
extends HttpServlet {
    public static final String UPDATE_PLUGIN_ID = "org.eclipse.update.core";
    public static final String CMD_DISPLAYHELP = "displayHelp";
    public static final String CMD_SHUTDOWN = "shutdown";
    public static final String CMD_INSTALL = "install";
    public static final String CMD_UPDATE = "update";
    public static final String CMD_ENABLE = "enable";
    public static final String CMD_DISABLE = "disable";
    public static final String CMD_UNINSTALL = "uninstall";
    public static final String CMD_SEARCH = "search";
    public static final String CMD_LIST = "listFeatures";
    public static final String CMD_ADDSITE = "addSite";
    public static final String CMD_APPLY = "apply";
    public static final String CMD_REMOVESITE = "removeSite";
    public static final String PACKAGE_PREFIX = "org.eclipse.update.standalone.";
    public static final String CLASS_INSTALL = "org.eclipse.update.standalone.InstallCommand";
    public static final String CLASS_UPDATE = "org.eclipse.update.standalone.UpdateCommand";
    public static final String CLASS_ENABLE = "org.eclipse.update.standalone.EnableCommand";
    public static final String CLASS_DISABLE = "org.eclipse.update.standalone.DisableCommand";
    public static final String CLASS_UNINSTALL = "org.eclipse.update.standalone.UninstallCommand";
    public static final String CLASS_SEARCH = "org.eclipse.update.standalone.SearchCommand";
    public static final String CLASS_LIST = "org.eclipse.update.standalone.ListFeaturesCommand";
    public static final String CLASS_ADDSITE = "org.eclipse.update.standalone.AddSiteCommand";
    public static final String CLASS_REMOVESITE = "org.eclipse.update.standalone.RemoveSiteCommand";
    public static final String PARAM_FEATUREID = "featureId";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TO = "to";
    public static final String PARAM_VERIFYONLY = "verifyOnly";
    private HelpDisplay helpDisplay = null;
    private boolean shuttingDown = false;
    static /* synthetic */ Class class$0;

    public void init() throws ServletException {
        super.init();
        if (BaseHelpSystem.getMode() == 2) {
            this.helpDisplay = BaseHelpSystem.getHelpDisplay();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        if (!UrlUtil.isLocalRequest(req)) {
            return;
        }
        if (!"/helpControl".equals(req.getContextPath()) || !"/control.html".equals(req.getServletPath())) {
            resp.sendError(403, "");
            return;
        }
        if (this.shuttingDown) {
            return;
        }
        String command = req.getParameter("command");
        if (command == null) {
            resp.getWriter().print("No command.");
            return;
        }
        if (CMD_SHUTDOWN.equalsIgnoreCase(command)) {
            this.shutdown();
        } else if (CMD_DISPLAYHELP.equalsIgnoreCase(command)) {
            if (BaseHelpSystem.getMode() == 2) {
                this.displayHelp(req);
            }
        } else if (CMD_INSTALL.equalsIgnoreCase(command) || CMD_ENABLE.equalsIgnoreCase(command) || CMD_DISABLE.equalsIgnoreCase(command) || CMD_UNINSTALL.equalsIgnoreCase(command) || CMD_SEARCH.equalsIgnoreCase(command) || CMD_LIST.equalsIgnoreCase(command) || CMD_ADDSITE.equalsIgnoreCase(command) || CMD_REMOVESITE.equalsIgnoreCase(command) || CMD_APPLY.equalsIgnoreCase(command)) {
            this.updateDocs(command, req);
        } else {
            resp.getWriter().print("Unrecognized command.");
        }
    }

    private void updateDocs(String command, HttpServletRequest req) {
        Bundle bundle = Platform.getBundle((String)UPDATE_PLUGIN_ID);
        if (bundle == null) {
            return;
        }
        try {
            String className = this.getStandaloneClassName(command);
            if (className == null) {
                System.out.println("No class name for command " + command);
                return;
            }
            Class c = bundle.loadClass(className);
            if (c == null) {
                System.out.println("No class for command " + command);
                return;
            }
            Class[] parameterTypes = this.getParameterTypes(className);
            Constructor constr = c.getConstructor(parameterTypes);
            if (constr == null) {
                System.out.println("No expected constructor for command " + command);
                return;
            }
            Method m = !CMD_APPLY.equalsIgnoreCase(command) ? c.getMethod("run", new Class[0]) : c.getMethod("applyChangesNow", new Class[0]);
            Object[] initargs = this.getInitArgs(className, req);
            Object o = constr.newInstance(initargs);
            Object ret = m.invoke(o, new Object[0]);
            if (!CMD_APPLY.equalsIgnoreCase(command) && ((Boolean)ret).equals(Boolean.FALSE)) {
                System.out.println("Command not executed.");
            } else {
                System.out.println("Command executed.");
            }
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = ((InvocationTargetException)e).getTargetException();
            }
            System.out.println(t.getLocalizedMessage());
        }
    }

    private String getStandaloneClassName(String command) {
        if (CMD_INSTALL.equalsIgnoreCase(command)) {
            return CLASS_INSTALL;
        }
        if (CMD_UPDATE.equalsIgnoreCase(command)) {
            return CLASS_UPDATE;
        }
        if (CMD_ENABLE.equalsIgnoreCase(command)) {
            return CLASS_ENABLE;
        }
        if (CMD_DISABLE.equalsIgnoreCase(command)) {
            return CLASS_DISABLE;
        }
        if (CMD_UNINSTALL.equalsIgnoreCase(command)) {
            return CLASS_UNINSTALL;
        }
        if (CMD_SEARCH.equalsIgnoreCase(command)) {
            return CLASS_SEARCH;
        }
        if (CMD_LIST.equalsIgnoreCase(command) || CMD_APPLY.equalsIgnoreCase(command)) {
            return CLASS_LIST;
        }
        if (CMD_ADDSITE.equalsIgnoreCase(command)) {
            return CLASS_ADDSITE;
        }
        if (CMD_REMOVESITE.equalsIgnoreCase(command)) {
            return CLASS_REMOVESITE;
        }
        return null;
    }

    private Class[] getParameterTypes(String className) {
        if (CLASS_INSTALL.equals(className)) {
            Class[] classArray = new Class[5];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz3;
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[3] = clazz4;
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[4] = clazz5;
            return classArray;
        }
        if (CLASS_UPDATE.equals(className)) {
            Class[] classArray = new Class[3];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz6 = class$0;
            if (clazz6 == null) {
                try {
                    clazz6 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz6;
            Class<?> clazz7 = class$0;
            if (clazz7 == null) {
                try {
                    clazz7 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz7;
            return classArray;
        }
        if (CLASS_ENABLE.equals(className) || CLASS_DISABLE.equals(className) || CLASS_UNINSTALL.equals(className)) {
            Class[] classArray = new Class[4];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz8;
            Class<?> clazz9 = class$0;
            if (clazz9 == null) {
                try {
                    clazz9 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz9;
            Class<?> clazz10 = class$0;
            if (clazz10 == null) {
                try {
                    clazz10 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[3] = clazz10;
            return classArray;
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    private Object[] getInitArgs(String className, HttpServletRequest req) {
        String featureId = req.getParameter(PARAM_FEATUREID);
        String version = req.getParameter(PARAM_VERSION);
        String fromSite = req.getParameter(PARAM_FROM);
        String toSite = req.getParameter(PARAM_TO);
        String verifyOnly = req.getParameter(PARAM_VERIFYONLY);
        if (CLASS_INSTALL.equals(className)) {
            return new Object[]{featureId, version, fromSite, toSite, verifyOnly};
        }
        if (CLASS_UPDATE.equals(className)) {
            return new Object[]{featureId, version, verifyOnly};
        }
        if (CLASS_ENABLE.equals(className) || CLASS_DISABLE.equals(className) || CLASS_UNINSTALL.equals(className)) {
            return new Object[]{featureId, version, toSite, verifyOnly};
        }
        if (CLASS_REMOVESITE.equals(className)) {
            return new Object[]{toSite};
        }
        return new Object[]{fromSite};
    }

    private void shutdown() {
        this.shuttingDown = true;
        HelpApplication.stop();
    }

    private void displayHelp(HttpServletRequest req) {
        String href = req.getParameter("href");
        if (href != null) {
            this.helpDisplay.displayHelpResource(href, false);
        } else {
            this.helpDisplay.displayHelp(false);
        }
    }
}

