/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.contentassist.SubjectControlContextInformationValidator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.search.internal.ui.SearchMessages;

final class RegExContentAssistProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private static final HashMap fgProposalStrings = new HashMap();
    public static ArrayList fgProposalKeys = new ArrayList();
    public static ArrayList fgFindProposalKeys;
    public static ArrayList fgReplaceProposalKeys;
    private ArrayList fProposalKeys;
    private IContextInformationValidator fValidator = new SubjectControlContextInformationValidator((IContentAssistProcessor)this);

    static {
        fgProposalKeys = new ArrayList();
        fgProposalKeys.add("\\\\");
        fgProposalKeys.add("\\0");
        fgProposalKeys.add("\\x");
        fgProposalKeys.add("\\u");
        fgProposalKeys.add("\\t");
        fgProposalKeys.add("\\n");
        fgProposalKeys.add("\\r");
        fgProposalKeys.add("\\f");
        fgProposalKeys.add("\\a");
        fgProposalKeys.add("\\e");
        fgProposalKeys.add("\\c");
        fgProposalKeys.add(".");
        fgProposalKeys.add("\\d");
        fgProposalKeys.add("\\D");
        fgProposalKeys.add("\\s");
        fgProposalKeys.add("\\S");
        fgProposalKeys.add("\\w");
        fgProposalKeys.add("\\W");
        fgProposalKeys.add("^");
        fgProposalKeys.add("$");
        fgProposalKeys.add("\\b");
        fgProposalKeys.add("\\B");
        fgProposalKeys.add("\\A");
        fgProposalKeys.add("\\G");
        fgProposalKeys.add("\\z");
        fgProposalKeys.add("?");
        fgProposalKeys.add("*");
        fgProposalKeys.add("+");
        fgProposalKeys.add("{n}");
        fgProposalKeys.add("{n,}");
        fgProposalKeys.add("{n,m}");
        fgProposalKeys.add("??");
        fgProposalKeys.add("*?");
        fgProposalKeys.add("+?");
        fgProposalKeys.add("{n}?");
        fgProposalKeys.add("{n,}?");
        fgProposalKeys.add("{n,m}?");
        fgProposalKeys.add("?+");
        fgProposalKeys.add("*+");
        fgProposalKeys.add("++");
        fgProposalKeys.add("{n}+");
        fgProposalKeys.add("{n,}+");
        fgProposalKeys.add("{n,m}+");
        fgProposalKeys.add("UV");
        fgProposalKeys.add("U|V");
        fgProposalKeys.add("(U)");
        fgProposalKeys.add("\\i");
        fgProposalKeys.add("$i");
        fgProposalKeys.add("\\");
        fgProposalKeys.add("\\Q");
        fgProposalKeys.add("\\E");
        fgProposalKeys.add("[ecq]");
        fgProposalKeys.add("[^ecq]");
        fgProposalKeys.add("[e-q]");
        fgProposalKeys.add("&&");
        fgFindProposalKeys = (ArrayList)fgProposalKeys.clone();
        fgFindProposalKeys.remove("$i");
        fgReplaceProposalKeys = new ArrayList();
        fgReplaceProposalKeys.add("$i");
        fgProposalStrings.put("\\\\", "\\\\");
        fgProposalStrings.put("\\0", "\\0");
        fgProposalStrings.put("\\x", "\\x");
        fgProposalStrings.put("\\u", "\\u");
        fgProposalStrings.put("\\t", "\\t");
        fgProposalStrings.put("\\n", "\\n");
        fgProposalStrings.put("\\r", "\\r");
        fgProposalStrings.put("\\f", "\\f");
        fgProposalStrings.put("\\a", "\\a");
        fgProposalStrings.put("\\e", "\\e");
        fgProposalStrings.put("\\c", "\\c");
        fgProposalStrings.put(".", ".");
        fgProposalStrings.put("\\d", "\\d");
        fgProposalStrings.put("\\D", "\\D");
        fgProposalStrings.put("\\s", "\\s");
        fgProposalStrings.put("\\S", "\\S");
        fgProposalStrings.put("\\w", "\\w");
        fgProposalStrings.put("\\W", "\\W");
        fgProposalStrings.put("^", "^");
        fgProposalStrings.put("$", "$");
        fgProposalStrings.put("\\b", "\\b");
        fgProposalStrings.put("\\B", "\\B");
        fgProposalStrings.put("\\A", "\\A");
        fgProposalStrings.put("\\G", "\\G");
        fgProposalStrings.put("\\Z", "\\Z");
        fgProposalStrings.put("\\z", "\\z");
        fgProposalStrings.put("?", "?");
        fgProposalStrings.put("*", "*");
        fgProposalStrings.put("+", "+");
        fgProposalStrings.put("{n}", "{}");
        fgProposalStrings.put("{n,}", "{,}");
        fgProposalStrings.put("{n,m}", "{,}");
        fgProposalStrings.put("??", "??");
        fgProposalStrings.put("*?", "*?");
        fgProposalStrings.put("+?", "+?");
        fgProposalStrings.put("{n}?", "{}?");
        fgProposalStrings.put("{n,}?", "{,}?");
        fgProposalStrings.put("{n,m}?", "{,}?");
        fgProposalStrings.put("?+", "?+");
        fgProposalStrings.put("*+", "*+");
        fgProposalStrings.put("++", "++");
        fgProposalStrings.put("{n}+", "{}+");
        fgProposalStrings.put("{n,}+", "{,}+");
        fgProposalStrings.put("{n,m}+", "{,}+");
        fgProposalStrings.put("UV", "");
        fgProposalStrings.put("U|V", "|");
        fgProposalStrings.put("(U)", "()");
        fgProposalStrings.put("\\i", "\\");
        fgProposalStrings.put("$i", "$");
        fgProposalStrings.put("\\", "\\");
        fgProposalStrings.put("\\Q", "\\Q");
        fgProposalStrings.put("\\E", "\\E");
        fgProposalStrings.put("[ecq]", "[]");
        fgProposalStrings.put("[^ecq]", "^");
        fgProposalStrings.put("[e-q]", "[]");
        fgProposalStrings.put("&&", "&&");
        fgProposalStrings.put("\\p{Lower}", "\\p{Lower}");
        fgProposalStrings.put("\\p{Upper}", "\\p{Upper}");
        fgProposalStrings.put("\\p{ASCII}", "\\p{ASCII}");
        fgProposalStrings.put("\\p{Alpha}", "\\p{Alpha}");
        fgProposalStrings.put("\\p{Digit}", "\\p{Digit}");
        fgProposalStrings.put("\\p{Alnum}", "\\p{Alnum}");
        fgProposalStrings.put("\\p{Punct}", "\\p{Punct}");
        fgProposalStrings.put("\\p{Graph}", "\\p{Graph}");
        fgProposalStrings.put("\\p{Print}", "\\p{Print}");
        fgProposalStrings.put("\\p{Blank}", "\\p{Blank}");
        fgProposalStrings.put("\\p{Cntrl}", "\\p{Cntrl}");
        fgProposalStrings.put("\\p{XDigit}", "\\p{XDigit}");
        fgProposalStrings.put("\\p{Space}", "\\p{Space}");
        fgProposalStrings.put("\\p{InGreek}", "\\p{InGreek}");
        fgProposalStrings.put("\\p{Lu}", "\\p{Lu}");
        fgProposalStrings.put("\\p{Sc}", "\\p{Sc}");
        fgProposalStrings.put("\\P{InGreek}", "\\P{InGreek}");
        fgProposalStrings.put("[\\p{L}&&[^\\p{Lu}]", "[\\p{L}&&[^\\p{Lu}]");
        fgProposalStrings.put("(?:U)", "(?:)");
        fgProposalStrings.put("(?idmsux-idmsux)", "(?)");
        fgProposalStrings.put("(?idmsux-idmsux:U)", "(?:)");
        fgProposalStrings.put("(?=U)", "(?=)");
        fgProposalStrings.put("(?!U)", "(?!)");
        fgProposalStrings.put("(?<=U)", "(?<=)");
        fgProposalStrings.put("(?<!U)", "(?<!)");
        fgProposalStrings.put("(?>U)", "(?>)");
    }

    public RegExContentAssistProcessor(ArrayList proposalKeys) {
        this.fProposalKeys = proposalKeys;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        return this.computeCompletionProposals((IContentAssistSubjectControl)null, documentOffset);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return this.computeContextInformation((IContentAssistSubjectControl)null, documentOffset);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'\\', '[', '('};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        ArrayList results = new ArrayList(this.fProposalKeys.size());
        Iterator iter = this.fProposalKeys.iterator();
        while (iter.hasNext()) {
            this.addProposal((String)iter.next(), contentAssistSubjectControl, documentOffset, results, true);
        }
        if (results.isEmpty()) {
            iter = this.fProposalKeys.iterator();
            while (iter.hasNext()) {
                this.addProposal((String)iter.next(), contentAssistSubjectControl, documentOffset, results, false);
            }
        }
        return results.toArray(new ICompletionProposal[results.size()]);
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    private void addProposal(String proposalKey, IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset, List results, boolean filter) {
        String proposal = (String)fgProposalStrings.get(proposalKey);
        if (filter) {
            String selection = null;
            try {
                selection = contentAssistSubjectControl.getDocument().get(documentOffset - 1, 1);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (selection == null || selection.length() == 0 || proposal.length() == 0 || proposal.charAt(0) != selection.charAt(0)) {
                return;
            }
            proposal = proposal.substring(1);
        }
        String displayString = this.getString(proposalKey, "displayString");
        String additionalInfo = this.getString(proposalKey, "additionalInfo");
        IContextInformation info = this.createContextInformation(proposalKey);
        int relativeOffset = proposal.length();
        results.add(new CompletionProposal(proposal, documentOffset, 0, Math.max(0, relativeOffset), null, displayString, info, additionalInfo));
    }

    private IContextInformation createContextInformation(String proposalKey) {
        return null;
    }

    private String getString(String proposalKey, String type) {
        return SearchMessages.getString("FindReplace.regExContentAssist." + type + "." + proposalKey);
    }
}

