/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.formatter;

import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntEditorPreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;

public class FormattingPreferences {
    IPreferenceStore fPrefs = AntUIPlugin.getDefault().getPreferenceStore();

    public String getCanonicalIndent() {
        String canonicalIndent;
        if (!this.useSpacesInsteadOfTabs()) {
            canonicalIndent = "\t";
        } else {
            String tab = "";
            int i = 0;
            while (i < this.getTabWidth()) {
                tab = tab.concat(" ");
                ++i;
            }
            canonicalIndent = tab;
        }
        return canonicalIndent;
    }

    public int getMaximumLineWidth() {
        return this.fPrefs.getInt("formatter_max_line_length");
    }

    public boolean wrapLongTags() {
        return this.fPrefs.getBoolean("formatter_wrap_long");
    }

    public boolean alignElementCloseChar() {
        return this.fPrefs.getBoolean("formatter_align");
    }

    public int getTabWidth() {
        return this.fPrefs.getInt("formatter_tab_size");
    }

    public boolean useSpacesInsteadOfTabs() {
        return !this.fPrefs.getBoolean(AntEditorPreferenceConstants.FORMATTER_TAB_CHAR);
    }

    public static boolean affectsFormatting(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.startsWith("formatter_align") || property.startsWith("formatter_max_line_length") || property.startsWith(AntEditorPreferenceConstants.FORMATTER_TAB_CHAR) || property.startsWith("formatter_tab_size") || property.startsWith("formatter_wrap_long");
    }

    public void setPreferenceStore(IPreferenceStore prefs) {
        this.fPrefs = prefs;
    }
}

